/*
 * Decompiled with CFR 0.152.
 */
package timon.common.components;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import timon.common.components.GuiUtil;
import timon.common.internal.Icons;

public class BrowseField
extends JPanel {
    private JTextField textField;
    private JButton button;

    public BrowseField() {
        this(new JTextField());
    }

    public BrowseField(JTextField textField) {
        this.textField = textField;
        this.button = new JButton(Icons.get("browseImage"));
        this.button.setPreferredSize(new Dimension(21, 21));
        this.setLayout(new BorderLayout(2, 2));
        this.add((Component)textField, "Center");
        this.add((Component)this.button, "East");
    }

    public String getText() {
        return this.textField.getText();
    }

    public JButton getButton() {
        return this.button;
    }

    public JTextField getTextField() {
        return this.textField;
    }

    public void setText(String text) {
        this.textField.setText(text);
    }

    public void setEnabled(boolean e) {
        super.setEnabled(e);
        GuiUtil.recursiveSetEnabled(this, e);
    }

    public void setOpaque(boolean o) {
        super.setOpaque(o);
        if (this.button != null) {
            this.button.setOpaque(o);
        }
    }
}

