/*
 * Decompiled with CFR 0.152.
 */
package timon.common.components;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import timon.common.components.BreadCrumbsRenderer;
import timon.common.components.GuiUtil;

public class BreadCrumbs
extends JPanel {
    public static final String PROP_ITEM_ADD = "itemAdded";
    public static final String PROP_ITEM_REMOVE = "itemRemoved";
    private BreadCrumbsRenderer renderer;
    private Icon arrowIcon;
    private List<Object> list;
    private Map<Object, Link> links;
    private List<ActionListener> actionListeners;

    public BreadCrumbs(Icon arrowIcon) {
        this.arrowIcon = arrowIcon;
        this.list = new ArrayList<Object>();
        this.links = new HashMap<Object, Link>();
        this.actionListeners = new ArrayList<ActionListener>();
        this.renderer = new BreadCrumbsRenderer(){

            public Icon getIcon(Object item) {
                return null;
            }

            public String getLabel(Object item) {
                return String.valueOf(item);
            }
        };
        this.setLayout(new FlowLayout(0));
    }

    public void addItem(Object item) {
        if (item == null) {
            throw new IllegalArgumentException("BreadCrumbs.addItem() :: null values are not allowed");
        }
        this.list.add(item);
        Link link = this.createLink(item);
        this.links.put(item, link);
        this.add(link);
        this.firePropertyChange(PROP_ITEM_ADD, null, item);
        this.validate();
        this.repaint();
    }

    public void removeItem() {
        if (!this.list.isEmpty()) {
            Object item = this.list.get(this.list.size() - 1);
            this.list.remove(this.list.size() - 1);
            this.remove(this.links.remove(item));
            this.firePropertyChange(PROP_ITEM_REMOVE, item, null);
            this.repaint();
        }
    }

    protected Link createLink(final Object item) {
        JButton button = new JButton(this.renderer.getLabel(item)){

            public void paint(Graphics graphics) {
                Graphics2D g = (Graphics2D)graphics;
                int w = this.getWidth();
                int h = this.getHeight();
                g.setBackground(this.getParent().getBackground());
                g.clearRect(0, 0, w, h);
                if (!this.model.isRollover()) {
                    Color c1 = new Color(240, 240, 240, 127);
                    Color c2 = new Color(127, 127, 127, 127);
                    GuiUtil.drawSelectionRect(g, 0, 0, w, h, c1, c2);
                } else {
                    GuiUtil.drawGradientSelectionRect(g, 0, 0, w, h);
                }
                if (this.model.isArmed()) {
                    g.translate(1, 1);
                }
                super.paint(g);
                if (this.model.isArmed()) {
                    g.translate(-1, -1);
                }
            }
        };
        button.setIcon(this.renderer.getIcon(item));
        button.setOpaque(false);
        button.setBorder(new EmptyBorder(0, 0, 0, 0));
        button.setBackground(new Color(0, 0, 0, 0));
        button.setCursor(Cursor.getPredefinedCursor(12));
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                BreadCrumbs.this.fireItemSelected(item);
            }
        });
        Link link = new Link(button, this.list.size() - 1);
        return link;
    }

    protected void paintComponent(Graphics graphics) {
        int w = this.getWidth();
        int h = this.getHeight();
        Graphics2D g = (Graphics2D)graphics;
        g.setBackground(this.getBackground());
        g.clearRect(0, 0, w, h);
    }

    public void addActionListener(ActionListener al) {
        this.actionListeners.add(al);
    }

    public void removeActionListener(ActionListener al) {
        this.actionListeners.remove(al);
    }

    public void fireItemSelected(Object item) {
        final ActionListener[] al = new ActionListener[this.actionListeners.size()];
        this.actionListeners.toArray(al);
        final ActionEvent event = new ActionEvent(item, 0, "itemSelected");
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ActionListener[] actionListenerArray = al;
                int n = al.length;
                int n2 = 0;
                while (n2 < n) {
                    ActionListener l = actionListenerArray[n2];
                    l.actionPerformed(event);
                    ++n2;
                }
            }
        });
    }

    public BreadCrumbsRenderer getRenderer() {
        return this.renderer;
    }

    public void setRenderer(BreadCrumbsRenderer renderer) {
        this.renderer = renderer;
    }

    private class Link
    extends JPanel {
        private int index;

        public Link(JComponent label, int index) {
            this.index = index;
            this.setLayout(new BorderLayout(5, 5));
            this.add((Component)label, "Center");
            this.add((Component)this.createArrowLabel(), "East");
        }

        protected JComponent createArrowLabel() {
            JLabel arrow = new JLabel(){

                public void paint(Graphics g) {
                    if (BreadCrumbs.this.list.size() - 1 != Link.this.index) {
                        super.paint(g);
                    }
                }
            };
            arrow.setIcon(BreadCrumbs.this.arrowIcon);
            return arrow;
        }
    }
}

