/*
 * Decompiled with CFR 0.152.
 */
package timon.common.collections;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import timon.common.collections.Typed;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypedMap {
    private Map<String, Typed> map = new HashMap<String, Typed>();

    public void put(Typed t) {
        this.map.put(t.getId(), t);
    }

    public Typed remove(String id) {
        return this.map.remove(id);
    }

    public Set<Map.Entry<String, Typed>> getEntrySet() {
        return this.map.entrySet();
    }

    public Typed get(String id) {
        return this.map.get(id);
    }

    public Object getValue(String id) {
        Typed t = this.get(id);
        if (t != null) {
            return t.getValue();
        }
        return null;
    }

    public int getIntValue(String id, int defaultValue) {
        Object value = this.getValue(id);
        return value instanceof Integer ? (Integer)value : defaultValue;
    }

    public long getLongValue(String id, long defaultValue) {
        Object value = this.getValue(id);
        return value instanceof Long ? (Long)value : defaultValue;
    }

    public float getFloatValue(String id, float defaultValue) {
        Object value = this.getValue(id);
        return value instanceof Float ? ((Float)value).floatValue() : defaultValue;
    }

    public double getDoubleValue(String id, double defaultValue) {
        Object value = this.getValue(id);
        return value instanceof Double ? (Double)value : defaultValue;
    }

    public boolean getBooleanValue(String id, boolean defaultValue) {
        Object value = this.getValue(id);
        return value instanceof Boolean ? (Boolean)value : defaultValue;
    }

    public String getStringValue(String id, String defaultValue) {
        Object value = this.getValue(id);
        return value instanceof String ? (String)value : defaultValue;
    }

    public void setValue(String id, Object value) {
        Typed t = this.get(id);
        if (t != null) {
            t.setValue(value);
        } else {
            this.put(new Typed(id, Object.class, value));
        }
    }
}

