/*
 * Decompiled with CFR 0.152.
 */
package timon.common.collections;

import java.awt.Rectangle;
import timon.common.collections.Tuple2;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RPlusTree {
    private Tuple2<Rectangle, Object> temp = new Tuple2();
    private int maxChildren = 4;
    private Node root = new Node(new Rectangle(), null);

    public static void main(String[] args) {
        RPlusTree rtree = new RPlusTree();
        rtree.add(new Rectangle(0, 0, 100, 100));
        rtree.add(new Rectangle(100, 0, 100, 100));
        rtree.add(new Rectangle(200, 50, 100, 100));
        rtree.add(new Rectangle(0, 100, 100, 100));
        rtree.add(new Rectangle(100, 100, 100, 100));
        System.out.println(rtree.toString());
    }

    public void add(Rectangle r) {
        this.add(r, null);
    }

    public void add(Rectangle r, Object value) {
        this.add(this.root, r, value);
    }

    public void clear() {
        this.root = new Node(new Rectangle(), null);
    }

    protected void add(Node node, Rectangle r, Object value) {
        boolean added = false;
        int n = 0;
        while (n < node.childrenL) {
            Node c = node.children[n];
            if (!c.isDataElement() && c.intersects(r)) {
                this.add(c, r, value);
                added = true;
            }
            ++n;
        }
        if (!added) {
            node.add(r, value);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.printNode(sb, "", this.root);
        return sb.toString();
    }

    protected void printNode(StringBuilder sb, String indent, Node node) {
        if (node.isDataElement()) {
            sb.append(String.valueOf(indent) + String.format("DATA (%d, %d, %d, %d)\n", node.rect.x, node.rect.y, node.rect.width, node.rect.height));
        } else {
            sb.append(String.valueOf(indent) + String.format("RNode (%d, %d, %d, %d) {\n", node.rect.x, node.rect.y, node.rect.width, node.rect.height));
            int n = 0;
            while (n < node.childrenL) {
                this.printNode(sb, String.valueOf(indent) + "  ", node.children[n]);
                ++n;
            }
            sb.append(String.valueOf(indent) + "}\n");
        }
    }

    public Rectangle getRectangle(int x, int y) {
        Tuple2<Rectangle, Object> t = this.get(this.root, x, y);
        return t != null ? (Rectangle)t.x : null;
    }

    public Object getValue(int x, int y) {
        Tuple2<Rectangle, Object> t = this.get(this.root, x, y);
        return t != null ? t.y : null;
    }

    protected Tuple2<Rectangle, Object> get(Node node, int x, int y) {
        int n = 0;
        while (n < node.childrenL) {
            Node c = node.children[n];
            if (c.rect.contains(x, y)) {
                if (c.isDataElement()) {
                    this.temp.x = c.rect;
                    this.temp.y = c.value;
                    return this.temp;
                }
                return this.get(c, x, y);
            }
            ++n;
        }
        return null;
    }

    private class Node {
        Object value;
        Rectangle rect;
        Node[] children;
        int childrenL;

        Node(Rectangle r, Object v) {
            this.children = new Node[RPlusTree.this.maxChildren + 1];
            this.childrenL = 0;
            this.value = v;
            this.rect = new Rectangle(r);
        }

        void recalculateBounds() {
            this.calculateBounds(this.rect, this.children, 0, this.childrenL);
        }

        void calculateBounds(Rectangle r, Node[] nodes, int off, int len) {
            if (len == 0) {
                r.height = 0;
                r.width = 0;
            } else {
                int minX = nodes[off].rect.x;
                int minY = nodes[off].rect.y;
                int maxX = nodes[off].rect.x + nodes[off].rect.width;
                int maxY = nodes[off].rect.y + nodes[off].rect.height;
                int n = off + 1;
                while (n < off + len) {
                    minX = Math.min(minX, this.children[n].rect.x);
                    minY = Math.min(minY, this.children[n].rect.y);
                    maxX = Math.max(maxX, this.children[n].rect.x + this.children[n].rect.width);
                    maxY = Math.max(maxY, this.children[n].rect.y + this.children[n].rect.height);
                    ++n;
                }
                r.x = minX;
                r.y = minY;
                r.width = maxX - minX;
                r.height = maxY - minY;
            }
        }

        boolean add(Rectangle r, Object v) {
            int n = 0;
            while (n < this.childrenL) {
                if (this.children[n].equals(r)) {
                    return false;
                }
                ++n;
            }
            this.children[this.childrenL] = new Node(r, v);
            ++this.childrenL;
            if (this.childrenL > RPlusTree.this.maxChildren) {
                this.split();
            } else {
                this.recalculateBounds();
            }
            return true;
        }

        void split() {
            Node n2;
            Node n1;
            int best = 0;
            int bestArea = Integer.MAX_VALUE;
            Rectangle r = new Rectangle();
            int n = 1;
            while (n < this.children.length - 1) {
                this.calculateBounds(r, this.children, 0, n);
                int a1 = r.width * r.height;
                this.calculateBounds(r, this.children, n, this.childrenL - n);
                int a2 = r.width * r.height;
                if (a1 + a2 < bestArea) {
                    best = n;
                    bestArea = a1 + a2;
                }
                ++n;
            }
            if (best == 1) {
                n1 = this.children[0];
            } else {
                this.calculateBounds(r, this.children, 0, best);
                n1 = new Node(r, null);
                int n3 = 0;
                while (n3 < best) {
                    n1.children[n3] = this.children[n3];
                    ++n3;
                }
                n1.childrenL = best;
            }
            if (this.childrenL - best == 1) {
                n2 = this.children[best];
            } else {
                this.calculateBounds(r, this.children, best, this.childrenL - best);
                n2 = new Node(r, null);
                int n4 = best;
                while (n4 < this.childrenL) {
                    n2.children[n4 - best] = this.children[n4];
                    ++n4;
                }
                n2.childrenL = this.childrenL - best;
            }
            this.children[0] = n1;
            this.children[1] = n2;
            this.childrenL = 2;
            this.recalculateBounds();
        }

        boolean isDataElement() {
            return this != RPlusTree.this.root && this.childrenL == 0;
        }

        boolean intersects(Rectangle r) {
            return this.rect.intersects(r);
        }
    }
}

