/*
 * Decompiled with CFR 0.152.
 */
package timon.common.collections;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphNode<E> {
    public static final String PROP_VALUE = "value";
    public static final String PROP_INCOMING_NODE_ADDED = "incomingAdded";
    public static final String PROP_INCOMING_NODE_REMOVED = "incomingRemoved";
    public static final String PROP_OUTGOING_NODE_ADDED = "outgoingAdded";
    public static final String PROP_OUTGOING_NODE_REMOVED = "outgoingRemoved";
    private E value;
    private List<GraphNode<E>> incoming = new LinkedList<GraphNode<E>>();
    private List<GraphNode<E>> outgoing = new LinkedList<GraphNode<E>>();
    private List<PropertyChangeListener> propertyListeners = new LinkedList<PropertyChangeListener>();
    private boolean mark;

    public GraphNode() {
    }

    public GraphNode(E value) {
        this();
        this.setValue(value);
    }

    public void addOutgoingConnection(GraphNode<E> other) {
        if (this.outgoing.contains(other)) {
            return;
        }
        this.outgoing.add(other);
        other.addIncomingConnection(this);
        this.firePropertyChanged(PROP_OUTGOING_NODE_ADDED, null, other);
    }

    public void addIncomingConnection(GraphNode<E> other) {
        if (this.incoming.contains(other)) {
            return;
        }
        this.incoming.add(other);
        other.addOutgoingConnection(this);
        this.firePropertyChanged(PROP_INCOMING_NODE_ADDED, null, other);
    }

    public void removeOutgoingConnection(GraphNode<E> other) {
        if (!this.outgoing.contains(other)) {
            return;
        }
        this.outgoing.remove(other);
        other.removeIncomingConnection(this);
        this.firePropertyChanged(PROP_OUTGOING_NODE_REMOVED, other, null);
    }

    public void removeIncomingConnection(GraphNode<E> other) {
        if (!this.incoming.contains(other)) {
            return;
        }
        this.incoming.remove(other);
        other.removeOutgoingConnection(this);
        this.firePropertyChanged(PROP_INCOMING_NODE_REMOVED, other, null);
    }

    public void removeAllOutgoingConnections() {
        ArrayList<GraphNode<E>> copy = new ArrayList<GraphNode<E>>(this.outgoing);
        for (GraphNode graphNode : copy) {
            this.removeOutgoingConnection(graphNode);
        }
    }

    public void removeAllIncomingConnections() {
        ArrayList<GraphNode<E>> copy = new ArrayList<GraphNode<E>>(this.incoming);
        for (GraphNode graphNode : copy) {
            this.removeIncomingConnection(graphNode);
        }
    }

    public List<GraphNode<E>> delete() {
        List<GraphNode<E>> detached = this.findAll();
        this.removeAllIncomingConnections();
        this.removeAllOutgoingConnections();
        return detached;
    }

    public List<GraphNode<E>> findAll() {
        ArrayList<GraphNode<E>> nodes = new ArrayList<GraphNode<E>>();
        this.findAllAndMark(nodes);
        for (GraphNode graphNode : nodes) {
            graphNode.unmark();
        }
        return nodes;
    }

    private void findAllAndMark(List<GraphNode<E>> result) {
        if (this.mark) {
            return;
        }
        this.mark = true;
        result.add(this);
        for (GraphNode<E> node : this.outgoing) {
            super.findAllAndMark(result);
        }
    }

    public boolean contains(E find) {
        if (this.mark) {
            return false;
        }
        if (this.value == find) {
            return true;
        }
        boolean found = false;
        this.mark = true;
        for (GraphNode<E> node : this.outgoing) {
            if (!node.contains(find)) continue;
            found = true;
            break;
        }
        this.mark = false;
        return found;
    }

    public void mark() {
        this.mark = true;
    }

    public void unmark() {
        this.mark = false;
    }

    public void addPropertyListener(PropertyChangeListener pcl) {
        this.propertyListeners.add(pcl);
    }

    public void removePropertyListener(PropertyChangeListener pcl) {
        this.propertyListeners.remove(pcl);
    }

    public void firePropertyChanged(String name, Object oldValue, Object newValue) {
        this.firePropertyChanged(new PropertyChangeEvent(this, name, oldValue, newValue));
    }

    public void firePropertyChanged(PropertyChangeEvent event) {
        PropertyChangeListener[] list = new PropertyChangeListener[this.propertyListeners.size()];
        PropertyChangeListener[] propertyChangeListenerArray = list = this.propertyListeners.toArray(list);
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            PropertyChangeListener pl = propertyChangeListenerArray[n2];
            pl.propertyChange(event);
            ++n2;
        }
    }

    public E getValue() {
        return this.value;
    }

    public List<GraphNode<E>> getIncomingConnections() {
        return this.incoming;
    }

    public List<GraphNode<E>> getOutgoingConnections() {
        return this.outgoing;
    }

    public boolean isMarked() {
        return this.mark;
    }

    public void setValue(E value) {
        E oldValue = this.value;
        this.value = value;
        this.firePropertyChanged(PROP_VALUE, oldValue, this.value);
    }
}

