/*
 * Decompiled with CFR 0.152.
 */
package timon.common.collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilteredMap<K, V>
implements Map<K, V> {
    private Map<K, V> map;
    private Set<K> validKeys;

    public FilteredMap(Map<K, V> map, Collection<K> validKeys) {
        this.map = map;
        this.validKeys = new HashSet<K>(validKeys);
    }

    @Override
    public void clear() {
        this.validKeys.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.validKeys.contains(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        HashSet<Map.Entry<K, V>> entrySet = new HashSet<Map.Entry<K, V>>();
        block0: for (K key : this.validKeys) {
            for (Map.Entry<K, V> entry : this.map.entrySet()) {
                if (key != entry.getKey() && !key.equals(entry.getKey())) continue;
                entrySet.add(entry);
                continue block0;
            }
        }
        return entrySet;
    }

    @Override
    public Set<K> keySet() {
        return this.validKeys;
    }

    @Override
    public V put(K key, V value) {
        this.validKeys.add(key);
        return this.map.put(key, value);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> t) {
        for (Map.Entry<K, V> entry : t.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public V remove(Object key) {
        if (this.containsKey(key)) {
            return this.map.remove(key);
        }
        return null;
    }

    @Override
    public int size() {
        int t = 0;
        for (K key : this.keySet()) {
            if (!this.map.containsKey(key)) continue;
            ++t;
        }
        return t;
    }

    @Override
    public Collection<V> values() {
        ArrayList<V> values = new ArrayList<V>();
        for (Map.Entry<K, V> entry : this.map.entrySet()) {
            if (!this.containsKey(entry.getKey())) continue;
            values.add(entry.getValue());
        }
        return values;
    }

    @Override
    public V get(Object key) {
        if (this.containsKey(key)) {
            return this.map.get(key);
        }
        return null;
    }

    @Override
    public boolean isEmpty() {
        for (K key : this.keySet()) {
            if (!this.map.containsKey(key)) continue;
            return false;
        }
        return true;
    }
}

