/*
 * Decompiled with CFR 0.152.
 */
package timon.common.collections;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicTreeNode<E> {
    public List<BasicTreeNode<? extends E>> children;
    public E value;

    public BasicTreeNode() {
        this(null);
    }

    public BasicTreeNode(E value) {
        this.value = value;
        this.children = new LinkedList<BasicTreeNode<? extends E>>();
    }

    public void addChild(BasicTreeNode<? extends E> node) {
        this.addChild(this.children.size(), node);
    }

    public void addChild(int index, BasicTreeNode<? extends E> node) {
        if ((index = Math.max(0, index)) >= this.children.size()) {
            this.children.add(node);
        } else {
            this.children.add(index, node);
        }
    }

    public void addChildren(Collection<BasicTreeNode<? extends E>> c) {
        this.children.addAll(c);
    }

    public void removeChild(int index) {
        this.children.remove(index);
    }

    public void removeChild(BasicTreeNode<? extends E> node) {
        this.children.remove(node);
    }

    public void removeAllChildren() {
        this.children.clear();
    }

    public void sortChildren(final Comparator<Object> comp) {
        Collections.sort(this.children, new Comparator<BasicTreeNode<? extends E>>(){

            @Override
            public int compare(BasicTreeNode<? extends E> n0, BasicTreeNode<? extends E> n1) {
                return comp.compare(n0.getValue(), n1.getValue());
            }
        });
        for (BasicTreeNode<E> child : this.children) {
            child.sortChildren(comp);
        }
    }

    public boolean contains(Object object) {
        if (object == this.value) {
            return true;
        }
        for (BasicTreeNode<E> node : this.children) {
            if (!node.contains(object)) continue;
            return true;
        }
        return false;
    }

    public E getValue() {
        return this.value;
    }

    public List<BasicTreeNode<? extends E>> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    public int getChildCount() {
        return this.children.size();
    }

    public BasicTreeNode<? extends E> getChild(int index) {
        return this.children.get(index);
    }

    public Iterator<E> getTreeValueIterator() {
        final Iterator<BasicTreeNode<? extends E>> it = this.children.iterator();
        return new Iterator<E>(){
            boolean ownValueReturned = false;
            Iterator<? extends E> it2;

            @Override
            public boolean hasNext() {
                return !this.ownValueReturned || it.hasNext() || this.it2 != null && this.it2.hasNext();
            }

            /*
             * Unable to fully structure code
             */
            @Override
            public E next() {
                if (this.ownValueReturned) ** GOTO lbl9
                this.ownValueReturned = true;
                this.it2 = it.hasNext() != false ? ((BasicTreeNode)it.next()).getTreeValueIterator() : null;
                return BasicTreeNode.this.getValue();
lbl-1000:
                // 1 sources

                {
                    if (this.it2.hasNext()) {
                        return this.it2.next();
                    }
                    if (!it.hasNext()) continue;
                    this.it2 = ((BasicTreeNode)it.next()).getTreeValueIterator();
lbl9:
                    // 3 sources

                    ** while (this.hasNext())
                }
lbl10:
                // 1 sources

                return null;
            }

            @Override
            public void remove() {
            }
        };
    }

    public void setValue(E value) {
        this.value = value;
    }
}

