/*
 * Decompiled with CFR 0.152.
 */
package timon.common;

import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Semaphore;
import timon.common.Log;

public class ThreadPool {
    private volatile boolean killed;
    private Semaphore finished;
    private ExecThread[] threads;
    private List<Runnable> tasks;
    private int taskCount;

    public ThreadPool() {
        this(-1);
    }

    public ThreadPool(int size) {
        if (size <= 0) {
            size = ThreadPool.getDefaultSize();
        }
        this.finished = new Semaphore(0);
        this.threads = new ExecThread[size];
        int n = 0;
        while (n < size) {
            this.threads[n] = new ExecThread();
            ++n;
        }
        this.tasks = new LinkedList<Runnable>();
    }

    public void dispose() {
        this.killed = true;
        ExecThread[] execThreadArray = this.threads;
        int n = this.threads.length;
        int n2 = 0;
        while (n2 < n) {
            ExecThread t = execThreadArray[n2];
            t.onTaskAdded();
            ++n2;
        }
    }

    public void waitFor() {
        try {
            this.finished.acquire(this.taskCount);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.finished.release(this.taskCount);
    }

    public synchronized void addTask(Runnable runnable) {
        ++this.taskCount;
        this.tasks.add(runnable);
        ExecThread[] execThreadArray = this.threads;
        int n = this.threads.length;
        int n2 = 0;
        while (n2 < n) {
            ExecThread t = execThreadArray[n2];
            t.onTaskAdded();
            ++n2;
        }
    }

    protected static int getDefaultSize() {
        return Math.round(1.5f * (float)ThreadPool.getCPUCount());
    }

    public static int getCPUCount() {
        return Runtime.getRuntime().availableProcessors();
    }

    public void start() {
        int n = 0;
        while (n < this.threads.length) {
            new Thread((Runnable)this.threads[n], "ThreadPool.ExecThread[" + n + "]").start();
            ++n;
        }
    }

    protected synchronized Runnable getFirstTask() {
        if (this.tasks.isEmpty()) {
            return null;
        }
        return this.tasks.remove(0);
    }

    public class ExecThread
    implements Runnable {
        private Semaphore lock = new Semaphore(0);
        private Runnable task;

        public void run() {
            while (!ThreadPool.this.killed) {
                try {
                    this.lock.acquire();
                }
                catch (InterruptedException e) {
                    Log.error(e);
                }
                this.task = ThreadPool.this.getFirstTask();
                if (this.task == null) continue;
                try {
                    this.task.run();
                }
                catch (Exception e) {
                    Log.error(e);
                }
                ThreadPool.this.finished.release();
                this.task = null;
            }
        }

        public void onTaskAdded() {
            this.lock.release();
        }
    }
}

