/*
 * Decompiled with CFR 0.152.
 */
package timon.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import java.util.regex.Matcher;

public class StringUtil {
    public static boolean isASCII(String s) {
        int[] unicode = StringUtil.toUnicodeArray(s);
        int n = 0;
        while (n < unicode.length) {
            if (unicode[n] > 127) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public static boolean isWhitespace(String s) {
        if (s.length() == 0) {
            return true;
        }
        int[] unicode = StringUtil.toUnicodeArray(s);
        int n = 0;
        while (n < unicode.length) {
            if (!Character.isWhitespace(unicode[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public static String filterId(String id) {
        return StringUtil.filterID(0, id);
    }

    public static String filterID(int offset, String s) {
        if (s == null) {
            return "";
        }
        StringBuilder newString = new StringBuilder();
        int n = 0;
        while (n < s.length()) {
            char c = s.charAt(n);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') {
                newString.append(c);
            } else if ((offset > 0 || newString.length() > 0) && (c >= '0' && c <= '9' || c == '_')) {
                newString.append(c);
            }
            ++n;
        }
        return newString.toString();
    }

    public static boolean isValidId(String s) {
        if (s == null || s.length() == 0) {
            return false;
        }
        int[] c = StringUtil.toUnicodeArray(s);
        int n = 0;
        while (n < c.length) {
            if (!(c[n] >= 97 && c[n] <= 122 || c[n] >= 65 && c[n] <= 90)) {
                if (n > 0) {
                    if ((c[n] < 48 || c[n] > 57) && c[n] != 95) {
                        return false;
                    }
                } else {
                    return false;
                }
            }
            ++n;
        }
        return true;
    }

    public static String replaceAllNoRegex(String string, String pattern, String replacement) {
        StringBuilder buffer = new StringBuilder();
        int n = 0;
        while (n < string.length()) {
            if (string.regionMatches(n, pattern, 0, pattern.length())) {
                buffer.append(replacement);
                n += pattern.length() - 1;
            } else {
                buffer.append(string.charAt(n));
            }
            ++n;
        }
        return buffer.toString();
    }

    public static String stripExtension(String filename) {
        int index = filename.lastIndexOf(46);
        if (index >= 0) {
            return filename.substring(0, index);
        }
        return filename;
    }

    public static String toString(int number, int digits) {
        String s = Integer.toString(number);
        StringBuilder sb = new StringBuilder();
        int n = digits - s.length();
        while (n > 0) {
            sb.append('0');
            --n;
        }
        sb.append(s);
        return sb.toString();
    }

    public static String repeatString(String pattern, int times) {
        StringBuilder sb = new StringBuilder();
        int n = 0;
        while (n < times) {
            sb.append(pattern);
            ++n;
        }
        return sb.toString();
    }

    public static String getRandomId() {
        return StringUtil.getRandomString(8);
    }

    public static String getRandomString(int length) {
        return StringUtil.getRandomString(length, new Random());
    }

    public static String getRandomString(int length, Random random) {
        int i = (int)(random.nextFloat() * 52.0f);
        char c = (char)(i >= 26 ? 65 + i - 26 : 97 + i);
        if (length > 0) {
            return String.valueOf(c) + StringUtil.getRandomString(length - 1, random);
        }
        return Character.toString(c);
    }

    public static int[] toUnicodeArray(String s) {
        int[] string = new int[s.length()];
        char[] chars = s.toCharArray();
        int t = 0;
        int n = 0;
        while (n < chars.length) {
            if (Character.isHighSurrogate(chars[n])) {
                string[t] = s.codePointAt(n);
                ++n;
                ++t;
            } else {
                string[t] = chars[n];
                ++t;
            }
            ++n;
        }
        return Arrays.copyOfRange(string, 0, t);
    }

    public static String[] getOuterRegexMatches(Matcher matcher) {
        ArrayList<String> result = new ArrayList<String>();
        int index = 0;
        int n = 1;
        while (n <= matcher.groupCount()) {
            if (matcher.start(n) >= index) {
                result.add(matcher.group(n));
                index = matcher.end(n);
            }
            ++n;
        }
        return result.toArray(new String[result.size()]);
    }
}

