/*
 * Decompiled with CFR 0.152.
 */
package timon.common;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.LinkedList;
import java.util.List;
import javax.swing.SwingUtilities;

public class ProcessOutputReader {
    private List<PropertyChangeListener> propertyListeners = new LinkedList<PropertyChangeListener>();
    private int readChunkSize = 8192;
    private int initialTextBufferSize = 1024;
    private int inBufferSize = 131126;
    private int errBufferSize = 32768;
    private int returnTextMaxLines = 8;
    private int returnTextMaxChars = 8192;
    private long sleepTime = 10L;
    private long updateInterval = 200L;

    public synchronized String read(Process process) throws IOException {
        StringBuilder buffer = new StringBuilder(this.initialTextBufferSize);
        char[] charBuffer = new char[this.readChunkSize];
        BufferedReader in = new BufferedReader(new InputStreamReader(process.getInputStream()), this.inBufferSize);
        BufferedReader err = new BufferedReader(new InputStreamReader(process.getErrorStream()), this.errBufferSize);
        boolean finished = false;
        int lastNewLine = -1;
        int index = 0;
        long t = System.currentTimeMillis();
        while (!finished) {
            try {
                process.exitValue();
                finished = true;
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                // empty catch block
            }
            int v = 0;
            while (v < 2) {
                int l = -1;
                if (v == 0) {
                    if (in.ready()) {
                        l = in.read(charBuffer);
                    }
                } else if (v == 1 && err.ready()) {
                    l = err.read(charBuffer);
                }
                if (l < 0) {
                    if (v == 0) {
                        try {
                            Thread.sleep(this.sleepTime);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                } else {
                    int x = 0;
                    while (x < l) {
                        if (charBuffer[x] == '\r') {
                            index = lastNewLine + 1;
                        } else {
                            if (charBuffer[x] == '\n') {
                                lastNewLine = index = buffer.length();
                            }
                            if (index < buffer.length()) {
                                buffer.setCharAt(index, charBuffer[x]);
                            } else {
                                buffer.append(charBuffer[x]);
                            }
                            ++index;
                        }
                        ++x;
                    }
                }
                ++v;
            }
            long newT = System.currentTimeMillis();
            if (newT - t <= this.updateInterval) continue;
            t = newT;
            this.fireTextChanged(this.formatText(buffer));
        }
        in.close();
        err.close();
        this.fireTextChanged(this.formatText(buffer));
        return buffer.toString();
    }

    protected String formatText(StringBuilder buffer) {
        int v = 0;
        int index1 = buffer.length() - 1;
        while (index1 >= 0 && v < this.returnTextMaxLines) {
            char c = buffer.charAt(index1);
            if (c == '\n') {
                ++v;
            }
            --index1;
        }
        int index2 = buffer.indexOf("\n", buffer.length() - this.returnTextMaxChars) + 1;
        return buffer.substring(Math.max(++index1, index2));
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener pcl) {
        this.propertyListeners.add(pcl);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener pcl) {
        this.propertyListeners.remove(pcl);
    }

    public void fireTextChanged(final String text) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                for (PropertyChangeListener pcl : ProcessOutputReader.this.propertyListeners) {
                    pcl.propertyChange(new PropertyChangeEvent(this, "text", null, text));
                }
            }
        });
    }

    public int getReadChunkSize() {
        return this.readChunkSize;
    }

    public int getInitialTextBufferSize() {
        return this.initialTextBufferSize;
    }

    public int getInBufferSize() {
        return this.inBufferSize;
    }

    public int getErrBufferSize() {
        return this.errBufferSize;
    }

    public int getReturnTextMaxLines() {
        return this.returnTextMaxLines;
    }

    public int getReturnTextMaxChars() {
        return this.returnTextMaxChars;
    }

    public long getSleepTime() {
        return this.sleepTime;
    }

    public long getUpdateInterval() {
        return this.updateInterval;
    }

    public void setReadChunkSize(int readChunkSize) {
        this.readChunkSize = readChunkSize;
    }

    public void setInitialTextBufferSize(int initialTextBufferSize) {
        this.initialTextBufferSize = initialTextBufferSize;
    }

    public void setInBufferSize(int inBufferSize) {
        this.inBufferSize = inBufferSize;
    }

    public void setErrBufferSize(int errBufferSize) {
        this.errBufferSize = errBufferSize;
    }

    public void setReturnTextMaxLines(int returnTextMaxLines) {
        this.returnTextMaxLines = returnTextMaxLines;
    }

    public void setReturnTextMaxChars(int returnTextMaxChars) {
        this.returnTextMaxChars = returnTextMaxChars;
    }

    public void setSleepTime(long sleepTime) {
        this.sleepTime = sleepTime;
    }

    public void setUpdateInterval(long updateInterval) {
        this.updateInterval = updateInterval;
    }
}

