/*
 * Decompiled with CFR 0.152.
 */
package timon.common;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.xml.sax.SAXException;
import timon.common.Log;
import timon.common.collections.Tuple2;
import timon.common.collections.Typed;
import timon.common.collections.TypedMap;
import timon.common.components.StringSortedListModel;
import timon.common.xml.XmlElement;
import timon.common.xml.XmlNode;
import timon.common.xml.XmlReader;
import timon.common.xml.XmlTextNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreferenceStore {
    protected TypedMap store = new TypedMap();
    protected Map<String, SaverLoader> handlerStore = new HashMap<String, SaverLoader>();
    protected Set<Tuple2<String, String>> classNameMapping = new HashSet<Tuple2<String, String>>();
    protected List<PropertyChangeListener> listeners = new ArrayList<PropertyChangeListener>();

    public PreferenceStore() {
        this.installDefaultHandlers(this.handlerStore);
    }

    protected void installDefaultHandlers(Map<String, SaverLoader> handlerStore) {
        handlerStore.put(String.class.getName(), new SaverLoader(){

            public Object fromXml(XmlElement element) {
                return !element.getChildren().isEmpty() ? element.getTextContent() : null;
            }
        });
        handlerStore.put(Integer.class.getName(), new SaverLoader(){

            public Object fromXml(XmlElement element) {
                return Integer.parseInt(element.getTextContent());
            }
        });
        handlerStore.put(Long.class.getName(), new SaverLoader(){

            public Object fromXml(XmlElement element) {
                return Long.parseLong(element.getTextContent());
            }
        });
        handlerStore.put(Float.class.getName(), new SaverLoader(){

            public Object fromXml(XmlElement element) {
                return Float.valueOf(Float.parseFloat(element.getTextContent()));
            }
        });
        handlerStore.put(Double.class.getName(), new SaverLoader(){

            public Object fromXml(XmlElement element) {
                return Double.parseDouble(element.getTextContent());
            }
        });
        handlerStore.put(Boolean.class.getName(), new SaverLoader(){

            public Object fromXml(XmlElement element) {
                return Boolean.parseBoolean(element.getTextContent());
            }
        });
        this.classNameMapping.add(new Tuple2<String, String>(String.class.getName(), "string"));
        this.classNameMapping.add(new Tuple2<String, String>(Integer.class.getName(), "int"));
        this.classNameMapping.add(new Tuple2<String, String>(Long.class.getName(), "long"));
        this.classNameMapping.add(new Tuple2<String, String>(Float.class.getName(), "float"));
        this.classNameMapping.add(new Tuple2<String, String>(Double.class.getName(), "double"));
        this.classNameMapping.add(new Tuple2<String, String>(Boolean.class.getName(), "boolean"));
    }

    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        this.listeners.add(pcl);
    }

    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        this.listeners.remove(pcl);
    }

    protected void firePropertyChanged(String name, Object v0, Object v1) {
        PropertyChangeListener[] ls;
        if (this.listeners.isEmpty()) {
            return;
        }
        PropertyChangeEvent event = new PropertyChangeEvent(this, name, v0, v1);
        PropertyChangeListener[] propertyChangeListenerArray = ls = this.listeners.toArray(new PropertyChangeListener[this.listeners.size()]);
        int n = ls.length;
        int n2 = 0;
        while (n2 < n) {
            PropertyChangeListener pcl = propertyChangeListenerArray[n2];
            pcl.propertyChange(event);
            ++n2;
        }
    }

    public void load(String filename) throws IOException {
        FileInputStream fin = new FileInputStream(filename);
        try {
            this.load(fin);
        }
        finally {
            fin.close();
        }
    }

    public void load(InputStream in) throws IOException {
        XmlReader reader = new XmlReader();
        try {
            XmlElement root = reader.read(in).getChild("root");
            if (root == null) {
                throw new IOException("Invalid preferences file, root node missing");
            }
            this.load(root);
        }
        catch (SAXException e) {
            throw new IOException(e);
        }
    }

    public void load(XmlElement root) throws IOException {
        for (XmlNode child : root.getChildren()) {
            if (!(child instanceof XmlElement)) continue;
            this.loadProperty((XmlElement)child);
        }
    }

    protected void loadProperty(XmlElement e) throws IOException {
        try {
            Class<?> baseClass = Class.forName(this.longName(e.getAttribute("baseClass")));
            String className = e.getAttribute("class");
            className = className == null ? baseClass.getName() : this.longName(className);
            SaverLoader handler = this.handlerStore.get(className);
            if (baseClass == null || handler == null) {
                Log.warning("Trying to load an unknown property type: " + className);
            } else {
                this.setProperty(new Typed(e.getAttribute("name"), baseClass, handler.fromXml(e)));
            }
        }
        catch (Exception exception) {
            throw new IOException(exception);
        }
    }

    public void save(String filename) throws IOException {
        FileOutputStream fout = new FileOutputStream(filename);
        try {
            this.save(fout);
        }
        finally {
            fout.close();
        }
    }

    public void save(OutputStream outStream) throws IOException {
        PrintWriter out = new PrintWriter(outStream);
        XmlElement root = new XmlElement("root");
        this.save(root);
        out.print(root.toXmlString());
        out.flush();
    }

    public void save(XmlElement root) {
        TreeMap<String, Typed> sorted = new TreeMap<String, Typed>(StringSortedListModel.createComparator());
        for (Map.Entry<String, Typed> entry : this.store.getEntrySet()) {
            sorted.put(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, Typed> entry : sorted.entrySet()) {
            this.saveProperty(root, entry.getValue());
        }
    }

    protected void saveProperty(XmlElement root, Typed typed) {
        Object value = typed.getValue();
        if (value == null) {
            return;
        }
        String className = typed.getValue().getClass().getName();
        SaverLoader handler = this.handlerStore.get(className);
        if (handler == null) {
            Log.warning("Trying to save an unknown property type: " + className);
        } else {
            root.addChild(handler.toXml0(this, typed));
        }
    }

    public Object getProperty(String propertyName) {
        return this.store.getValue(propertyName);
    }

    public Typed get(String propertyName) {
        return this.store.get(propertyName);
    }

    public boolean getBooleanProperty(String id, boolean defaultValue) {
        return this.store.getBooleanValue(id, defaultValue);
    }

    public double getDoubleProperty(String id, double defaultValue) {
        return this.store.getDoubleValue(id, defaultValue);
    }

    public float getFloatProperty(String id, float defaultValue) {
        return this.store.getFloatValue(id, defaultValue);
    }

    public int getIntProperty(String id, int defaultValue) {
        return this.store.getIntValue(id, defaultValue);
    }

    public long getLongProperty(String id, long defaultValue) {
        return this.store.getLongValue(id, defaultValue);
    }

    public String getStringProperty(String id, String defaultValue) {
        return this.store.getStringValue(id, defaultValue);
    }

    public Set<Map.Entry<String, Typed>> getEntrySet() {
        return this.store.getEntrySet();
    }

    protected String shortName(String longName) {
        for (Tuple2<String, String> t : this.classNameMapping) {
            if (!longName.equals(t.x)) continue;
            return (String)t.y;
        }
        return longName;
    }

    protected String longName(String shortName) {
        for (Tuple2<String, String> t : this.classNameMapping) {
            if (!shortName.equals(t.y)) continue;
            return (String)t.x;
        }
        return shortName;
    }

    public void setProperty(Typed t) {
        Typed oldval = this.get(t.getId());
        if (!(t == oldval || t != null && t.equals(oldval))) {
            this.store.put(t);
            this.firePropertyChanged(t.getId(), oldval, t);
        }
    }

    public void setPropertyValue(String id, Object value) {
        Object oldval = this.store.getValue(id);
        if (!(oldval == value || value != null && value.equals(oldval))) {
            this.store.setValue(id, value);
            this.firePropertyChanged(id, oldval, value);
        }
    }

    public static abstract class SaverLoader {
        public final XmlElement toXml0(PreferenceStore ps, Typed value) {
            Class<?> bc = value.getBaseClass();
            Class<?> c = value.getValue() != null ? value.getValue().getClass() : null;
            XmlElement e = new XmlElement("property");
            e.addAttribute("name", value.getId());
            e.addAttribute("baseClass", ps.shortName(bc.getName()));
            if (c != null && !c.equals(bc)) {
                e.addAttribute("class", ps.shortName(c.getName()));
            }
            this.toXml(e, value);
            return e;
        }

        protected void toXml(XmlElement e, Typed value) {
            if (value.getValue() != null) {
                e.addChild(new XmlTextNode(String.valueOf(value.getValue())));
            }
        }

        public abstract Object fromXml(XmlElement var1);
    }
}

