/*
 * Decompiled with CFR 0.152.
 */
package timon.common;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class OtherUtil {
    public static double round(double d, int digits) {
        double a = Math.pow(10.0, digits);
        long l = Math.round(d * a);
        return (double)l / a;
    }

    public static String generateHash(String string) throws NoSuchAlgorithmException, IOException {
        return OtherUtil.hashToString(OtherUtil.generateHash(string.getBytes("UTF-8")));
    }

    public static byte[] generateHash(File file) throws IOException, NoSuchAlgorithmException {
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
        byte[] hash = null;
        try {
            hash = OtherUtil.generateHash(in);
        }
        finally {
            ((InputStream)in).close();
        }
        return hash;
    }

    public static byte[] generateHash(InputStream in) throws IOException, NoSuchAlgorithmException {
        int read;
        MessageDigest md = MessageDigest.getInstance("MD5");
        byte[] buffer = new byte[16384];
        int offset = 0;
        while ((read = in.read(buffer, 0, buffer.length)) != -1) {
            md.update(buffer, 0, read);
            offset += read;
        }
        return md.digest();
    }

    public static byte[] generateHash(byte[] data) throws NoSuchAlgorithmException {
        return OtherUtil.generateHash(data, 0, data.length);
    }

    public static byte[] generateHash(byte[] data, int offset, int length) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance("MD5");
        md.update(data, offset, length);
        return md.digest();
    }

    public static String hashToString(byte[] hash) {
        StringBuilder sb = new StringBuilder();
        byte[] byArray = hash;
        int n = hash.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            int nibble1 = (b & 0xF0) >> 4;
            int nibble2 = b & 0xF;
            sb.append(Integer.toHexString(nibble1));
            sb.append(Integer.toHexString(nibble2));
            ++n2;
        }
        return sb.toString();
    }

    public static URL urlFromString(String urlString) throws IOException {
        if (urlString.contains("http:")) {
            return new URL(urlString);
        }
        return new File(urlString).toURI().toURL();
    }

    public static InputStream openURL(String urlString) throws IOException {
        return OtherUtil.urlFromString(urlString).openStream();
    }
}

