/*
 * Decompiled with CFR 0.152.
 */
package timon.common;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageOutputStream;

public class GraphicsUtil {
    public static BufferedImage getImage(String filename) {
        return GraphicsUtil.getImage(filename, 3);
    }

    public static BufferedImage getImage(String filename, int transparencyModel) {
        BufferedImage sourceImage;
        block3: {
            try {
                sourceImage = ImageIO.read(new File(filename));
                if (sourceImage != null) break block3;
                return null;
            }
            catch (IOException ioe) {
                return null;
            }
        }
        return GraphicsUtil.toBufferedImage(sourceImage, transparencyModel);
    }

    public static BufferedImage getImage(InputStream in) {
        return GraphicsUtil.getImage(in, -1);
    }

    public static BufferedImage getImage(InputStream in, int transparencyModel) {
        BufferedImage sourceImage;
        block4: {
            try {
                sourceImage = ImageIO.read(in);
                if (sourceImage != null) break block4;
                return null;
            }
            catch (IOException ioe) {
                return null;
            }
        }
        if (transparencyModel == -1) {
            transparencyModel = sourceImage.getTransparency();
        }
        return GraphicsUtil.toBufferedImage(sourceImage, transparencyModel);
    }

    public static BufferedImage createBufferedImage(int width, int height, int transparencyModel) {
        GraphicsConfiguration gc = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        return gc.createCompatibleImage(width, height, transparencyModel);
    }

    public static BufferedImage toBufferedImage(Image sourceImage, int transparencyModel) {
        BufferedImage buffer = GraphicsUtil.createBufferedImage(sourceImage.getWidth(null), sourceImage.getHeight(null), transparencyModel);
        buffer.getGraphics().drawImage(sourceImage, 0, 0, null);
        return buffer;
    }

    public static BufferedImage getScaledImageProp(Image i, int width, int height, int transparency) {
        return GraphicsUtil.getScaledImageProp(i, width, height, transparency, 4);
    }

    public static BufferedImage getScaledImageProp(Image i, int width, int height, int transparency, int method) {
        Dimension d = GraphicsUtil.getProportionalScale(i.getWidth(null), i.getHeight(null), width, height);
        return GraphicsUtil.getScaledImage(i, d.width, d.height, transparency, method);
    }

    public static BufferedImage getScaledImage(Image i, int width, int height, int transparency) {
        return GraphicsUtil.getScaledImage(i, width, height, transparency, 4);
    }

    public static BufferedImage getScaledImage(Image i, int width, int height, int transparency, int method) {
        width = Math.max(1, width);
        height = Math.max(1, height);
        BufferedImage result = GraphicsUtil.createBufferedImage(width, height, transparency);
        Graphics2D g = (Graphics2D)result.getGraphics();
        if (method == 4) {
            g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        }
        g.drawImage(i, 0, 0, width, height, null);
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        return result;
    }

    public static Dimension getProportionalScale(int iw, int ih, int w, int h) {
        float wProp = iw;
        wProp /= (float)w;
        float hProp = ih;
        hProp /= (float)h;
        Dimension d = new Dimension(w, h);
        if (wProp >= hProp) {
            d.height = Math.min(d.height, (int)((float)ih / wProp));
        } else {
            d.width = Math.min(d.width, (int)((float)iw / hProp));
        }
        return d;
    }

    public static BufferedImage canvasSize(Image i, int width, int height, int transparency, Color c) {
        int iw = 0;
        int ih = 0;
        if (i != null) {
            iw = i.getWidth(null);
            ih = i.getHeight(null);
        }
        GraphicsConfiguration gc = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        BufferedImage image = gc.createCompatibleImage(width, height, transparency);
        Graphics g = image.getGraphics();
        g.setColor(c);
        g.fillRect(0, 0, width, height);
        if (iw > 0 && ih > 0) {
            g.drawImage(i, (width - iw) / 2, (height - ih) / 2, null);
        }
        return image;
    }

    public static BufferedImage doGrayScale(BufferedImage in, BufferedImage out) {
        ColorConvertOp cco = new ColorConvertOp(ColorSpace.getInstance(1000), ColorSpace.getInstance(1003), null);
        return cco.filter(in, out);
    }

    public static BufferedImage flattenAlpha(BufferedImage image) {
        return GraphicsUtil.flattenAlpha(image, 150);
    }

    public static BufferedImage flattenAlpha(BufferedImage image, int threshold) {
        int w = image.getWidth();
        int h = image.getHeight();
        int[] rgb = image.getRGB(0, 0, w, h, null, 0, w);
        int n = 0;
        while (n < rgb.length) {
            if ((rgb[n] >> 24 & 0xFF) < threshold) {
                rgb[n] = rgb[n] & 0xFFFFFF;
            }
            ++n;
        }
        image = GraphicsUtil.createBufferedImage(w, h, 2);
        image.setRGB(0, 0, w, h, rgb, 0, w);
        return image;
    }

    public static Color setAlpha(Color c, int alpha) {
        return new Color(c.getRGB() & 0xFFFFFF | alpha << 24, true);
    }

    public static void writeImageSequence(BufferedImage[] images, String format, File file) throws IOException {
        file.delete();
        ImageWriter writer = null;
        Iterator<ImageWriter> writers = ImageIO.getImageWritersBySuffix(format);
        if (!writers.hasNext()) {
            throw new IOException("No valid ImageWriter for " + format);
        }
        writer = writers.next();
        ImageOutputStream out = ImageIO.createImageOutputStream(file);
        writer.setOutput(out);
        ImageWriteParam param = writer.getDefaultWriteParam();
        writer.prepareWriteSequence(null);
        int i = 0;
        while (i < images.length) {
            System.out.println(i);
            IIOMetadata meta = writer.getDefaultStreamMetadata(param);
            writer.writeToSequence(new IIOImage(images[i], null, meta), param);
            ++i;
        }
        writer.endWriteSequence();
        out.flush();
        writer.dispose();
        out.close();
    }
}

