/*
 * Decompiled with CFR 0.152.
 */
package timon.common;

import java.util.Arrays;

public class Benchmark {
    private static Benchmark instance;
    private long[] stack = new long[8];
    private int stackL;

    protected Benchmark() {
    }

    public static Benchmark getInstance() {
        if (instance == null) {
            instance = new Benchmark();
        }
        return instance;
    }

    public static void tick() {
        Benchmark b = Benchmark.getInstance();
        if (b.stackL >= b.stack.length) {
            b.stack = Arrays.copyOf(b.stack, b.stack.length << 1);
        }
        b.stack[b.stackL] = System.nanoTime();
        ++b.stackL;
    }

    public static float tock() {
        Benchmark b = Benchmark.getInstance();
        if (b.stackL == 0) {
            return 0.0f;
        }
        --b.stackL;
        long t0 = b.stack[b.stackL];
        long t1 = System.nanoTime();
        float time = (float)((double)(t1 - t0) / 1000000.0);
        System.out.printf("%.2fms\n", Float.valueOf(time));
        return time;
    }
}

