/*
 * Decompiled with CFR 0.152.
 */
package nl.weeaboo.thds.repo;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import nl.weeaboo.thds.repo.CreateRepo;
import timon.common.Log;
import timon.common.components.FileBrowseField;
import timon.common.components.GuiUtil;
import timon.common.components.Sash;
import timon.common.components.Skin;

public class CreateRepoGUI
extends JFrame {
    private CreateRepo creator = new CreateRepo();
    private JTextField authorField;
    private FileBrowseField browseField;
    private JButton processButton;

    public CreateRepoGUI() {
        this.setTitle("TouhouDS Repo Tool v1.0");
        this.setDefaultCloseOperation(2);
        this.setLayout(new BorderLayout(5, 5));
        this.add((Component)this.createMainPanel(), "Center");
        this.setMinimumSize(new Dimension(300, 100));
        this.pack();
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    public static void main(String[] stringArray) {
        try {
            GuiUtil.setSkin((Skin)Skin.NATIVE);
        }
        catch (Exception exception) {
            Log.warning((Exception)exception);
        }
        if (stringArray.length > 0) {
            CreateRepo.main(stringArray);
        } else {
            CreateRepoGUI createRepoGUI = new CreateRepoGUI();
            createRepoGUI.setDefaultCloseOperation(3);
        }
    }

    private JPanel createMainPanel() {
        JLabel jLabel = new JLabel("Author");
        this.authorField = new JTextField("Anonymous");
        JPanel jPanel = new JPanel(new GridLayout(-1, 2, 15, 5));
        jPanel.add(jLabel);
        jPanel.add(this.authorField);
        this.browseField = new FileBrowseField("Folder", "");
        this.browseField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                File file = new File(CreateRepoGUI.this.browseField.getSelectedPath());
                CreateRepoGUI.this.processButton.setEnabled(file.exists() || file.isDirectory());
            }
        });
        this.processButton = new JButton("Process");
        this.processButton.setEnabled(false);
        this.processButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CreateRepoGUI.this.process(new File(CreateRepoGUI.this.browseField.getSelectedPath()));
            }
        });
        JPanel jPanel2 = new JPanel(new BorderLayout(10, 10));
        jPanel2.add((Component)new Sash(0), "North");
        jPanel2.add((Component)this.browseField, "Center");
        jPanel2.add((Component)this.processButton, "East");
        JPanel jPanel3 = new JPanel(new BorderLayout(0, 10));
        jPanel3.setBorder(new EmptyBorder(10, 10, 10, 10));
        jPanel3.add((Component)jPanel, "North");
        jPanel3.add((Component)jPanel2, "South");
        new DropTarget(jPanel3, new DropTargetListener(){

            @Override
            public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
            }

            @Override
            public void dragExit(DropTargetEvent dropTargetEvent) {
            }

            @Override
            public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
                for (DataFlavor dataFlavor : dropTargetDragEvent.getCurrentDataFlavorsAsList()) {
                    if (!dataFlavor.isFlavorJavaFileListType()) continue;
                    dropTargetDragEvent.acceptDrag(3);
                    break;
                }
            }

            @Override
            public void drop(DropTargetDropEvent dropTargetDropEvent) {
                dropTargetDropEvent.acceptDrop(3);
                Transferable transferable = dropTargetDropEvent.getTransferable();
                for (DataFlavor dataFlavor : transferable.getTransferDataFlavors()) {
                    if (!dataFlavor.isFlavorJavaFileListType()) continue;
                    try {
                        List list = (List)transferable.getTransferData(dataFlavor);
                        if (list.size() <= 0) continue;
                        CreateRepoGUI.this.process((File)list.get(0));
                    }
                    catch (UnsupportedFlavorException unsupportedFlavorException) {
                        Log.warning((Exception)unsupportedFlavorException);
                    }
                    catch (IOException iOException) {
                        Log.warning((Exception)iOException);
                    }
                }
            }

            @Override
            public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
            }
        });
        return jPanel3;
    }

    protected void process(File file) {
        if (!file.exists() || !file.isDirectory()) {
            Log.showError((String)"Invalid file, must be a folder.");
            return;
        }
        try {
            File file2 = this.creator.process(this.authorField.getText(), file);
            JOptionPane.showMessageDialog(this, String.format("Repo created in: %s", file2.getAbsolutePath()), "Finished", -1);
        }
        catch (IOException iOException) {
            Log.showError((Exception)iOException);
        }
    }
}

