/*
 * Decompiled with CFR 0.152.
 */
package nl.weeaboo.thds.repo;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import timon.common.Log;
import timon.common.io.FileUtil;

public class CreateRepo {
    private static final String version = "1.1.0";
    private String authorId = "anonymous";

    protected static void printUsage() {
        System.err.println("Usage: java -jar CreateRepo.jar <authorId> <folder>");
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 1) {
            CreateRepo.printUsage();
            return;
        }
        String string = stringArray[0];
        File file = new File(stringArray[1]);
        CreateRepo createRepo = new CreateRepo();
        try {
            createRepo.process(string, file);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public File process(String string, File file) throws IOException {
        this.authorId = string;
        if (!file.exists() || !file.isDirectory()) {
            throw new FileNotFoundException("File is not a valid folder.");
        }
        String string2 = file.getParent() + File.separator + "thds-repo";
        File file2 = new File(string2);
        int n = 1;
        while (file2.exists()) {
            file2 = new File(string2 + ++n);
        }
        if (n > 1) {
            string2 = string2 + n;
        }
        File file3 = new File(string2 + "/repo-" + version);
        file3.mkdirs();
        String string3 = file.getAbsolutePath();
        String string4 = "\ngames=games.txt";
        String string5 = "\nchara=chara.txt";
        if (file.getName().equals("TouhouDS") || new File(string3 + "/games").exists() && new File(string3 + "/chara").exists()) {
            this.processChara(new File(string3 + "/chara"), file3);
            this.processGames(new File(string3 + "/games"), file3);
        } else if (file.getName().equals("games")) {
            this.processGames(file, file3);
            string5 = "";
        } else if (file.getName().equals("chara")) {
            this.processChara(file, file3);
            string4 = "";
        } else {
            throw new IOException("Folder doesn't appear to be a valid TouhouDS install.");
        }
        FileUtil.write((File)new File(file3.getAbsolutePath() + "/repo.ini"), (String)String.format("version=%s%s%s", version, string4, string5));
        return file2;
    }

    protected static List<File> collectIniFiles(File file) {
        if (!file.exists() || !file.isDirectory()) {
            return Collections.emptyList();
        }
        File[] fileArray = file.listFiles();
        if (fileArray == null || fileArray.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<File> arrayList = new ArrayList<File>();
        for (File file2 : fileArray) {
            if (!FileUtil.getExtension((String)file2.getName()).toLowerCase().endsWith("ini")) continue;
            arrayList.add(file2);
        }
        return arrayList;
    }

    protected static Map<String, String> parseIniFile(File file) throws IOException {
        String[] stringArray = FileUtil.read((File)file).split("\\\n");
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String string : stringArray) {
            int n = string.indexOf(61);
            if (n <= 0) continue;
            String string2 = string.substring(0, n).trim();
            String string3 = string.substring(n + 1).trim();
            hashMap.put(string2, string3);
        }
        return hashMap;
    }

    protected void processChara(File file, File file2) throws IOException {
        File file3 = new File(file2 + "/chara");
        file3.mkdirs();
        StringBuilder stringBuilder = new StringBuilder();
        long l = System.currentTimeMillis();
        for (File file4 : CreateRepo.collectIniFiles(file)) {
            String string = FileUtil.stripExtension((String)file4.getName());
            try {
                String string2;
                String string3;
                Map<String, String> map = CreateRepo.parseIniFile(file4);
                String string4 = map.get("name");
                if (string4 == null) {
                    string4 = "";
                }
                if ((string3 = map.get("version")) == null) {
                    string3 = "";
                }
                if ((string2 = map.get("desc")) == null) {
                    string2 = "";
                }
                HashMap<String, File> hashMap = new HashMap<String, File>();
                FileUtil.collectFiles(hashMap, (File)new File(FileUtil.stripExtension((String)file4.getAbsolutePath())), (boolean)true, (boolean)true);
                hashMap.put(file4.getName(), file4);
                FileUtil.zip(hashMap, (File)new File(file3.getAbsolutePath() + "/" + string + ".zip"), null);
                stringBuilder.append(String.format("%s;%s;%s;%d;%s;chara/%s.zip;%s\n", string, string4, string3, l, this.authorId, string, string2));
            }
            catch (IOException iOException) {
                Log.warning((Exception)iOException);
            }
        }
        FileUtil.write((String)(file2.getAbsolutePath() + "/chara.txt"), (String)stringBuilder.toString());
    }

    protected void processGames(File file, File file2) throws IOException {
        File file3 = new File(file2 + "/games");
        file3.mkdirs();
        StringBuilder stringBuilder = new StringBuilder();
        long l = System.currentTimeMillis();
        for (File file4 : CreateRepo.collectIniFiles(file)) {
            String string = FileUtil.stripExtension((String)file4.getName());
            try {
                String string2;
                String string3;
                Map<String, String> map = CreateRepo.parseIniFile(file4);
                String string4 = map.get("name");
                if (string4 == null) {
                    string4 = "";
                }
                if ((string3 = map.get("version")) == null) {
                    string3 = "";
                }
                if ((string2 = map.get("desc")) == null) {
                    string2 = "";
                }
                HashMap<String, File> hashMap = new HashMap<String, File>();
                FileUtil.collectFiles(hashMap, (File)new File(FileUtil.stripExtension((String)file4.getAbsolutePath())), (boolean)true, (boolean)true);
                hashMap.put(file4.getName(), file4);
                FileUtil.zip(hashMap, (File)new File(file3.getAbsolutePath() + "/" + string + ".zip"), null);
                stringBuilder.append(String.format("%s;%s;%s;%d;%s;games/%s.zip;%s\n", string, string4, string3, l, this.authorId, string, string2));
            }
            catch (IOException iOException) {
                Log.warning((Exception)iOException);
            }
        }
        FileUtil.write((String)(file2.getAbsolutePath() + "/games.txt"), (String)stringBuilder.toString());
    }
}

