-- Variables de type FONCTION --
function ActiveEnnemi(nombre)
   if nombre == 1 then
      ennemi1.OK = true
      ennemi1.y = ennemi1.y + ennemi1.vitesse
      if ennemi1.y >= 192 then ReinitialiseEnnemi(1) end
      elseif nombre == 2 then
         ennemi2.OK = true
         ennemi2.x = ennemi2.x + ennemi2.vitesse
         if ennemi2.x >= 256 then ReinitialiseEnnemi(2) end
      elseif nombre == 3 then
         ennemi3.OK = true
         ennemi3.x = ennemi3.x - ennemi3.vitesse
         if ennemi3.x + ennemi3.longueur <= 0 then ReinitialiseEnnemi(3) end
      elseif nombre == 4 then
         ennemi4.OK = true
         ennemi4.y = ennemi4.y - ennemi4.vitesse
         if ennemi4.y + ennemi4.largeur <= 0 then ReinitialiseEnnemi(4) end
   end
end

function ReinitialiseEnnemi(nombre)
   if nombre == 1 then
      ennemi1.x = math.random(0,256 - ennemi1.longueur)
      ennemi1.y = 0
      ennemi1.vitesse = math.random(ia.vitesseMax)
      elseif nombre == 2 then
         ennemi2.x = 0
         ennemi2.y = math.random(0,192 - ennemi2.largeur)
         ennemi2.vitesse = math.random(ia.vitesseMax)
      elseif nombre == 3 then
         ennemi3.x = 256
         ennemi3.y = math.random(0,192 - ennemi3.largeur)
         ennemi3.vitesse = math.random(ia.vitesseMax)
      elseif nombre == 4 then
         ennemi4.x = math.random(0,256 - ennemi4.longueur)
         ennemi4.y = 192
         ennemi4.vitesse = math.random(ia.vitesseMax)
   end
end

function ReinitialiseGame()
   tmr:reset()
   tmr:start()
   perdu = false
   victoire = false
   car.x = (256/2) - (car.longueur/2)
   car.y = 192 - car.largeur
   ennemi1.OK = false      -- On "efface'
   ennemi2.OK = false      -- les ennemis
   ennemi3.OK = false
   ennemi4.OK = false
   ennemi1.vitesse = 1
   ennemi2.vitesse = 1
   ennemi3.vitesse = 1
   ennemi4.vitesse = 1
   ordreApparition = math.random(24)
   son.Bim = true
   son.Victoire = true
end

-- VARIABLES --
car = {}
   car.image = Image.load("images/voiture.png",VRAM)
   car.longueur = Image.width(car.image)
   car.largeur = Image.height(car.image)
   car.x = (256/2) - (car.longueur/2)
   car.y = 192 - car.largeur
   car.vitesse = 4

ennemi1 = {}
   ennemi1.image = Image.load("images/ennemi1.png",VRAM)
   ennemi1.longueur = Image.width(ennemi1.image)
   ennemi1.largeur = Image.height(ennemi1.image)
   ennemi1.x = math.random(0,256 - ennemi1.longueur)
   ennemi1.y = 0
   ennemi1.vitesse = 1
   ennemi1.OK = false

ennemi2 = {}
   ennemi2.image = Image.load("images/ennemi2.png",VRAM)
   ennemi2.longueur = Image.width(ennemi2.image)
   ennemi2.largeur = Image.height(ennemi2.image)
   ennemi2.vitesse = 1
   ennemi2.x = 0
   ennemi2.y = math.random(0,192 - ennemi2.largeur)
   ennemi2.OK = false

ennemi3 = {}
   ennemi3.image = Image.load("images/ennemi3.png",VRAM)
   ennemi3.longueur = Image.width(ennemi3.image)
   ennemi3.largeur = Image.height(ennemi3.image)
   ennemi3.x = 256
   ennemi3.y = math.random(0,192 - ennemi3.largeur)
   ennemi3.vitesse = 1
   ennemi3.OK = false

ennemi4 = {}
   ennemi4.image = Image.load("images/ennemi4.png",VRAM)
   ennemi4.longueur = Image.width(ennemi3.image)
   ennemi4.largeur = Image.height(ennemi4.image)
   ennemi4.x = math.random(0,256 - ennemi4.longueur)
   ennemi4.y = 192
   ennemi4.vitesse = 1
   ennemi4.OK = false
   
ia = {}
   ia.vitesseMax = 6
   ia.time = 10000      -- temps d'appartition des ennemis

boucle = {}
   boucle.principale = true
   boucle.parametrage = true
   boucle.jeu = true
   
ordreApparition = math.random(24)

score = 0
perdu = false
perduImage = Image.load("images/perdu.png",VRAM)
victoire = false
victoireImage = Image.load("images/victoire.png",VRAM)

tmr = Timer.new()

son = {}
   son.Bim = true
   son.Victoire = true
   
Sound.loadBank("sons/soundbank.bin")
Sound.loadSFX(0)
Sound.loadSFX(1)
Sound.loadMod(0)

-- BOUCLE PRINCIPALE --
while not Keys.held.Select do
   
   ----- PARAMETRAGE -----
   while boucle.parametrage do 
     Controls.read()
     if Keys.newPress.Up then 
        ia.vitesseMax = ia.vitesseMax + 1
        elseif Keys.newPress.Down then
           ia.vitesseMax = ia.vitesseMax - 1
 
        if ia.vitesseMax > 10 then vitesseMax = 10
           elseif ia.vitesseMax < 2 then ia.vitesseMax = 2
        end
     end
     
     if Keys.newPress.Left then
        ia.time = ia.time - 1000
        elseif Keys.newPress.Right then
           ia.time = ia.time + 1000
     
        if ia.time < 4000 then ia.time = 4000
           elseif ia.time > 16000 then ia.time = 16000
        end
     end
     
     if Keys.held.Start then boucle.parametrage = false   -- Pour quitter ou confirmer
        elseif Keys.held.Select then           
           boucle.parametrage, boucle.principale = false, false
     end
     
     -- AFFICHAGE --
     screen.print(SCREEN_UP,0,80,"Vitesse maximale des ennemis = "..ia.vitesseMax)
     screen.print(SCREEN_DOWN,0,50,"Haut/Bas pour modifier vitesse max")
     screen.print(SCREEN_UP,0,30,"Temps d'apparition des ennemis ="..ia.time/1000)
     screen.print(SCREEN_DOWN,0,80,"Gauche/Droite pour modifier temps")
     screen.print(SCREEN_DOWN,0,150,"Start pour confirmer")
     screen.print(SCREEN_DOWN,0,0,"Select pour quitter",Color.new(31,0,0))
     render()
   end
   
   ----- JEU -----
   Sound.startMod(0,PLAY_LOOP)
   Sound.setModVolume(200)
   tmr:start()   
   while boucle.jeu do      
      Controls.read()
      
      --1. On dplace le perso du joueur
      if Keys.held.Left then            --sur les cts
         car.x = car.x - car.vitesse
         if car.x < 0 then car.x = 0 end
         elseif Keys.held.Right then
            car.x = car.x + car.vitesse
            if car.x + car.longueur > 256 then car.x = 256 - car.longueur end
      end

      if Keys.held.Up then             --en haut et en bas
         car.y = car.y - car.vitesse
         if car.y < 0 then car.y = 0 end
         elseif Keys.held.Down then
            car.y = car.y + car.vitesse
         if car.y + car.largeur > 192 then car.y = 192 - car.largeur end
      end

      --2. On augmente/diminue la vitesse de dplacement du joueur
      if Keys.held.A then car.vitesse = car.vitesse + 0.1
         elseif Keys.held.B then car.vitesse = car.vitesse - 0.1
      end

      if car.vitesse < 1 then car.vitesse = 1
         elseif car.vitesse > 10 then car.vitesse = 10
      end

      --3. Gestion des ennemis
      if ordreAppartition == 1 then
         ActiveEnnemi(1)                                            -- 1er ennemi
         if tmr:time() >= ia.time then ActiveEnnemi(2) end            -- 2e ennemi
         if tmr:time() >= ia.time * 2 then ActiveEnnemi(3) end            -- 3e ennemi
         if tmr:time() >= ia.time * 3 then ActiveEnnemi(4) end            -- 4e ennemi
         elseif ordreApparition == 2 then
            ActiveEnnemi(1)                                         -- 1er ennemi
            if tmr:time() >= ia.time  then ActiveEnnemi(2) end         -- 2e ennemi
            if tmr:time() >= ia.time * 2 then ActiveEnnemi(4) end         -- 3e ennemi
            if tmr:time() >= ia.time * 3 then ActiveEnnemi(3) end         -- 4e ennemi
         elseif ordreApparition == 3 then
            ActiveEnnemi(1)                                         -- 1er ennemi
            if tmr:time() >= ia.time then ActiveEnnemi(3) end         -- 2e ennemi
            if tmr:time() >= ia.time * 2 then ActiveEnnemi(2) end         -- 3e ennemi
            if tmr:time() >= ia.time then ActiveEnnemi(4) end         -- 4e ennemi
         elseif ordreApparition == 4 then
            ActiveEnnemi(1)                                         -- 1er ennemi
            if tmr:time() >= ia.time then ActiveEnnemi(3) end         -- 2e ennemi
            if tmr:time() >= ia.time * 2 then ActiveEnnemi(4) end         -- 3e ennemi
            if tmr:time() >= ia.time * 3 then ActiveEnnemi(2) end         -- 4e ennemi
         elseif ordreApparition == 5 then
            ActiveEnnemi(1)                                      
            if tmr:time() >= ia.time then ActiveEnnemi(4) end        
            if tmr:time() >= ia.time * 2 then ActiveEnnemi(3) end    
            if tmr:time() >= ia.time * 3 then ActiveEnnemi(2) end      
         elseif ordreApparition == 6 then
            ActiveEnnemi(1)                                         
            if tmr:time() >= ia.time then ActiveEnnemi(4) end       
            if tmr:time() >= ia.time * 2 then ActiveEnnemi(2) end       
            if tmr:time() >= ia.time * 3 then ActiveEnnemi(3) end     

         elseif ordreApparition == 7 then
            ActiveEnnemi(2)
            if tmr:time() >= ia.time then ActiveEnnemi(1) end
            if tmr:time() >= ia.time * 2 then ActiveEnnemi(3) end
            if tmr:time() >= ia.time * 3 then ActiveEnnemi(4) end
         elseif ordreApparition == 8 then
            ActiveEnnemi(2)
            if tmr:time() >= ia.time then ActiveEnnemi(1) end
            if tmr:time() >= ia.time * 2 then ActiveEnnemi(4) end
            if tmr:time() >= ia.time * 3 then ActiveEnnemi(3) end
         elseif ordreApparition == 9 then
            ActiveEnnemi(2)
            if tmr:time() >= ia.time then ActiveEnnemi(3) end
            if tmr:time() >= ia.time * 2 then ActiveEnnemi(1) end
            if tmr:time() >= ia.time * 3 then ActiveEnnemi(4) end
         elseif ordreApparition == 10 then
            ActiveEnnemi(2)
            if tmr:time() >= ia.time then ActiveEnnemi(3) end
            if tmr:time() >= ia.time * 2 then ActiveEnnemi(4) end
            if tmr:time() >= ia.time * 3 then ActiveEnnemi(1) end
         elseif ordreApparition == 11 then
            ActiveEnnemi(2)
            if tmr:time() >= ia.time then ActiveEnnemi(4) end
            if tmr:time() >= ia.time * 2 then ActiveEnnemi(1) end
            if tmr:time() >= ia.time * 3 then ActiveEnnemi(3) end
         elseif ordreApparition == 12 then
            ActiveEnnemi(2)
            if tmr:time() >= ia.time then ActiveEnnemi(4) end
            if tmr:time() >= ia.time * 2 then ActiveEnnemi(3) end
            if tmr:time() >= ia.time * 3 then ActiveEnnemi(1) end

         elseif ordreApparition == 13 then
            ActiveEnnemi(3)
            if tmr:time() >= ia.time then ActiveEnnemi(1) end     
            if tmr:time() >= ia.time * 2 then ActiveEnnemi(2) end      
            if tmr:time() >= ia.time * 3 then ActiveEnnemi(4) end       
         elseif ordreApparition == 14 then
            ActiveEnnemi(3)
            if tmr:time() >= ia.time then ActiveEnnemi(1) end      
            if tmr:time() >= ia.time * 2 then ActiveEnnemi(4) end     
            if tmr:time() >= ia.time * 3 then ActiveEnnemi(2) end         
         elseif ordreApparition == 15 then
            ActiveEnnemi(3)
            if tmr:time() >= ia.time then ActiveEnnemi(2) end         
            if tmr:time() >= ia.time * 2 then ActiveEnnemi(1) end    
            if tmr:time() >= ia.time * 3 then ActiveEnnemi(4) end      
         elseif ordreApparition == 16 then
            ActiveEnnemi(3)
            if tmr:time() >= ia.time then ActiveEnnemi(2) end      
            if tmr:time() >= ia.time * 2 then ActiveEnnemi(4) end      
            if tmr:time() >= ia.time * 3 then ActiveEnnemi(1) end        
         elseif ordreApparition == 17 then
            ActiveEnnemi(3)
            if tmr:time() >= ia.time then ActiveEnnemi(4) end     
            if tmr:time() >= ia.time * 2 then ActiveEnnemi(1) end      
            if tmr:time() >= ia.time * 3 then ActiveEnnemi(2) end        
         elseif ordreApparition == 18 then
            ActiveEnnemi(3)
            if tmr:time() >= ia.time then ActiveEnnemi(4) end      
            if tmr:time() >= ia.time * 2 then ActiveEnnemi(2) end    
            if tmr:time() >= ia.time * 3 then ActiveEnnemi(1) end     

         elseif ordreApparition == 19 then
            ActiveEnnemi(4)
            if tmr:time() >= ia.time then ActiveEnnemi(1) end        
            if tmr:time() >= ia.time * 2 then ActiveEnnemi(2) end         
            if tmr:time() >= ia.time * 3 then ActiveEnnemi(3) end         
         elseif ordreApparition == 20 then
            ActiveEnnemi(4)
            if tmr:time() >= ia.time then ActiveEnnemi(1) end       
            if tmr:time() >= ia.time * 2 then ActiveEnnemi(3) end       
            if tmr:time() >= ia.time * 3 then ActiveEnnemi(2) end         
         elseif ordreApparition == 21 then
            ActiveEnnemi(4)
            if tmr:time() >= ia.time then ActiveEnnemi(2) end       
            if tmr:time() >= ia.time * 2 then ActiveEnnemi(1) end      
            if tmr:time() >= ia.time * 3 then ActiveEnnemi(3) end       
         elseif ordreApparition == 22 then
            ActiveEnnemi(4)
            if tmr:time() >= ia.time then ActiveEnnemi(2) end         
            if tmr:time() >= ia.time * 2 then ActiveEnnemi(3) end        
            if tmr:time() >= ia.time * 3 then ActiveEnnemi(1) end       
         elseif ordreApparition == 23 then
            ActiveEnnemi(4)
            if tmr:time() >= ia.time then ActiveEnnemi(3) end        
            if tmr:time() >= ia.time * 2 then ActiveEnnemi(1) end      
            if tmr:time() >= ia.time * 3 then ActiveEnnemi(2) end        
         elseif ordreApparition == 24 then
            ActiveEnnemi(4)
            if tmr:time() >= ia.time then ActiveEnnemi(3) end       
            if tmr:time() >= ia.time * 2 then ActiveEnnemi(2) end        
            if tmr:time() >= ia.time * 3 then ActiveEnnemi(1) end         
      end

      --4. Collisions entre joueur et enemis
      if ennemi1.OK then         --ennemi 1
         if ennemi1.y + ennemi1.largeur >= car.y + 5 and ennemi1.y <= car.y + car.largeur - 5 and ennemi1.x + ennemi1.longueur >= car.x + 5 and ennemi1.x <= car.x + car.longueur - 5 then     -- ennemi 1
            perdu = true
         end
      end

      if ennemi2.OK then          -- ennemi 2
         if ennemi2.y + ennemi2.largeur >= car.y + 5 and ennemi2.y <= car.y + car.largeur - 5 and ennemi2.x + ennemi2.longueur >= car.x + 5 and ennemi2.x <= car.x + car.longueur - 5 then
            perdu = true
         end
      end

      if ennemi3.OK then           -- ennemi 3
         if ennemi3.y + ennemi3.largeur >= car.y + 5 and ennemi3.y <= car.y + car.largeur - 5 and ennemi3.x + ennemi3.longueur >= car.x + 5 and ennemi3.x <= car.x + car.longueur - 5 then
            perdu = true
         end
      end

      if ennemi4.OK then           -- ennemi 4
         if ennemi4.y + ennemi4.largeur >= car.y + 5 and ennemi4.y <= car.y + car.largeur - 5 and ennemi4.x + ennemi4.longueur >= car.x + 5 and ennemi4.x <= car.x + car.longueur - 5 then
            perdu = true
         end
      end
            
      --5. Si on gagne :
      if tmr:time() > ia.time * 3.5 then
         tmr:stop()
         if son.Victoire then
            Sound.startSFX(1)   -- BRAVO !!!
            son.Victoire = false
         end
         victoire = true
         son.Bim = false
      end

      --6. Si on perd :
      if perdu then
         tmr:stop()  
         if son.Bim then   
            Sound.startSFX(0)    -- BIM !   
            son.Bim = false
         end
      end

      --7. Pour rejouer aprs une victoire ou une dfaite :
      if victoire or perdu then
         if Keys.held.Start then     
            ReinitialiseEnnemi(1)
            ReinitialiseEnnemi(2)
            ReinitialiseEnnemi(3)
            ReinitialiseEnnemi(4)
            ReinitialiseGame()
         end
      end
      
      --8. Pour quitter
      if Keys.held.Select then 
         boucle.jeu = false
         boucle.principale = false
      end

      ----- AFFICHAGE -----
      screen.print(SCREEN_DOWN,0,0,"Select pour quitter",Color.new(31,0,0))
      screen.print(SCREEN_DOWN,30,96,"Vitesse du joueur : "..car.vitesse)
      screen.print(SCREEN_DOWN,40,152,"Temps coul : "..tmr:time()/1000)

      screen.drawGradientRect(SCREEN_UP,0,0,256,192,Color.new(31,20,19),Color.new(12,25,30),Color.new(24,13,25),Color.new(26,31,17))

      screen.blit(SCREEN_UP,car.x,car.y,car.image)

      if ennemi1.OK then screen.blit(SCREEN_UP,ennemi1.x,ennemi1.y,ennemi1.image) end
      if ennemi2.OK then screen.blit(SCREEN_UP,ennemi2.x,ennemi2.y,ennemi2.image) end
      if ennemi3.OK then screen.blit(SCREEN_UP,ennemi3.x,ennemi3.y,ennemi3.image) end
      if ennemi4.OK then screen.blit(SCREEN_UP,ennemi4.x,ennemi4.y,ennemi4.image) end

      if perdu then screen.blit(SCREEN_UP,0,0,perduImage) end
      if victoire then screen.blit(SCREEN_UP,0,0,victoireImage) end

      render()
   end
end
Sound.stop()

-- Vidage de la mmoire --
Image.destroy(car.image)
Image.destroy(ennemi1.image)
Image.destroy(ennemi2.image)
Image.destroy(ennemi3.image)
Image.destroy(ennemi4.image)
Image.destroy(perduImage)
Image.destroy(victoireImage)

Sound.unloadSFX(0)
Sound.unloadSFX(1)
Sound.unloadMod(0)
Sound.unloadBank()

car = nil
ennemi, ennemi2, ennemi3, ennemi4 = nil, nil, nil, nil
score, perduImage, victoireImage, tmr = nil, nil, nil, nil
victoire, perdu, ordreApparition = nil, nil, nil
son, ia, boucle = nil, nil, nil
nombre = nil


