#ifdef _NES_MAPPER_CPP_

//defined in nes_mapper.cpp
//static uint8 irq_enabled NESTER_DTCM;
//static uint8 irq_counter NESTER_DTCM;
//static uint8 irq_latch NESTER_DTCM;

/////////////////////////////////////////////////////////////////////
// Mapper 24
void NES_mapper24_Reset()
{
  // set CPU bank pointers
  NES_mapper_set_CPU_banks(0,1,num_8k_ROM_banks-2,num_8k_ROM_banks-1);

  // set PPU bank pointers
  if(num_1k_VROM_banks)
  {
    NES_mapper_set_PPU_banks(0,1,2,3,4,5,6,7);
  }

  irq_enabled = 0;
  irq_counter = 0;
  irq_latch = 0;

  // add the external sound hardware
  //apu_arm7
  //parent_NES->apu->hasExt_VRC6();
#ifndef _WIN32
  g_sharedPData->setSoundExt = SETSOUNDEXT_VRC6;
#endif
}

void DS_APUWrite(uint32 address, uint8 data);
void NES_mapper24_MemoryWrite(uint32 addr, uint8 data)
{
  switch(addr & 0xF003)
  {
    case 0x8000:
      {
        NES_mapper_set_CPU_bank4(data*2+0);
        NES_mapper_set_CPU_bank5(data*2+1);
      }
      break;

    //DCR
    case 0x9000:
    case 0x9001:
    case 0x9002:
    case 0xA000:
    case 0xA001:
    case 0xA002:
    case 0xB000:
    case 0xB001:
    case 0xB002:
      //parent_NES->apu->Write(addr, data);
		//apu_arm7
		DS_APUWrite(addr, data);
      break;

    case 0xB003:
      {
        data = data & 0x0C;
        if(data == 0x00)
        {
          NES_mapper_set_mirroringB(MIRROR_VERT);
        }
        else if(data == 0x04)
        {
          NES_mapper_set_mirroringB(MIRROR_HORIZ);
        }
        else if(data == 0x08)
        {
          NES_mapper_set_mirroring(0,0,0,0);
        }
        else if(data == 0x0C)
        {
          NES_mapper_set_mirroring(1,1,1,1);
        }
      }
      break;

    case 0xC000:
      {
        NES_mapper_set_CPU_bank6(data);
      }
      break;

    case 0xD000:
      {
        NES_mapper_set_PPU_bank0(data);
      }
      break;

    case 0xD001:
      {
        NES_mapper_set_PPU_bank1(data);
      }
      break;

    case 0xD002:
      {
        NES_mapper_set_PPU_bank2(data);
      }
      break;

    case 0xD003:
      {
        NES_mapper_set_PPU_bank3(data);
      }
      break;

    case 0xE000:
      {
        NES_mapper_set_PPU_bank4(data);
      }
      break;

    case 0xE001:
      {
        NES_mapper_set_PPU_bank5(data);
      }
      break;

    case 0xE002:
      {
        NES_mapper_set_PPU_bank6(data);
      }
      break;

    case 0xE003:
      {
        NES_mapper_set_PPU_bank7(data);
      }
      break;

    case 0xF000:
      {
        irq_latch = data;
      }
      break;

    case 0xF001:
      {
        irq_enabled = data & 0x03;
        if(irq_enabled & 0x02)
        {
          irq_counter = irq_latch;
        }
      }
      break;

    case 0xF002:
      {
        if(irq_enabled & 0x01)
        {
          irq_enabled |= 0x02;
        }
        else
        {
          irq_enabled &= 0x01;
        }
      }
      break;
  }
}

void NES_mapper24_HSync(uint32 scanline)
{
  if(irq_enabled & 0x02)
  {
    if(irq_counter == 0xFF)
    {
      CPUINT_DoIRQ();
      irq_counter = irq_latch;
    }
    else
    {
      irq_counter++;
    }
  }
}
/////////////////////////////////////////////////////////////////////

#endif
