#include "print.h"
#include "calc.h"


void sprintint(char**, int);
void sprinthex(char**, unsigned int);
void sprintstring(char**, char*);
void sprintoffset(char**, int);
void sprintaddress(char**, int);

void mysprintf(Z80_info_t* zinf, char *s, const char *fmt, ...) {
    char *p;
    va_list argp;
    char fmtbuf[256];
    
    // Initialize arguments
    va_start(argp, fmt);
    for(p = (char*)fmt; *p; p++) {
        if(*p != '%') {
            *s++ = *p;
        } else {
            switch(*++p) {
                case 'c':
                    *s++ = va_arg(argp, int);
                    break;
                case 'h':
					sprintoffset(&s, va_arg(argp, int));
					break;
                case 'd':
                    sprintint(&s, va_arg(argp, int));
                    break;
                case 's':
                    sprintstring(&s, va_arg(argp, char *));
                	break;
				case 'a':
                    sprintaddress(&s, va_arg(argp, int));
                	break;
                case 'r':
				{
					unsigned short addr = zinf->addr + 2;
					addr += ((char) va_arg(argp, int));
					sprintaddress(&s, addr);
					break;
				}
				case 'x':				
                    sprinthex(&s, va_arg(argp, int));
                	break;
                default:
                    *s++ = *p;
            }
        }
    }
    *s = '\0';
    // gcc doesn't require this macro
    //va_end(argp);
}

void sprintaddress(char **s, int val) {
	char addr_buf[9] = "00000000 ";
	char *p = addr_buf + 4;
		*(*s)++ = '$';
		sprinthex(&p, val);
		*p = '\0';
		p = (addr_buf + 4) - ((addr_buf + 8) - p);
		return sprintstring(s, p);
}

void sprintoffset(char **s, int val) {
	if (val >= 0) *(*s)++ = '+';
	return sprintint(s, val);
}


// Prints given signed integer.  Integer size doesn't matter
void sprintint(char **s, int val) {
    int i;
    // buffer size 10 is the maximum possible with 32 bit ints
    char buffer[10], ci = 0;
    if (!val) {
        *(*s)++ = '0';
        return;
    }
    if (val < 0) {
        *(*s)++ = '-';
        val = -val;
    }
    for (; val; val = (unsigned int)val/10) buffer[ci++] = '0' + (unsigned int)val % 10;
    //print the string in reverse
    while (ci) *(*s)++ = buffer[--ci];
}

// Prints given unsigned integer as hex.  Integer size doesn't matter
void sprinthex(char **s, unsigned int val) {
    // 8 is the biggest it can go with 32 bit ints
    char buffer[8],temp;
    char ci = 0,i;
    
    if (!val) {
        *(*s)++ = '0';
        return;
    }
    for (; val || ((ci%2)!=0); val>>=4) {
        i = val & 0xF;
        temp = (i > 9) ? 'A'-10 : '0';
        buffer[ci++] = temp + i;
    }
    //print the string in reverse
    while (ci) *(*s)++ = buffer[--ci];
	
}

// Prints 0 terminated unformated string
void sprintstring(char **s, char *ptr) {
    for (; *ptr; ptr++, (*s)++) *(*s) = *ptr;
}
