#include<nds.h>
#include<string.h>
//#include<stdbool.h>
#include "calc.h"

extern CALC_T calc;
extern LCD_t *lcd;
u16 *lcd_screen = (u16*)BG_BMP_RAM_SUB(2);

void LCD_init() {
	int i;
	lcd->active		= false;
	lcd->dummy		= false;
	lcd->word_len	= 8;
	lcd->x			= 0;
	lcd->y			= 0;
	lcd->z			= 0;
	lcd->mode		= 5;
	lcd->contrast	= 32;
	lcd->push		= 0;
	lcd->sp			= 0;
	memset(lcd->display, 0x00,DISPLAY_SIZE);
	for(i=0;i<LCD_STACK_SIZE;i++) {
		memset(lcd->stack[i], 0x00,DISPLAY_SIZE);
	}
}

void Push_LCD() {
	memcpy(lcd->stack[lcd->sp],lcd->display,DISPLAY_SIZE);
	lcd->sp = (lcd->sp+1)%LCD_STACK_SIZE;
	lcd->push = 0;
}

unsigned char *BWLCD() {
	int x,y,i;
	for(y=0;y<DISPLAY_SIZE;y+=LCD_MEM_WIDTH) {
		for(x=0;x<12;x++) {
			i = (y*4)+(x*4);
			#define muxbw(byte,bit) \
				((252*((lcd->display[(byte)]>>(bit))&0x01))+1)
			lcd_screen[i++] = muxbw(y+x,7) | (muxbw(y+x,6)<<8);
			lcd_screen[i++] = muxbw(y+x,5) | (muxbw(y+x,4)<<8);
			lcd_screen[i++] = muxbw(y+x,3) | (muxbw(y+x,2)<<8);
			lcd_screen[i]   = muxbw(y+x,1) | (muxbw(y+x,0)<<8);
		}
	}
	return NULL;
}


unsigned char *GREYLCD() {
	int x,y,i;
	if (lcd->active) {
		for(y=0;y<DISPLAY_SIZE;y+=LCD_MEM_WIDTH) {
			for(x=0;x<12;x++) {
				i = (y*4)+(x*4);
				#define muxlayers(byte,bit) \
					(((252*(((lcd->stack[0][(byte)]>>(bit))&1)+((lcd->stack[1][(byte)]>>(bit))&1)+((lcd->stack[2][(byte)]>>(bit))&1)))/3)+1)
				lcd_screen[i++] = muxlayers(y+x,7) | (muxlayers(y+x,6)<<8);
				lcd_screen[i++] = muxlayers(y+x,5) | (muxlayers(y+x,4)<<8);
				lcd_screen[i++] = muxlayers(y+x,3) | (muxlayers(y+x,2)<<8);
				lcd_screen[i]   = muxlayers(y+x,1) | (muxlayers(y+x,0)<<8);
			}
		}
	} else {
		for(y=0;y<64;y++) {
			for(x=0;x<96/2;x++) {
				lcd_screen[(y*64)+x] = 0x2C2C;
			}
		}
	}
	return NULL;
}

// Returns the increment direction, Word size,
// and whether the screen is on or not
unsigned char LCD_Command_in() {
	return ( (lcd->mode&0x03)+((lcd->active)?0x20:0x00)+((lcd->word_len==8)?0x40:0x00) );
}


//Good old out ($10),a
void LCD_Command_out(unsigned char d) {
	switch (d) {
		case 0:
			lcd->word_len = 6;
			break;
		case 1:
			lcd->word_len = 8;
			break;
		case 2:
			lcd->active = FALSE;
			break;
		case 3:
			lcd->active = TRUE;
			break;
		default: {
			if (d < 0x08) {
				lcd->mode = d;
			} else
			if (d< 0x18) {
				// Op amp
			} else
			if (d< 0x20) {
				// Test mode
			} else
			if (d < 0x34) {
				lcd->dummy = TRUE;
				if (lcd->word_len == 8) {
					if (d < 0x2F) lcd->y = (d - 0x20)%32;
				} else {
					lcd->y = (d - 0x20)%32;
				}
			} else
			if (d < 0x40) {
				// Out of Bounds Y
			} else
			if (d < 0x80) {
				lcd->z = d - 0x40;
			} else
			if (d< 0xC0) {
				lcd->dummy = TRUE;
				lcd->x = d - 0x80;
			} else {
				lcd->contrast = d - 0xC0;
			}
			break;
		}
	}
}


//Returns a read from the lcd screen
unsigned char LCD_Data_in() {
// Technically the dummy read is incorrect.
// it should return the value from the last address
// It shouldn't matter though
	unsigned char a=0x00;

	if (!lcd->dummy) {	
		if (lcd->word_len == 8) {
			 if ((lcd->x<LCD_HEIGHT) && (lcd->y<LCD_MEM_WIDTH))  a = lcd->display[LcdOffSet(lcd->y,lcd->x,lcd->z)];
		} else if (lcd->word_len == 6) {
			int new_y = (lcd->y*6);
			int shift = new_y%8;
			unsigned short data = 0;
			new_y/=8;
			data = lcd->display[LcdOffSet(new_y,lcd->x,lcd->z)]<<8;
			data |= lcd->display[LcdOffSet(new_y+1,lcd->x,lcd->z)] & 0xFF;
			data >>= (10-shift);
			data &= 0x3F;
			a=data;
		}
		switch (lcd->mode) {
			case X_INC:
				lcd->x = (lcd->x+1)%LCD_HEIGHT;
				break;
			case X_DEC:
				lcd->x = (lcd->x-1)%LCD_HEIGHT;
				break;
			case Y_INC:
				lcd->y = (lcd->y+1)%32;		//not sure what this should be
				break;
			case Y_DEC:
				lcd->y = (lcd->y-1)%32;
				break;
		}
	}
	lcd->dummy = FALSE;
	return a;
}


//Writes to the lcd. AKA out ($11),a
void LCD_Data_out(unsigned char d) {
	//This here is the trick for flawless grey.
	// It checks if the top left cornner is about to be written
	// if so, it pushes the current lcd on the stack
	if (lcd->x==0 && lcd->y==0 && lcd->push>=MIN_PUSH) {
		Push_LCD();
	}
	if (lcd->word_len == 8) {
		if ((lcd->x<LCD_HEIGHT) && (lcd->y<LCD_MEM_WIDTH)) lcd->display[LcdOffSet(lcd->y,lcd->x,lcd->z)] = d;
	} else if (lcd->word_len == 6) {
		int new_y = (lcd->y*6);
		int shift = new_y%8;
		unsigned short 	data = d,
						mask = 0x003F;
		new_y/=8;
		data <<= 10 - shift;
		mask <<= 10 - shift;
		mask = ~mask;
		lcd->display[LcdOffSet(new_y,lcd->x,lcd->z)] &= mask >> 8;
		lcd->display[LcdOffSet(new_y,lcd->x,lcd->z)] |= data >> 8;
		lcd->display[LcdOffSet(new_y+1,lcd->x,lcd->z)] &= mask & 0xFF;
		lcd->display[LcdOffSet(new_y+1,lcd->x,lcd->z)] |= data & 0xFF;			
	}

	switch (lcd->mode) {
		case X_INC:
			lcd->x = (lcd->x+1)%LCD_HEIGHT;
			break;
		case X_DEC:
			lcd->x = (lcd->x-1)%LCD_HEIGHT;
			break;
		case Y_INC:
			lcd->y = (lcd->y+1)%32;		//not sure what this should be
			break;
		case Y_DEC:
			lcd->y = (lcd->y-1)%32;
			break;
	}
}


