#include <nds.h>
#include <stdio.h>
#include<string.h>
#include "calc.h"
#include "hw_83p.h"
#include "disasm.h"
#include "display.h"
#include "link.h"
#include "bf83pbe_bin.h"
//for rom


//For quicker reference and less typing.
extern CALC_T calc;
extern CONFIG_T cfg;
extern REWIND_t rewindti;
extern struct DrZ80 *cpu;
extern memc *mem;
extern STDINT_t *stdint;
extern KEY_t *keys;
extern LCD_t *lcd;
extern link_t *link;

//These divisors are used to set the interrupt frequency.
//The slice size is required to create these
// It's ROUGHLY equal to the ti83+ interrupt frequency
// speed  |  timer1  |  timer2
//   0    |   512    |   1024
//   1    |   256    |    512
//   2    |   170    |    240
//   3    |   102    |    204
unsigned char divs[4] = { 1 , 2 , 3, 5 };



void calc_erase_certificate() {
	int size = (512*1024);
	memset(mem->flash + size - 32768, 0xFF, 16384);
	mem->flash[(size-32768)]		= 0x00;
	mem->flash[(size-32768)+0x1FE0]	= 0x00;
	mem->flash[(size-32768)+0x1FE1]	= 0x00;
	return;
}

void STDINT_init_83p() {
	// see "ti_stdint.h" for notes on this.
	stdint->intactive	= 0x00;
	stdint->ack			= 0x00;
	stdint->divisor		= 0x01;
	stdint->count		= 0x00;
	stdint->timer		= 0x00;
}

void MEM_init_83p() {
	memset(mem, 0, sizeof(memc));
	/* Set Number of Pages here */
	mem->flash_pages	= 32;
	mem->ram_pages		= 2;
	mem->flash_size		= mem->flash_pages * PAGE_SIZE;
	mem->flash			= calc.rom;
	mem->ram_size		= mem->ram_pages * PAGE_SIZE;
	mem->ram			= calc.ram;
	mem->boot_mapped	= FALSE;
	mem->unlocked		= FALSE;
	mem->step			= 0;
	mem->cmd			= 0;
	mem->ver			= 1;
	/* Organize bank states here */
	/*	Address							page	ram?	*/
	bank_state_t banks[5] = {
		{mem->flash+0x00*PAGE_SIZE, 	0x00,	FALSE},
		{mem->flash+0x1F*PAGE_SIZE,		0x1F, 	FALSE},
		{mem->ram+0x00*PAGE_SIZE,		0x01, 	TRUE}, //<-- note the offset and page 
		{mem->ram+0x01*PAGE_SIZE,		0x00,	TRUE}, //    differences
		{NULL,							0x00,	FALSE}
	};
	memcpy(mem->banks, banks, sizeof(banks));
	memset(calc.rom,0xFF,(0x4000*0x1F));
	memcpy(calc.rom+(0x4000*0x1F),bf83pbe_bin,0x4000);
}


//-------------------------------------
// INterrupt 83p

void interrupt_83p() {
	stdint->count = (stdint->count+1)%stdint->divisor;
	if (!stdint->count) {
		stdint->timer = (stdint->timer+1)%3;
		if (!stdint->timer) {
			stdint->ack |= (stdint->intactive&0x02);
		} else {
			stdint->ack |= (stdint->intactive&0x04);
		}
	}
	//(keysHeld()&KEY_R) || 
	if (touchKey(5,0) || calc.fakeon){
		stdint->ack |= (stdint->intactive&0x01);//ON!!!
	}
	if (cpu->Z80IF&(1<<1)) {
		if (stdint->ack) {
			cpu->z80irqvector = 0xFF;
			cpu->Z80_IRQ = 1;
		}
	}
}


//--------------------------------------
// In port
// callback for drz80
unsigned char in_83p(unsigned short p) {
	unsigned char a = 0xFF;
	
	switch (p&0xFF) {
		case 0x00: {
			a = vlink;
			break;
		}
		case 0x01: {
			// scankeys() is not performed
			// It's assummed that is done in the main loop
			unsigned long key = keysHeld()&(~KEY_SELECT)&(~KEY_L)&(~KEY_R);
			short i;
			for(i=0;i<12;i++) {
				if (BIT(i)&key) {
					if (keys->key_group&(1<<cfg.keys[i][0])) {
						if (cfg.keys[i][1]<8) {
							a &= (~(1<<cfg.keys[i][1]));
						}
					}
				}
			}
			if (keys->touch_button) { // handle touch screen
				if (keys->key_group&(1<<keys->touch_group)) {
					a &= (~(1<<keys->touch_bit));
				}
			}
			break;
		}
		case 0x02: {
			// Status port, tells model and several other details
			// of non importance
			a = 0x3B | ((mem->unlocked)?4:0);
			break;
		}
		case 0x03: {
			//Interrupt mask
			// ON, Timer1 and Timer 2 can fire interrupts
			a = stdint->intactive;
			break;
		}
		case 0x04: {
			// Bits of "ack" are set when hardware generates an interrupt.
			// It is not reset untill a write to port 3.
			// it generates interrupts, and says what generated them.
			// Consider back porting to wabbitemu
			a = stdint->ack;
			if (!(touchKey(5,0)||calc.fakeon) ) a |= 0x08;	//ON!!!
			break;
		}	
		case 0x06: {
			// Bank struct now only contains *addr, page, and ram
			// so memmove is not as expensive.
			// It only occurs when boot mapped, which is rare.
			if ( mem->boot_mapped ) {
				memmove(&mem->banks[1],&mem->banks[2],sizeof(bank_state_t)*3);
			}
			a = ((mem->banks[1].ram)?0x40:0x00)+(mem->banks[1].page&0x1f);
			if (mem->boot_mapped) {
				memmove(&mem->banks[2],&mem->banks[1],sizeof(bank_state_t)*3);
				memcpy(&mem->banks[1],&mem->banks[4],sizeof(bank_state_t)*1);
			}
			break;
		}
		case 0x07: {
			// same notes as port 6.
			if ( mem->boot_mapped ) {
				memmove(&mem->banks[1],&mem->banks[2],sizeof(bank_state_t)*3);
			}
			a = ((mem->banks[2].ram)?0x40:0x00)+(mem->banks[2].page&0x1f);
			if (mem->boot_mapped) {
				memmove(&mem->banks[2],&mem->banks[1],sizeof(bank_state_t)*3);
				memcpy(&mem->banks[1],&mem->banks[4],sizeof(bank_state_t)*1);
			}
			break;
		}
		case 0x10: {
			a = LCD_Command_in();
			break;
		}
		case 0x11: {
			a = LCD_Data_in();
			break;
		}
		case 0x14: {
			a = mem->unlocked;
			break;
		}
	}
	return a;
}

void out_83p(unsigned short p,unsigned char d){
	switch (p&0xFF) {
		case 0x00: {
			link->calc = d&0x03;
			break;
		}
		case 0x01: {
			keys->key_group = (d^0xFF);
			break;
		}
		case 0x02: {
			//Force special interrupt?
			break;
		}
		case 0x03: {
			if ((!(stdint->intactive & 0x08))&&(d&0x08)) {
				lcd->active = TRUE;		//I'm worried about this
			}
			stdint->intactive = d;
			stdint->ack &= d;
			break;
		}
		case 0x04: {
			stdint->divisor = divs[((d&0x06)>>1)];
			if (d&0x01) {
				if ( !mem->boot_mapped ) {
					memmove(&mem->banks[2],&mem->banks[1],sizeof(bank_state_t)*3);
					memcpy(&mem->banks[1],&mem->banks[4],sizeof(bank_state_t)*1);
				}
				mem->boot_mapped = TRUE;
			}else {
				if (mem->boot_mapped ) {
					memmove(&mem->banks[1],&mem->banks[2],sizeof(bank_state_t)*3);
				}
				mem->boot_mapped = FALSE;
			}
			break;
		}
		case 0x06: {
			Bank_switch_83p(d,1);
			break;
		}
		case 0x07: {
			Bank_switch_83p(d,2);
			break;
		}
		case 0x10: {
			LCD_Command_out(d);
			break;
		}
		case 0x11: {
			LCD_Data_out(d);
			break;
		}
		case 0x14: {
			// Theres currently no flash protection.
			mem->unlocked = (d&0x01);
			break;
		}
	}
}


void Bank_switch_83p(unsigned char d, unsigned short bank) {
	// Bank struct now only contains *addr, page, and ram
	// so memmove is not as expensive.
	// It only occurs when boot mapped, which is rare.
	if ( mem->boot_mapped ) {
		memmove(&mem->banks[1],&mem->banks[2],sizeof(bank_state_t)*3);
	}
	mem->banks[bank].ram = (d>>6)&0x01;
	if (mem->banks[bank].ram) {
		mem->banks[bank].page	= ((d&0x01));
		mem->banks[bank].addr	= mem->ram+((mem->banks[bank].page^0x01)<<14);
		//   Xor 1 for ram page address fixes a poetential drz80 bug
		// Tios keeps ram page 1 at bank2 and ram page 0 at bank3
		// Meaning the base of the ram chip is below the second half
		// of the ram chip in the z80 addressable memmory.
		// drz80 seems to assume executing code remains in 1 bank
		// at any given time. If code crosses a bank boundries
		// drz80 may not read from the appropriate bank.
		//   To solve this I rearrange the order the pages are stored.
		// Page 1 is stored above page 0.
		//   Normally when the boundry is crossed on calc the 8k limit
		// kicks in and resets everything. I perfer allowing execution,
		// Since I wouldn't have to set anything special to force a reset
		// on boundary crossing and I can poetentially support models that
		// don't have an 8k limit.
	} else {
		mem->banks[bank].page	= ((d&0x1f));
		mem->banks[bank].addr	= mem->flash+(mem->banks[bank].page<<14);
		// Flash pages have no correction, they typically don't
		// execute from one page to another.
	}
	if (mem->boot_mapped) {
		memmove(&mem->banks[2],&mem->banks[1],sizeof(bank_state_t)*3);
		memcpy(&mem->banks[1],&mem->banks[4],sizeof(bank_state_t)*1);
	}
}


void flashwrite83p(unsigned short addr, unsigned char data) {
	int bank = (addr>>14)&0x03;
	invalidateRewind(3);
	switch( mem->step ) {
		case 0:
			if (((addr&0xFFF)==0xAAA)&&(data==0xAA)) {
				mem->step++;
			}
			break;
		case 1:
			if (((addr&0xFFF)==0x555)&&(data==0x55)) {
				mem->step++;
			} else mem->step=0;
			break;
		case 2:
			if ((addr&0xFFF)==0xAAA) {
				if (data==0xA0) { //Program				
					mem->step++;
				} else if (data==0x80) { //Erase
					mem->step++;
				} else mem->step=0;
			} else mem->step=0;
			break;
		case 3:
			if (mem->cmd==0xA0) {//Write data
				mem->banks[bank].addr[addr&0x3fff]&=data;//AND logic
				mem->step=0;
			} else if (((addr&0xFFF)==0xAAA)&&(data==0xAA)) {
				mem->step++;
			} else if (data==0xF0) mem->step=0;
			break;
		case 4:
			if (((addr&0xFFF)==0x555)&&(data==0x55)) {
				mem->step++;
			} else if (data==0xF0) mem->step=0;
			break;
		case 5:
			if (((addr&0xFFF)==0xAAA)&&(data==0x10)) {
				//Erase entire chip, except boot page
				memset(mem->flash,0xFF,(mem->flash_size-0x4000)); 
			} else if (data==0x30) {//Erase certain sectors
				int spage = (mem->banks[bank].page<<1)+((addr>>13)&0x01);
				if (spage<56) {
					memset(mem->flash+((spage&0xF8)<<13),0xFF,0x10000);
				} else if (spage<60) {
					memset(mem->flash+0x70000,0xFF,0x8000);
				} else if (spage<61) {
					memset(mem->flash+0x78000,0xFF,0x2000);
				} else if (spage<62) {
					memset(mem->flash+0x7A000,0xFF,0x2000);
				} else if (spage<64) {
					//Can't erase the boot page.
					//memset(mem->flash+0x7C000,0xFF,0x4000);
				}
			} else if (data==0xF0) mem->step=0;
			break;
		default:
			mem->step=0;
			break;
	}
	mem->cmd=data;
}



	
