#include <nds.h>
#include <stdio.h>
#include <string.h>
#include <stdarg.h>
#include "calc.h"
#include "bitmap.h"

#include "skin1_bmp.h"
#include "skin2_bmp.h"
#include "skin3_bmp.h"
#include "menu_bmp.h"
#include "font8x8_bmp.h"
#include "icons_bmp.h"
#include "sprite_bmp.h"

BITMAP menubmp;
BITMAP skin1;
BITMAP skin2;
BITMAP skin3;
BITMAP font;
BITMAP icons;
BITMAP mselect;

extern CALC_T calc;
extern CONFIG_T cfg;
extern struct DrZ80 *cpu;



static unsigned short imgbuf[192][256];
static int scalemat[4][3][2][2];


SpriteEntry spriteEntry[128];
SpriteRotation *spriteRot = (SpriteRotation *)spriteEntry;


void CalcScaleMat() {
	int a,b,c,d;
	int x,y;
	for(y=0;y<4;y++) {
		for(x=0;x<3;x++) {
			switch(y) {
				case 0:
					a = 12;
					c = 0;
					break;
				case 1:
					a = 4;
					c = 8;
					break;
				case 2:
					a = 8;
					c = 4;
					break;
				case 3:
					a = 12;
					c = 0;
					break;
			}
			switch(x) {
				case 0:
					b = (a*1)/4;
					a = (a*3)/4;
					d = (c*1)/4;
					c = (c*3)/4;
					break;
				case 1:
					b = (a*2)/4;
					a = (a*2)/4;
					d = (c*2)/4;
					c = (c*2)/4;
					break;
				case 2:
					b = (a*3)/4;
					a = (a*1)/4;
					d = (c*3)/4;
					c = (c*1)/4;
					break;
			}
			scalemat[y][x][0][0] = a;
			scalemat[y][x][0][1] = b;
			scalemat[y][x][1][0] = c;
			scalemat[y][x][1][1] = d;
		}
	}
}
unsigned short linebuf[2][256];

void ScaleRot(BITMAP *bm,unsigned short *imgbuf,int rot) {
	int x,y,color,a,b,c,i;
	int rc,gc,bc,fc;
	int rgb[2][2][3];
	GETPIXELFP getpixel = BitmapFastInit(bm);
	
	for(y=0;y<256;y++) {
		for(x=0;x<256;x++) {
			linebuf[0][x]	= getpixel(x,((y*3)/4)+0);
			linebuf[1][x]	= getpixel(x,((y*3)/4)+1);
		}
		for(x=0;x<192;x++) {
			for(a=0;a<2;a++) {
				for(b=0;b<2;b++) {
					color			= linebuf[a][((x*4)/3)+b];
					fc = scalemat[y%4][x%3][a][b];
					rgb[a][b][0]	= (GetRValue15( color )*fc);
					rgb[a][b][1]	= (GetGValue15( color )*fc);
					rgb[a][b][2]	= (GetBValue15( color )*fc);
				}
			}
			rc = rgb[0][0][0] + rgb[0][1][0] + rgb[1][0][0] + rgb[1][1][0];
			gc = rgb[0][0][1] + rgb[0][1][1] + rgb[1][0][1] + rgb[1][1][1];
			bc = rgb[0][0][2] + rgb[0][1][2] + rgb[1][0][2] + rgb[1][1][2];
			rc /= 12;
			gc /= 12;
			bc /= 12;
/*
			if (rc>31) rc = 31;
			if (gc>31) gc = 31;
			if (bc>31) bc = 31;
*/
			if (rot == 0) {
				imgbuf[(x*256)+(255-y)] = RGB15( rc , gc , bc ) | BIT(15);
			} else {
				imgbuf[((191-x)*256)+y] = RGB15( rc , gc , bc ) | BIT(15);
			}
		}
	}
}

void ShiftSkinVblank(int i) {
	if (getIM()==1 && getIY()==0x89F0) {
		u8 flag = calc.ram[0x89F0-0x8000+18];
		if (flag&BIT(3)) {
			if (i==1) swiWaitForVBlank();
		} else if (flag&BIT(4)) {
			if (i==2) swiWaitForVBlank();
		}else if (flag&BIT(5)) {
			if (i==2) swiWaitForVBlank();
		} else if (flag&BIT(6)) {
			if (i==2) swiWaitForVBlank();
		}else {
			if (i==0) swiWaitForVBlank();
		}
	} else {
		if (i==0) swiWaitForVBlank();
	}
}

void SetRotation() {
	int i;
	u16 *bottomvideo;
	u16 *buffer = (u16 *)imgbuf;
	switch (cfg.rotate%3) {
		case 0x01: {
			SUB_BG3_XDX = 0;
			SUB_BG3_XDY = (256*96)/192;
			SUB_BG3_YDX = -64*2;
			SUB_BG3_YDY = 0;
			SUB_BG3_CX  = 0;
			SUB_BG3_CY  = 124*256;
/*
			BG3_XDX = 0;
			BG3_XDY = (256*256)/192;
			BG3_YDX = -192;
			BG3_YDY = 0;
			BG3_CX  = 0;
			BG3_CY  = 192*256;
*/
			BG3_XDX = 1<<8;
			BG3_XDY = 0;
			BG3_YDX = 0;
			BG3_YDY = 1<<8;
			BG3_CX  = 0;
			BG3_CY  = 0;	

			CalcScaleMat();
			
			bottomvideo = (u16*)BG_BMP_RAM(0x0E);
			ScaleRot(&skin1,buffer,0);
			ShiftSkinVblank(0);
			for(i=0;i<192*256;i++) bottomvideo[i] = buffer[i];
			
			bottomvideo = (u16*)BG_BMP_RAM(0x14);
			ScaleRot(&skin2,buffer,0);
			ShiftSkinVblank(1);
			for(i=0;i<192*256;i++) bottomvideo[i] = buffer[i];
			
			bottomvideo = (u16*)BG_BMP_RAM(0x1A);
			ScaleRot(&skin3,buffer,0);
			ShiftSkinVblank(2);
			for(i=0;i<192*256;i++) bottomvideo[i] = buffer[i];
			
			break;
		}
		case 0x02: {
			SUB_BG3_XDX = 0;
			SUB_BG3_XDY = -((256*96)/192);
			SUB_BG3_YDX = 64*2;
			SUB_BG3_YDY = 0;
			SUB_BG3_CX  = 96*256;
			SUB_BG3_CY  = -4*256;
			/*
			BG3_XDX = 0;
			BG3_XDY = -(256*256)/192;
			BG3_YDX = 192;
			BG3_YDY = 0;
			BG3_CX  = 256*256;
			BG3_CY  = 0;
			*/
			BG3_XDX = 1<<8;
			BG3_XDY = 0;
			BG3_YDX = 0;
			BG3_YDY = 1<<8;
			BG3_CX  = 0;
			BG3_CY  = 0;	
			CalcScaleMat();
			ScaleRot(&skin1,buffer,1);
			ShiftSkinVblank(0);
			bottomvideo = (u16*)BG_BMP_RAM(0x0E);
			for(i=0;i<192*256;i++) bottomvideo[i] = buffer[i];
			
			ScaleRot(&skin2,buffer,1);
			ShiftSkinVblank(1);
			bottomvideo = (u16*)BG_BMP_RAM(0x14);
			for(i=0;i<192*256;i++) bottomvideo[i] = buffer[i];
			
			ScaleRot(&skin3,buffer,1);
			ShiftSkinVblank(2);
			bottomvideo = (u16*)BG_BMP_RAM(0x1A);
			for(i=0;i<192*256;i++) bottomvideo[i] = buffer[i];
			break;
		}
		default: {
			SUB_BG3_XDX = 96;
			SUB_BG3_XDY = 0;
			SUB_BG3_YDX = 0;
			SUB_BG3_YDY = 96;
			SUB_BG3_CX  = 0;
			SUB_BG3_CY  = -4*256;
		
			BG3_XDX = 1<<8;
			BG3_XDY = 0;
			BG3_YDX = 0;
			BG3_YDY = 1<<8;
			BG3_CX  = 0;
			BG3_CY  = 0;
			ShiftSkinVblank(0);
			bottomvideo = (u16*)BG_BMP_RAM(0x0E);
			BitmapBlit15(&skin1,bottomvideo,0,0,256,192,0,0,256,192);
			ShiftSkinVblank(1);
			bottomvideo = (u16*)BG_BMP_RAM(0x14);
			BitmapBlit15(&skin2,bottomvideo,0,0,256,192,0,0,256,192);
			ShiftSkinVblank(2);
			bottomvideo = (u16*)BG_BMP_RAM(0x1A);
			BitmapBlit15(&skin3,bottomvideo,0,0,256,192,0,0,256,192);
			break;
		}
	}
}

void CleanOAM() {
	int i;
	for(i = 0; i < 128; i++) {
		spriteEntry[i].attribute[0] = ATTR0_DISABLED;
	}
}

void updateOAM() {
	DC_FlushRange(spriteEntry,128*sizeof(SpriteEntry));
	dmaCopy(spriteEntry,OAM, 128*sizeof(SpriteEntry));
}

void sprite(int x, int y, int tile) {
	spriteRot[0].hdx = 128;
	spriteRot[0].hdy = 0;
	spriteRot[0].vdx = 0;
	spriteRot[0].vdy = 128;
	spriteEntry[0].attribute[0] =	ATTR0_COLOR_256 | ATTR0_SQUARE | 
											ATTR0_ROTSCALE_DOUBLE | (y & 0x00FF);
	spriteEntry[0].attribute[1] =	ATTR1_ROTDATA(0) | ATTR1_SIZE_64 | (x & 0x01FF);
	spriteEntry[0].attribute[2] = 	ATTR2_PRIORITY(1) | tile;
}




void printfxy(int x,int y,const char* string, ...) {
	va_list args;
	char temp[12];
	if (x>32) return;
	if (y>24) return;
	if (x<0 && y<0) return;
	
	memset(temp,0,12);
	if (y<0) {
		sprintf(temp,"\x1b[%02dG",x);
	} else {
		sprintf(temp,"\x1b[%02d;%02dH",y,x);
	}
	iprintf(temp);
	va_start(args, string);
	vprintf(string, args);
	va_end(args);
}

void FadeToWhite() {
	int i;
	for(i=0;i<0x1F;i+=4) {
		swiWaitForVBlank();
		BLEND_CR	=	BLEND_FADE_WHITE |
						BLEND_SRC_BG3 |
						BLEND_SRC_BG2 |
						BLEND_SRC_BG1 |
						BLEND_SRC_BG0 |
						BLEND_SRC_SPRITE;
		BLEND_Y		= i;
	}
	swiWaitForVBlank();
	BLEND_Y		= 0x1F;
}
void FadeFromWhite() {
	int i;
	for(i=0x1F;i>=0;i-=4) {
		swiWaitForVBlank();
		BLEND_CR	=	BLEND_FADE_WHITE |
						BLEND_SRC_BG3 |
						BLEND_SRC_BG2 |
						BLEND_SRC_BG1 |
						BLEND_SRC_BG0 |
						BLEND_SRC_SPRITE;
		BLEND_Y		= i;
	}
	swiWaitForVBlank();
	BLEND_CR	= 0;
	BLEND_Y		= 0;
}


void WhiteSkin() {
	BLEND_CR	=	BLEND_FADE_WHITE |
					BLEND_SRC_BG3 |
					BLEND_SRC_BG2 |
					BLEND_SRC_BG1 |
					BLEND_SRC_BG0 |
					BLEND_SRC_SPRITE;
	BLEND_Y		= 0x1F;
}
void NormalSkin() {
	 BLEND_CR	= 0x00;
	 BLEND_Y	= 0x00;
}	

void LoadSkins() {
	int i;
	u16 *bottomvideo;
	u8  *tile_ram;
	//	Tiles  at 0x06004000 = 0x01
	//	menu   at 0x06020000 = 0x08
	//	Skin 1 at 0x06038000 = 0x0E
	//	Skin 2 at 0x06050000 = 0x14
	//	Skin 3 at 0x06068000 = 0x1A
	vramSetBankA(VRAM_A_MAIN_BG_0x06000000);
	vramSetBankB(VRAM_B_MAIN_BG_0x06020000);
	vramSetBankC(VRAM_C_MAIN_BG_0x06040000);
	vramSetBankD(VRAM_D_MAIN_BG_0x06060000);
	vramSetBankE(VRAM_E_MAIN_SPRITE);
	vramSetBankI(VRAM_I_SUB_BG);
	bottomvideo = (u16*)BG_BMP_RAM_SUB(2);
	for(i=0;i<16384/2;i++) bottomvideo[i] = 0;
	BitmapDef(&menubmp,(void*)menu_bmp);
	bottomvideo = (u16*)BG_BMP_RAM(0x08);
	BitmapBlit15(&menubmp,bottomvideo,0,0,256,192,0,0,256,192);
	BitmapDef(&skin1,(void*)skin1_bmp);
//	bottomvideo = (u16*)BG_BMP_RAM(0x0E);
//	BitmapBlit15(&skin1,bottomvideo,0,0,256,192,0,0,256,192);
	BitmapDef(&skin2,(void*)skin2_bmp);
//	bottomvideo = (u16*)BG_BMP_RAM(0x14);
//	BitmapBlit15(&skin2,bottomvideo,0,0,256,192,0,0,256,192);
	BitmapDef(&skin3,(void*)skin3_bmp);
//	bottomvideo = (u16*)BG_BMP_RAM(0x1A);
//	BitmapBlit15(&skin3,bottomvideo,0,0,256,192,0,0,256,192);

	BitmapDef(&font,font8x8_bmp);
	BitmapDef(&icons,icons_bmp);
	tile_ram = (u8*)BG_TILE_RAM(1);
	BitmapTile8(&icons,tile_ram+(64*0),1);
	BitmapTile8(&font,tile_ram+(64*32),1);
	BitmapTile8(&font,tile_ram+(64*160),128);
	
	
	for(i=0;i<icons.Info->biClrUsed;i++) {
		BG_PALETTE[i+1] = BIT(15)|RGBQUADto15(icons.Pal[i]);
	}
	BG_PALETTE[128] = RGB15(49/8,106/8,197/8)|BIT(15);
	BG_PALETTE[129] = RGB15(31,31,31)|BIT(15);
	
	
	BitmapDef(&mselect,sprite_bmp);
	BitmapTile8(&mselect,SPRITE_GFX,0);
	SPRITE_PALETTE[0] = RGB15(31,31,31);
	SPRITE_PALETTE[1] = RGB15(00,00,00)|BIT(15);
	CleanOAM();
	updateOAM();
}

void SetSkin(int i) {
	BG3_CR  = BG_BMP16_256x256  | BG_BMP_BASE((i*6)+0x0E) | BG_PRIORITY(3);
}
void ShiftSkin() {
	if (getIM()==1 && getIY()==0x89F0) {
		u8 flag = calc.ram[0x89F0-0x8000+18];
		if (flag&BIT(3)) SetSkin(1);
		else if (flag&BIT(4)) SetSkin(2);
		else if (flag&BIT(5)) SetSkin(2);
		else if (flag&BIT(6)) SetSkin(2);
		else SetSkin(0);
	} else SetSkin(0);
}




void setupvideo() {
	int i;
	
	lcdMainOnBottom();
	//Top video is extend rotation to stretch lcd
	videoSetModeSub(MODE_5_2D | DISPLAY_BG3_ACTIVE );
	vramSetBankI(VRAM_I_SUB_BG);
	//Since the top video is scaled so much
	// I only need a small 16k buffer
	SUB_BG3_CR  = BG_BMP8_128x128 | BG_BMP_BASE(2);

	BG_PALETTE_SUB[0] = RGB15((41/8),(49/8),(82/8)); //bg color
	for(i=0;i<=254;i++) { //254 is not a mistake.
		int c = (((254-i)*31)/254);
		BG_PALETTE_SUB[i+1] = RGB15(c,c,c);
	}
	
	//Bottom video is SKIN with console overlay
	videoSetMode(	MODE_5_2D |
					DISPLAY_SPR_1D_LAYOUT | 
					DISPLAY_SPR_ACTIVE |
					DISPLAY_BG3_ACTIVE |
					DISPLAY_BG2_ACTIVE |
					DISPLAY_BG0_ACTIVE);
	//vram 512k:
	// 02k	Scroll		0x06000000
	// 02k	Browser		0x06000800
	// 02k	Console		0x06001000
	// 02k	white		0x06001800
	// 02k  blank		0x06002000
	// 06k	Free		0x06002800
	// 16k	Tiles		0x06004000 = 0x01
	// 96k	Free		0x06008000 = 0x02
	// 96k	menu		0x06020000 = 0x08
	// 96k	Skin 1		0x06038000 = 0x0E
	// 96k	Skin 2		0x06050000 = 0x14
	// 96k	Skin 3		0x06068000 = 0x1A
	vramSetBankA(VRAM_A_MAIN_BG_0x06000000);
	vramSetBankB(VRAM_B_MAIN_BG_0x06020000);
	vramSetBankC(VRAM_C_MAIN_BG_0x06040000);
	vramSetBankD(VRAM_D_MAIN_BG_0x06060000);
	vramSetBankE(VRAM_E_MAIN_SPRITE);
	//consoleInitDefault((u16*)BG_MAP_RAM(2), (u16*)BG_TILE_RAM(2), 16);
	consoleInit(NULL,NULL,0,0,(u16*)BG_MAP_RAM(2),0,0);
	BG0_CR = 0;
	BG0_X0 = 0;
	BG0_Y0 = 0;
	//Set up bottom video for skin like a frame buffer
	ShiftSkin();
	SetRotation();
	
	BG2_CR  = 0;
	BG2_XDX = 0;
	BG2_YDY = 0;


	BG_PALETTE[0]	= 0;
	BG_PALETTE[255]	= RGB15(31,31,31)|BIT(15); //white for font	

	u16 *mapptr = (u16*)BG_MAP_RAM(0);
	for(i=0;i<32*32;i++) mapptr[i] = 0;
	consoleClear();
}

