#include <stdio.h>
#include "disassemble.h"
#include "calc.h"
#include "disasm.h"

extern CALC_T calc;
extern struct DrZ80 *cpu;
extern memc *mem;


Z80_com_t da_opcode[256] = {
{" nop"},
{" ex af,af'"},
{" djnz %r"},
{" jr %r"},
{" jr %s,%r"},
{" ld %s,$%x"},
{" add hl,%s"},
{" ld (bc),a"},
{" ld a,(bc)"},
{" ld (de),a"},
{" ld a,(de)"},
{" ld (%a),hl"},
{" ld hl,(%a)"},
{" ld (%a),a"},
{" ld a,(%a)"},
{" inc %s"},
{" dec %s"},
{" inc %s"},
{" dec %s"},
{" ld %s,$%x"},
{" rlca"},
{" rrca"},
{" rla"},
{" rra"},
{" daa"},
{" cpl"},
{" scf"},
{" ccf"},
{" ld %s,%s"},
{" halt"},
{" %s%s"},
{" ret %s"},
{" pop %s"},
{" ret"},
{" exx"},
{" jp (hl)"},
{" ld sp,hl"},
{" jp %s,%a"},
{" jp %a"},
{" out (%x),a"},
{" in a,(%x)"},
{" ex (sp),hl"},
{" ex de,hl"},
{" di"},
{" ei"},
{" call %s,%a"},
{" push %s"},
{" call %a"},
{" %s%d"},
{" rst %xh"},
{" %s %s"},
{" bit %d,%s"},
{" res %d,%s"},
{" set %d,%s"},
{" in %s,(c)"},
{" out (c),%s"},
{" sbc hl,%s"},
{" adc hl,%s"},
{" ld (%a),%s"},
{" ld %s,(%a)"},
{" neg"},
{" retn"},
{" reti"},
{" im %s"},
{" ld i,a"},
{" ld r,a"},
{" ld a,i"},
{" ld a,r"},
{" rrd"},
{" rld"},
{" nop"},
{" %s"},
{" %s (%s%h)->%s"},
{" bit %d,(%s%h)->%s"},
{" res %d,(%s%h)->%s"},
{" set %d,(%s%h)->%s"},
{" %s (%s%h)"},
{" bit %d,(%s%h)"},
{" res %d,(%s%h)"},
{" set %d,(%s%h)"},
{" add %s,%s"},
{" ld %s,(%a)"},
{" ld (%a),%s"},
{" inc (%s%h)"},
{" dec (%s%h)"},
{" ld (%s%h),$%x"},
{" ld (%s%h),%s"},
{" ld %s,(%s%h)"},
{" %s(%s%h)"},
{" jp %s"},
{" ld sp,%s"},
{" ex (sp),%s"},
{"%s:"},
{" bcall(%s)"},
{" bcall(%a)"},
{" bit %s,(iy+%s)->%s"},
{" res %s,(iy+%s)->%s"},
{" set %s,(iy+%s)->%s"},
{" bit %s,(iy+%s)"},
{" res %s,(iy+%s)"},
{" set %s,(iy+%s)"},
{" bjump(%s)"},
{" bjump(%a)"}
};

/* TODO (sputt#1#): Remove references to this */

static char r[9][5]  = 	{"b","c","d","e","h","l","(hl)","a","f"};
static char r8i[2][9][5]  = {
{"b","c","d","e","ixh","ixl","ix","a","f"},
{"b","c","d","e","iyh","iyl","iy","a","f"}};
static char rp[4][4] = 	{"bc","de","hl","sp"};
static char rpi[2][4][4] = {{"bc","de","ix","sp"},{"  bc","de","iy","sp"}};
static char rp2[4][4] = {"bc","de","hl","af"};
static char rp2i[2][4][4] = {{"bc","de","ix","af"},{"  bc","de","iy","af"}};
static char ri[2][4] = 	{"ix","iy"};
static char cc[8][4] = 	{"nz","z","nc","c","po","pe","p","m"};
static char alu[8][8] = {"add a,","adc a,","sub ","sbc a,","and ","xor ","or ","cp "};
static char rot[8][4] = {"rlc","rrc","rl","rr","sla","sra","sll","srl"};
static char im[8][4] = 	{"0","0/1","1","2","0","0/1","1","2"};
static char bli[4][4][8] = {
{"ldi", "cpi", "ini", "outi"},
{"ldd", "cpd", "ind", "outd"},
{"ldir","cpir","inir","otir"},
{"lddr","cpdr","indr","otdr"}};


inline unsigned char mem_read(memc *mem, unsigned short addr) {
	return mem->banks[mc_bank(addr)].addr[mc_base(addr)];
}

/* returns number of bytes read */
int disassemble(unsigned short addr, unsigned long count, Z80_info_t *result) {
	unsigned long i, prefix = 0, pi = 0;
	for (i = 0; i < count; i++, result++, prefix = 0) {
		unsigned short start_addr = result->addr = addr;

		unsigned char data = mem_read(mem, addr++);
		
		if (data == 0xDD || data == 0xFD) {
			prefix = data;
			pi = (prefix >> 5) & 1;
			data = mem_read(mem, addr++);
		}
		if (data == 0xCB) {
			int offset;
			data = mem_read(mem, addr++);
			if (prefix) {
				offset = (char) data;
				data = mem_read(mem, addr++);
			}
			int x = (data & 0xC0) >> 6;
			int y = (data & 0x38) >> 3;
			int z = (data & 0x07);
			result->a1 = y;
			result->a2 = (int) r[z];
			
			switch (x) {
				case 0: /* X = 0 */
					result->index = DA_ROT;
					result->a1 = (int) rot[y];
					break;
				case 1:	result->index = DA_BIT; break; /* X = 1 */
				case 2:	result->index = DA_RES; break; /* X = 2 */
				case 3:	result->index = DA_SET; break; /* X = 3 */
			}
			if (prefix) {
				char *flagname = NULL, *bitname=NULL;

				/* Special IY flags*/
				if ((prefix == 0xFD) &&
					(x!=0) &&
					(getIY() == 0x89F0) &&
					flagname && bitname) {
					if (z == 6) {
						result->index += (DA_BIT_IF - DA_BIT);
						result->a1 = (int) bitname;
						result->a2 = (int) flagname;
					} else {
						result->index += (DA_BIT_RF - DA_BIT);
						result->a3 = result->a2;
						result->a1 = (int) bitname;
						result->a2 = (int) flagname;
					}
				} else {
					if (z == 6) {
						result->index += (DA_ROT_I - DA_ROT);
						result->a2 = (int) ri[pi];
						result->a3 = offset;
					} else {
						result->index += (DA_ROT_R - DA_ROT);
						result->a4 = result->a2;
						result->a3 = offset;
						result->a2 = (int) ri[pi];
					}
				}
			}
		} else if (data == 0xED) {
			data = mem_read(mem, addr++);
			int x = (data & 0xC0) >> 6;
			int y = (data & 0x38) >> 3;
			int z = (data & 0x07);
			int p = (data & 0x30) >> 4;
			int q = y & 1;
			
			if (x == 1) {
			/* FOR X  = 1 */
			if (z == 0) {
				if (y == 6) y = 8;
				result->index = DA_IN_R__C_;
				result->a1 = (int) r[y];
			} else
			if (z == 1) {
				if (y == 6) y = 8;
				result->index = DA_OUT__C__R;
				result->a1 = (int) r[y];
			} else
			if (z == 2) {
				if (q == 0) result->index = DA_SBC_HL_RP;
				else result->index = DA_ADC_HL_RP;
				result->a1 = (int) rp[p];
			} else
			if (z == 3) {
				if (q == 0) {
					result->index = DA_LD__X__RP;
					result->a1 = mem_read16(mem, addr);
					result->a2 = (int) rp[p];
				} else {
					result->index = DA_LD_RP__X_;
					result->a1 = (int) rp[p];
					result->a2 = mem_read16(mem, addr);
				}
			} else
			if (z == 4) {
				result->index = DA_NEG;
			} else
			if (z == 5) {
				if (y == 1) {
					result->index = DA_RETI;
				} else {
					result->index = DA_RETN;
				}
			} else
			if (z == 6) {
				result->index = DA_IM_X;
				result->a1 = (int) im[y];
			} else
			if (z == 7) {
				switch (y) {
					case 0:	result->index = DA_LD_I_A; break;
					case 1: result->index = DA_LD_R_A; break;
					case 2: result->index = DA_LD_A_I; break;
					case 3: result->index = DA_LD_A_R; break;
					case 4: result->index = DA_RRD; break;
					case 5: result->index = DA_RLD; break;
					default:
						result->index = DA_NOP_ED; break;
				}
			}
			} else
			/* FOR X  = 2 */
			if (x == 2) {
				if (y >= 4) {
					result->index = DA_BLI;
					result->a1 = (int) bli[y-4][z];
				} else {}
			} else {}
		} else {
			









			int x = (data & 0xC0) >> 6;
			int y = (data & 0x38) >> 3;
			int z = (data & 0x07);
			int p = (data & 0x30) >> 4;
			int q = y & 1;
			int offset = mem_read(mem, addr);
				
			if (x == 0) {
				
				
			/* FOR X  = 0 */
			if (z == 0) {
				switch (y) {
					case 0: result->index = DA_NOP; break;
					case 1: result->index = DA_EX_AF_AF_; break;
					case 2: 
						result->index = DA_DJNZ_X;
						result->a1 = mem_read(mem, addr++);
						break;
					case 3: 
						result->index = DA_JR_X; 
						result->a1 = mem_read(mem, addr++);
						break;
					default:
						result->index = DA_JR_CC_X;
						result->a1 = (int) cc[y-4];
						result->a2 = mem_read(mem, addr++);
						break;
				}
			} else
			if (z == 1) {	/* ix, iy ready */
				if (q == 0) {
					result->index = DA_LD_RP_X;
					result->a2 = mem_read16(mem, addr);
					if (prefix && p == 2) {
						result->a1 = (int) ri[pi];
					} else {
						result->a1 = (int) rp[p];
					}
				} else {
					if (prefix) {
						result->index = DA_ADD_RI_RP;
						result->a1 = (int) ri[pi];
						result->a2 = (int) rpi[pi][p];
					} else {
						result->index = DA_ADD_HL_RP;
						result->a1 = (int) rp[p];
					}
				}
			} else
			if (z == 2) {	/* ix, iy ready */
				switch (y) {
					case 0: result->index = DA_LD__BC__A; break;
					case 1: result->index = DA_LD_A__BC_; break;
					case 2: result->index = DA_LD__DE__A; break;
					case 3: result->index = DA_LD_A__DE_; break;
					case 4: 
						if (prefix) {
							result->index = DA_LD__X__RI;
							result->a2 = (int) ri[pi];
							result->a1 = mem_read16(mem, addr);
						} else {
							result->index = DA_LD__X__HL;
							result->a1 = mem_read16(mem, addr);
						}
						break;							
					case 5:
						if (prefix) {
							result->index = DA_LD_RI__X_;
							result->a1 = (int) ri[pi];
							result->a2 = mem_read16(mem, addr);
						} else {
							result->index = DA_LD_HL__X_;
							result->a1 = mem_read16(mem, addr);
						}
						break;
					case 6:	result->index = DA_LD__X__A;
							result->a1 = mem_read16(mem, addr);
							break;
					case 7:	result->index = DA_LD_A__X_;
							result->a1 = mem_read16(mem, addr);
							break;	
				}				
			} else
			if (z == 3) {	/* ix, iy ready */
				result->index = (q == 0) ? DA_INC_RP : DA_DEC_RP;
				result->a1 = (int) (prefix ? rpi[pi][p] : rp[p]);
			} else
			if (z < 6) {	/* ix, iy ready */
				result->index = (z == 4) ? DA_INC_R : DA_DEC_R;
				result->a1 = (int) (prefix ? r8i[pi][y] : r[y]);
				if (prefix && y == 6) {
					result->index += (DA_INC_RI - DA_INC_R);
					result->a2 = offset;
					addr++;
				}
					
			} else
			if (z == 6) {	/* ix, iy ready */
				result->index = DA_LD_R_X;
				result->a1 = (int) (prefix ? r8i[pi][y] : r[y]);
				if (prefix && y == 6) {
					result->index = DA_LD_RI_X;
					result->a2 = offset;
					addr++;
					result->a3 = (unsigned char) mem_read(mem, addr++);
				} else {
					result->a2 = (unsigned char) mem_read(mem, addr++);
				}
			} else {	/* ix, iy ready */
				switch (y) {
					case 0:	result->index = DA_RLCA; break;
					case 1: result->index = DA_RRCA; break;
					case 2: result->index = DA_RLA; break;
					case 3: result->index = DA_RRA; break;
					case 4: result->index = DA_DAA; break;
					case 5: result->index = DA_CPL; break;
					case 6: result->index = DA_SCF; break;
					case 7: result->index = DA_CCF; break;
				}
			}
			} else
			
			
			/* FOR X = 1 */
			if (x == 1) {	/* ix, iy ready */
				if (z == 6 && y == 6) {
					result->index = DA_HALT;
				} else {
					result->index = DA_LD_R_R;
					result->a1 = (int) r[y];
					result->a2 = (int) r[z];
					if (prefix) {
						if (y == 6) {
							addr++;
							result->index = DA_LD_RI_R;
							result->a1 = (int) ri[pi];
							result->a3 = result->a2;
							result->a2 = offset;
						} else if (z == 6) {
							addr++;
							result->a2 = (int) ri[pi];
							result->index = DA_LD_R_RI;
							result->a3 = offset;
						}
					}			
				}
			} else
			/* FOR X = 2 */
			if (x == 2) {	/* ix, iy ready */
				result->index = DA_ALU;
				result->a1 = (int) alu[y];
				result->a2 = (int) (prefix ? r8i[pi][z] : r[z]);
				if (prefix && z == 6) {
					result->index = DA_ALU_RI;
					result->a3 = offset;
					addr++;
				}
					
			} else
			if (x == 3) {
			/* FOR X = 3 */
			if (z == 0) {
				result->index = DA_RET_CC;
				result->a1 = (int) cc[y];
			} else
			if (z == 1) {
				if (q == 0) {
					result->index = DA_POP_RP;
					result->a1 = (int) (prefix ? rp2i[pi][p] : rp2[p]);
				} else {
					switch (p) {
						case 0:	result->index = DA_RET; break;
						case 1: result->index = DA_EXX; break;
						case 2:
							result->index = (int) (prefix ? DA_JP_RI : DA_JP_HL);
							result->a1 = (int) ri[pi];
							break;
						case 3: 
							result->index = (int) (prefix ? DA_LD_SP_RI : DA_LD_SP_HL);
							result->a1 = (int) ri[pi];
							break;
					}
				}
			} else
			if (z == 2) {
				result->index = DA_JP_CC_X;
				result->a1 = (int) cc[y];
				result->a2 = mem_read16(mem, addr);
			} else
			if (z == 3) {
				switch (y) {
					case 0:
						result->index = DA_JP_X;
						result->a1 = mem_read16(mem, addr);
						break;
					case 2:
						result->index = DA_OUT__X__A;
						result->a1 = mem_read(mem, addr++);
						break;
					case 3:
						result->index = DA_IN_A__X_;
						result->a1 = mem_read(mem, addr++);
						break;
					case 4:	
						result->index = (int) (prefix ? DA_EX__SP__RI : DA_EX__SP__HL);
						result->a1 = (int) ri[pi];
						break;
					case 5: result->index = DA_EX_DE_HL; break;
					case 6: result->index = DA_DI; break;
					case 7: result->index = DA_EI; break;
				}
			} else
			if (z == 4) {
				result->index = DA_CALL_CC_X;
				result->a1 = (int) cc[y];
				result->a2 = mem_read16(mem, addr);
			} else
			if (z == 5) {
				if (q == 0) {
					result->index = DA_PUSH_RP;
					result->a1 = (int) (prefix ? rp2i[pi][p] : rp2[p]);
				} else {
					if (p == 0) {
						result->index = DA_CALL_X;
						result->a1 = mem_read16(mem, addr);

						if ((result->a1 == 0x0050)) {
							result->a1 = mem_read16(mem, addr);
							result->index = DA_BJUMP_N;
						}

					}
				}					
			} else
			if (z == 6) {
				result->index = DA_ALU_X;
				result->a1 = (int) alu[y];
				result->a2 = (unsigned char) mem_read(mem, addr++);
			} else
			if (z == 7) {
				if ((y == 5) ) {
					int tmp = mem_read16(mem, addr);
					result->index = DA_BCALL_N;
					result->a1 = tmp;
				} else {
					result->index = DA_RST_X;
					result->a1 = y*8;
				}
			}
			}
		}
		result->size = addr - start_addr;
		//printf("%0.4X: ",start_addr); da_display(result); putchar('\n');
	}
	
	return i;
}
