#include <nds.h>
#include <stdio.h>
#include <string.h>
#include <stdarg.h>
#include "calc.h"
#include "display.h"
#include "disassemble.h"
#include "print.h"
#include "disasm.h"


#define REGCOL	24

bool dahigh = false;
extern Z80_com_t da_opcode[256];
Z80_info_t z80[128];

//For quicker reference and less typing.
extern CALC_T calc;
extern struct DrZ80 *cpu;
extern memc *mem;
extern STDINT_t *stdint;
extern KEY_t *keys;
extern LCD_t *lcd;


int da_x = 0;
int da_y = 0;

void dputc(unsigned char c) {
	if (c=='\n') {
		da_x=0;
		da_y+=8;
		return;
	}
	if (da_x>=0 &&
		da_x<256 &&
		da_y>=0 &&
		da_y<192) {
		u16 (*mapptr)[32] = (u16(*)[32])BG_MAP_RAM(2);
		if (c>=32 && c<128) {
			mapptr[da_y/8][da_x/8] = c + (dahigh?128:0);
		} else {
			mapptr[da_y/8][da_x/8] = c;
		}
	}
	da_x+=8;
	if (da_x>=256) {
		da_x=0;
		da_y+=8;
	}
}


void mprintf(const unsigned char * format, ...) {
	int i;
	unsigned char buffer[64];
	va_list args;
	va_start (args, format);
	memset(buffer,0,64);
	vsprintf (buffer,format, args);
	for(i=0;i<63 && buffer[i];i++) {
		if (dahigh && buffer[i]>=32 && buffer[i]<128) {
			dputc(buffer[i]+128);
		} else {
			dputc(buffer[i]);
		}
	}
	va_end (args);
}
void DisplayRegisterPane() {
	unsigned short i=0;
	printfxy(REGCOL,i++,"AF =%0.4X", getAF());
	printfxy(REGCOL,i++,"BC =%0.4X", getBC());
	printfxy(REGCOL,i++,"DE =%0.4X", getDE());
	printfxy(REGCOL,i++,"HL =%0.4X", getHL());
	printfxy(REGCOL,i++,"AF'=%0.4X", getAF2());
	printfxy(REGCOL,i++,"BC'=%0.4X", getBC2());
	printfxy(REGCOL,i++,"DE'=%0.4X", getDE2());
	printfxy(REGCOL,i++,"HL'=%0.4X", getHL2());
	printfxy(REGCOL,i++,"IX =%0.4X", getIX());
	printfxy(REGCOL,i++,"IY =%0.4X", getIY());
	printfxy(REGCOL,i++,"SP =%0.4X", getSP());
	printfxy(REGCOL,i++,"PC =%0.4X", getPC());
	printfxy(REGCOL,i++,"I  =%0.2X", getI());
	printfxy(REGCOL,i++,"R  =%0.2X", getR());
	printfxy(REGCOL,i++,"IM  %d", getIM());
	printfxy(REGCOL,i++,"IFF=%d", getIFF1());
	printfxy(REGCOL,i++,"hlt=%d",getHALT());
	printfxy(REGCOL,i++,"Bank1:%02X",mem->banks[1].page+((mem->banks[1].ram)?0x40:0x00));
	printfxy(REGCOL,i++,"Bank2:%02X",mem->banks[2].page+((mem->banks[2].ram)?0x40:0x00));
}

void DisplayDisasm(unsigned short cursor) {
	Z80_info_t forcePC;
	Z80_info_t forceCursor;
	Z80_info_t *zinf;
	char s[32];
	int i;
	printfxy(0,0,"Start\n");
	disassemble(cursor-48,96,z80);
	disassemble(getPC(),1,&forcePC);
	disassemble(cursor,1,&forceCursor);
	iprintf("Disasm\n");
	i=0;
	if (z80[0].addr>cursor) {
			for(i=0;i<96 && (z80[i].addr>cursor);i++);
	}
	for(;i<96 && (z80[i].addr<cursor);i++);
	iprintf("found\n");
	int start = i-9;
	int line = 0;
	int cursordone = 0;
	int pcdone = 0;
	char c;
	da_x = 0;
	da_y = 0;
	for (i=start;line<19;i++,line++) {
		c=' ';
		zinf = &z80[i];
		if ((!cursordone) && (i>0) && (z80[i-1].addr<cursor) && (z80[i].addr>=cursor)) {
			zinf = &forceCursor;
			cursordone =1;
			if (z80[i].addr!=cursor) i--;
			c='>';
		} else 	if ((!pcdone) && (i>0) && (z80[i-1].addr<getPC()) && (z80[i].addr>=getPC())) {
			zinf = &forcePC;
			pcdone=1;
			if (z80[i].addr!=getPC()) i--;
			c=' ';
		}
		if (zinf->addr==getPC()) {
			dahigh = true;
			pcdone=1;
		}
		mysprintf(zinf, s, da_opcode[zinf->index].format, 
			zinf->a1, zinf->a2, zinf->a3, zinf->a4);
		mprintf("%c%04X:%s\n",c,zinf->addr, s);
		dahigh = false;
	}
}


unsigned short GetLineAddress(unsigned short address,int line) {
	int i;
	if (line<0) {
		disassemble(address-112,128,z80);
		i=0;
		if (z80[0].addr>address) {
			for(i=0;i<96 && (z80[i].addr>address);i++);
		}
		for(;i<128 && (z80[i].addr<address);i++);
		return z80[i+line].addr;
	} else 	{
		disassemble(address,128,z80);
		return z80[line].addr;
	} 
}


void RenderDebug(unsigned int cursor) {
	swiWaitForVBlank();
	consoleClear();
	DisplayDisasm(cursor);
	DisplayRegisterPane();
	printfxy(0,20,"Select = Close");
	printfxy(16,20,"B = Main Menu");
	printfxy(0,21,"A = Step");
	printfxy(16,21,"X = Step Over");
	printfxy(0,22,"Y = Run to cursor");
	printfxy(0,23,"Up/Down/Touchscreen = Scroll");
	swiWaitForVBlank();
	BWLCD();
}

void DisAsm() {
	touchPosition touch;
	unsigned short cursor = getPC();
	int i,b;
	int quit = 0;
	int wastouched=0;
	int y;
	BG0_CR = BG_MAP_BASE(2) | BG_TILE_BASE(1) | BG_32x32 | BG_256_COLOR | BG_PRIORITY(0);
	while(!quit) {
		int update = 0;
		RenderDebug(cursor);
		while(!quit && !update) {
			swiWaitForVBlank();
//			scanKeys();
			int keyrepeat = keysDownRepeat();
			int keydown = keysDown();
			if ((keydown&KEY_SELECT)||(keydown&KEY_B)) {
				quit=1;
			}
			if (keyrepeat&KEY_A) {
				runtimed(3);
				update = 1;
				cursor = getPC();
			}
			if (keyrepeat&KEY_X) {
				unsigned short oldpc = getPC();
				for(b=0;b<16 && getPC()==oldpc;b++) {
					for(i=0;i<2000 && getPC()==oldpc;i++) {
						runtimed(3);
					}
				}
				cursor = getPC();
				update = 1;
			}
			if (keyrepeat&KEY_Y) {
				for(b=0;b<60 && getPC()!=cursor;b++) {
					for(i=0;i<2000 && getPC()!=cursor;i++) {
						runtimed(3);
					}
					RenderDebug(cursor);
				}
				update = 1;
			}
			
			if (keyrepeat&KEY_DOWN) {
				cursor = GetLineAddress(cursor,1);
				update =1;
			}
			if (keyrepeat&KEY_UP) {
				cursor = GetLineAddress(cursor,-1);
				update =1;
			}
			if (keysHeld() & KEY_TOUCH) {
				touch=touchReadXY();
				if (!wastouched) {
					y = touch.py;
					wastouched = 1;
				} else {
					int delta = (touch.py-y)/8;
					if (delta) {
						cursor = GetLineAddress(cursor,-delta);
						update =1;
						y += delta*8;
					}
				}
			} else {
				wastouched = 0;
			}
		}
	}
	FadeToWhite();
	consoleClear();
	BG0_CR = 0;
}
