#include<stdio.h>
#include"nds.h"
#include"bitmap.h"

BITMAP *BitmapDef(BITMAP * bm,const void *image) {
	if (!image) return NULL;
//	if (!bm) bm = (BITMAP *)malloc(sizeof(BITMAP));
	if (!bm) return NULL;
	bm->Header	= (void*)image;
	bm->Info	= (void*)image+sizeof(BITMAPFILEHEADER);
	bm->Pal		= (void*)image+sizeof(BITMAPFILEHEADER)+sizeof(BITMAPINFOHEADER);
	bm->Image	= (void*)image+bm->Header->bfOffBits;
	return bm;
}


unsigned short BitmapGetPixel15(BITMAP * bm,int x, int y) {
	int Height = (bm->Info->biHeight<0)?-bm->Info->biHeight:bm->Info->biHeight;
	int BitsPerLine;
	unsigned char * PixelPtr;
	if (!bm) return 0;
	if (bm->Info->biWidth<=x ||	x<0) return 0;
	if (Height<=y || y<0) return 0;
	BitsPerLine	= (((bm->Info->biWidth-1)|0x3)+1)*bm->Info->biBitCount;
	if (bm->Info->biHeight<0) {
		PixelPtr = bm->Image+(y*(BitsPerLine/8))+((x*bm->Info->biBitCount)/8);
	} else {
		PixelPtr = bm->Image+(((Height-1)-y)*(BitsPerLine/8))+((x*bm->Info->biBitCount)/8);
	}
	switch(bm->Info->biBitCount) {
		case 1:
			return RGBQUADto15(bm->Pal[(PixelPtr[0]>>(0x07-(x&0x07)))&0x01]);
		case 4:
			return RGBQUADto15(bm->Pal[(PixelPtr[0]>>(0x04*((x&0x01)^0x01)))&0x0F]);
		case 8:
			return RGBQUADto15(bm->Pal[PixelPtr[0]]);
		case 16: {
			unsigned short c =PixelPtr[0]|(PixelPtr[1]<<8);
			return RGB15((c>>10)&0x1F,(c>>05)&0x1F,(c>>00)&0x1F);
		}
		case 24:
			return RGBQUADto15(RGB24(PixelPtr[2],PixelPtr[1],PixelPtr[0]));
		default:
			return 0;
	}
}

RGBQUAD BitmapGetPixel24(BITMAP * bm,int x, int y) {
	int Height = (bm->Info->biHeight<0)?-bm->Info->biHeight:bm->Info->biHeight;
	int BitsPerLine;
	unsigned char * PixelPtr;
	if (!bm) return RGB24(0,0,0);
	if (bm->Info->biWidth<=x ||	x<0) return RGB24(0,0,0);
	if (Height<=y || y<0) return RGB24(0,0,0);
	BitsPerLine	= (((bm->Info->biWidth-1)|0x3)+1)*bm->Info->biBitCount;
	if (bm->Info->biHeight<0) {
		PixelPtr = bm->Image+(y*(BitsPerLine/8))+((x*bm->Info->biBitCount)/8);
	} else {
		PixelPtr = bm->Image+(((Height-1)-y)*(BitsPerLine/8))+((x*bm->Info->biBitCount)/8);
	}
	switch(bm->Info->biBitCount) {
		case 1:
			return bm->Pal[(PixelPtr[0]>>(0x07-(x&0x07)))&0x01];
		case 4:
			return bm->Pal[(PixelPtr[0]>>(0x04*((x&0x01)^0x01)))&0x0F];
		case 8:
			return bm->Pal[PixelPtr[0]];
		case 16:
			return RGB15toQUAD(PixelPtr[0]|(PixelPtr[1]<<8));
		case 24:
			return RGB24(PixelPtr[2],PixelPtr[1],PixelPtr[0]);
		default:
			return RGB24(0,0,0);
	}
}

// Returns the palette value 0-255
unsigned char BitmapGetPixelPal(BITMAP * bm,int x, int y) {
	int Height = (bm->Info->biHeight<0)?-bm->Info->biHeight:bm->Info->biHeight;
	int BitsPerLine;
	unsigned char * PixelPtr;
	if (!bm) return 0;
	if (bm->Info->biWidth<=x ||	x<0) return 0;
	if (Height<=y || y<0) return 0;
	BitsPerLine	= (((bm->Info->biWidth-1)|0x3)+1)*bm->Info->biBitCount;
	if (bm->Info->biHeight<0) {
		PixelPtr = bm->Image+(y*(BitsPerLine/8))+((x*bm->Info->biBitCount)/8);
	} else {
		PixelPtr = bm->Image+(((Height-1)-y)*(BitsPerLine/8))+((x*bm->Info->biBitCount)/8);
	}
	switch(bm->Info->biBitCount) {
		case 1:
			return (PixelPtr[0]>>(0x07-(x&0x07)))&0x01;
		case 4:
			return (PixelPtr[0]>>(0x04*((x&0x01)^0x01)))&0x0F;
		case 8:
			return PixelPtr[0];
		case 16:
			return 0;
		case 24:
			return 0;
		default:
			return 0;
	}
}

void BitmapBlit8(BITMAP * bm,const void * screenv, 
					int bmp_x, int bmp_y, int bmp_w, int bmp_h,
					int scr_x, int scr_y, int scr_w, int scr_h,
					int palaug) {
					
	int Height	= (bm->Info->biHeight<0)?-bm->Info->biHeight:bm->Info->biHeight;
	int Width	= bm->Info->biWidth;

	if ( !bm || !screenv ) return;

	unsigned char *screen = (unsigned char *)screenv;
	int x,y;
	for(y=0;y<bmp_h;y++) {
		if (
			((bmp_y+y)>=0) &&
			((bmp_y+y)<Height) &&
			((scr_y+y)>=0) &&
			((scr_y+y)<scr_h) ) {

			for(x=0;x<bmp_w;x+=2) {
				unsigned short read = ((unsigned short *)(screen+((scr_y+y)*scr_w)+scr_x+x))[0];
				if (
					((bmp_x+x)>=0) &&
					((bmp_x+x)<Width) &&
					((scr_x+x)>=0) &&
					((scr_x+x)<scr_w) ) {
					
					read = (read&0xFF00) | (BitmapGetPixelPal(bm,(bmp_x+x),(bmp_y+y))+palaug)&0xFF;
				}
				if (
					((bmp_x+x+1)>=0) &&
					((bmp_x+x+1)<Width) &&
					((scr_x+x+1)>=0) &&
					((scr_x+x+1)<scr_w) ) {
					
					read = (read&0x00FF) | ((BitmapGetPixelPal(bm,(bmp_x+x+1),(bmp_y+y))+palaug)&0xFF)<<8;
				}
				((unsigned short *)(screen+((scr_y+y)*scr_w)+scr_x+x))[0] = read;
			}
		}
	}
}

void BitmapBlit15(BITMAP * bm,const void * screenv, 
					int bmp_x, int bmp_y, int bmp_w, int bmp_h,
					int scr_x, int scr_y, int scr_w, int scr_h) {
					
	int Height	= (bm->Info->biHeight<0)?-bm->Info->biHeight:bm->Info->biHeight;
	int Width	= bm->Info->biWidth;

	if ( !bm || !screenv ) return;

	unsigned short *screen = (unsigned short *)screenv;
	int x,y;
	GETPIXELFP getpixel = BitmapFastInit(bm);
	
	for(y=0;y<bmp_h;y++) {
		if (
			((bmp_y+y)>=0) &&
			((bmp_y+y)<Height) &&
			((scr_y+y)>=0) &&
			((scr_y+y)<scr_h) ) {

			for(x=0;x<bmp_w;x++) {
				if (
					((bmp_x+x)>=0) &&
					((bmp_x+x)<Width) &&
					((scr_x+x)>=0) &&
					((scr_x+x)<scr_w) ) {
					
					screen[((scr_y+y)*scr_w)+scr_x+x] = getpixel((bmp_x+x),(bmp_y+y))|0x8000;
				}
			}
		}
	}
}


void BitmapTile8(BITMAP * bm,const void * tileptr,int palaug) {
	int i,x,y;
	int Height	= (bm->Info->biHeight<0)?-bm->Info->biHeight:bm->Info->biHeight;
	int Width	= bm->Info->biWidth;
	if ( !bm || !tileptr ) return;

	i = 0;
	for(y=0;y<Height;y+=8) {
		for(x=0;x<Width;x+=8) {
			BitmapBlit8(bm,tileptr,x,y,8,8,0,i*8,8,1024*8,palaug);
			i++;
		}
	}
}


static int fHeight,fBitsPerLine;
static BITMAP * fbm;

unsigned short fbmiget1(int x,int y) {
	unsigned char *PixelPtr = fbm->Image+(y*(fBitsPerLine/8))+((x*fbm->Info->biBitCount)/8);
	return RGBQUADto15(fbm->Pal[(PixelPtr[0]>>(0x07-(x&0x07)))&0x01]);
}
unsigned short fbmget1(int x,int y) {
	unsigned char *PixelPtr = fbm->Image+(((fHeight-1)-y)*(fBitsPerLine/8))+((x*fbm->Info->biBitCount)/8);
	return RGBQUADto15(fbm->Pal[(PixelPtr[0]>>(0x07-(x&0x07)))&0x01]);
}
unsigned short fbmiget4(int x,int y) {
	unsigned char *PixelPtr = fbm->Image+(y*(fBitsPerLine/8))+((x*fbm->Info->biBitCount)/8);
	return RGBQUADto15(fbm->Pal[(PixelPtr[0]>>(0x04*((x&0x01)^0x01)))&0x0F]);
}
unsigned short fbmget4(int x,int y) {
	unsigned char *PixelPtr = fbm->Image+(((fHeight-1)-y)*(fBitsPerLine/8))+((x*fbm->Info->biBitCount)/8);
	return RGBQUADto15(fbm->Pal[(PixelPtr[0]>>(0x04*((x&0x01)^0x01)))&0x0F]);
}
unsigned short fbmiget8(int x,int y) {
	unsigned char *PixelPtr = fbm->Image+(y*(fBitsPerLine/8))+((x*fbm->Info->biBitCount)/8);
	return RGBQUADto15(fbm->Pal[PixelPtr[0]]);
}
unsigned short fbmget8(int x,int y) {
	unsigned char *PixelPtr =fbm->Image+(((fHeight-1)-y)*(fBitsPerLine/8))+((x*fbm->Info->biBitCount)/8);
	return RGBQUADto15(fbm->Pal[PixelPtr[0]]);
}
unsigned short fbmiget16(int x,int y) {
	unsigned char *PixelPtr = fbm->Image+(y*(fBitsPerLine/8))+((x*fbm->Info->biBitCount)/8);
	unsigned short c =PixelPtr[0]|(PixelPtr[1]<<8);
	return RGB15((c>>10)&0x1F,(c>>05)&0x1F,(c>>00)&0x1F);
}
unsigned short fbmget16(int x,int y) {
	unsigned char *PixelPtr = fbm->Image+(((fHeight-1)-y)*(fBitsPerLine/8))+((x*fbm->Info->biBitCount)/8);
	unsigned short c =PixelPtr[0]|(PixelPtr[1]<<8);
	return RGB15((c>>10)&0x1F,(c>>05)&0x1F,(c>>00)&0x1F);
}
unsigned short fbmiget24(int x,int y) {
	unsigned char *PixelPtr = fbm->Image+(y*(fBitsPerLine/8))+((x*fbm->Info->biBitCount)/8);
	return RGBQUADto15(RGB24(PixelPtr[2],PixelPtr[1],PixelPtr[0]));
}
unsigned short fbmget24(int x,int y) {
	unsigned char *PixelPtr = fbm->Image+(((fHeight-1)-y)*(fBitsPerLine/8))+((x*fbm->Info->biBitCount)/8);
	return RGBQUADto15(RGB24(PixelPtr[2],PixelPtr[1],PixelPtr[0]));
}

GETPIXELFP BitmapFastInit(BITMAP * bm) {
	fHeight = (bm->Info->biHeight<0)?-bm->Info->biHeight:bm->Info->biHeight;
	fBitsPerLine = (((bm->Info->biWidth-1)|0x3)+1)*bm->Info->biBitCount;
	fbm = bm;
	if (bm->Info->biHeight<0) {
		switch(bm->Info->biBitCount) {
			case 1:
				return fbmiget1;
			case 4:
				return fbmiget4;
			case 8:
				return fbmiget8;
			case 16: {
				return fbmiget16;
			}
			case 24:
				return fbmiget24;
			default:
				return NULL;
		}
	} else {
		switch(bm->Info->biBitCount) {
			case 1:
				return fbmget1;
			case 4:
				return fbmget4;
			case 8:
				return fbmget8;
			case 16:
				return fbmget16;
			case 24:
				return fbmget24;
			default:
				return NULL;
		}
	}

}

