#include<string.h>
#include"calc.h"
#include "hw_83p.h"

//For quicker reference and less typing.
extern CALC_T calc;
extern struct DrZ80 *cpu;
extern memc *mem;
extern STDINT_t *stdint;
extern KEY_t *keys;
extern LCD_t *lcd;

unsigned int DrZ80_rebasePC(unsigned short a) {
	cpu->Z80PC_BASE =(unsigned int)(mem->banks[mc_bank(a)].addr-(a&0xC000));
	return cpu->Z80PC_BASE + a;
}
unsigned int DrZ80_rebaseSP(unsigned short a) {
	cpu->Z80SP_BASE =(unsigned int)(mem->banks[mc_bank(a)].addr-(a&0xC000));
	return cpu->Z80SP_BASE + a;
}
void DrZ80_irq_callback() {
	cpu->Z80_IRQ = 0; // lower irq when accepted
}
unsigned char z80_read(unsigned short a){
	if ((!mem->banks[mc_bank(a)].ram) && (mem->step > 4)) {
		mem->step = 0;
		return 0xFF; // Flash status read
	}
	return mem->banks[mc_bank(a)].addr[mc_base(a)];
}
unsigned short z80_read16(unsigned short a){
	unsigned short d = 0;
	// No self respecting flash code would status check
	// by reading 2 bytes at once.
	d = mem->banks[mc_bank(a)].addr[mc_base(a)];
	a++;
	d |= (mem->banks[mc_bank(a)].addr[mc_base(a)]<<8);
	return d;
}
void z80_write(unsigned char d,unsigned short a) {
	if (mem->banks[mc_bank(a)].ram) {
		mem->banks[mc_bank(a)].addr[mc_base(a)] = d;
	} else {
		if (mem->unlocked) {
			if (mem->ver == 1) flashwrite83p(a,d);
			// Other versions here
			//   HA, yeah right
		}
	}
}
void z80_write16(unsigned short d,unsigned short a) {
	// You can't techincally write 2 bytes to the flash
	// to programm it so this is okay.
	if (mem->banks[mc_bank(a)].ram) {
		mem->banks[mc_bank(a)].addr[mc_base(a)] = d&0xFF;
	}
	a++;
	if (mem->banks[mc_bank(a)].ram) {
		mem->banks[mc_bank(a)].addr[mc_base(a)] = (d>>8)&0xFF;
	}
}


void cpu_init() {
	memset(cpu, 0x00, sizeof(struct DrZ80));
	cpu->z80_rebasePC		= &DrZ80_rebasePC;
	cpu->z80_rebaseSP		= &DrZ80_rebaseSP;
	cpu->z80_read8			= &z80_read;
	cpu->z80_read16			= &z80_read16;
	cpu->z80_write8			= &z80_write;
	cpu->z80_write16		= &z80_write16;
	cpu->z80_in				= &in_83p;	// <- change if other models 
	cpu->z80_out			= &out_83p;	//    supported
	cpu->z80_irq_callback	= &DrZ80_irq_callback;
	cpu->z80irqvector		= 0xFF;
	cpu->Z80IM				= 1;
	cpu->Z80PC				= cpu->z80_rebasePC(0);
	cpu->z80_rebaseSP(0xFFF0);
	cpu->Z80SP				= 0xFFF0;
}

