#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>
//#include <stdbool.h>
#include <nds.h>
#include <fat.h>
#include <sys/dir.h>
#include "browser.h"
#include "bitmap.h"

extern BITMAP icons;
#define min(arg1,arg2) (((arg1)<(arg2))?(arg1):(arg2))

static dirlist_t *browserlist = NULL;
char filename[256];
char path[512];
int Browser_x = 0;
int Browser_y = 0;
bool Browser_HL = false;
bool Browser_clear = false;

void ClearBrowserWindow(int map) {
	int i;
	u16 *mapptr = (u16*)BG_MAP_RAM(map);
	for(i=0;i<32*32;i++) mapptr[i] = 0;
}

void bputc(int map,unsigned char c) {
	if (Browser_x>=0 &&
		Browser_x<256 &&
		Browser_y>=0 &&
		Browser_y<192) {
		u16 (*mapptr)[32] = (u16(*)[32])BG_MAP_RAM(map);
		if (Browser_clear) {
			swiWaitForVBlank();
			ClearBrowserWindow(map);
			Browser_clear = false;
		}
		
		if (c>=32 && c<128) {
			mapptr[Browser_y/8][Browser_x/8] = c + (Browser_HL?128:0);
		} else {
			mapptr[Browser_y/8][Browser_x/8] = c;
		}
	}
	Browser_x+=8;
	if (Browser_x>=256) {
		Browser_x=0;
		Browser_y+=8;
	}
}

void bprintf(int map,const unsigned char * string,...) {
	int i,b,length,sub_length;
	unsigned char *strptr;
	va_list list;
	va_start(list,string);
	length = strlen(string);
	for(i=0;i<length;i++) {
		sub_length =0;
		switch(string[i]) {
			case '\n':
				Browser_x = 0;
				Browser_y +=8;
				break;
			case '\r':
				Browser_x = 0;
				break;
			case '\t':
				do {
					bputc(map,' ');
				} while((Browser_x&0x18)!=0);
				break;
			case '%': {
				i++;
				switch(string[i]) {
					case '%':
						bputc(map,'%');
						break;
					case 'c': {
						unsigned int c = va_arg(list,unsigned int);
						bputc(map,c);
						break;
					}
					case '.':
						i++;
						if (string[i]=='*') {
							sub_length = va_arg(list,int);
							i++;
						} else {
							while(string[i]>='0' && string[i]<='9') {
								sub_length = (sub_length*10)+ (string[i]-'0');
								i++;
							}
						}
						if (string[i]!='s') break;
					case 's':
						strptr = va_arg(list,unsigned char *);
						b = 0;
						while(strptr[b]) {
							switch(strptr[b]) {
								case '\n':
									Browser_x = 0;
									Browser_y +=8;
									break;
								case '\r':
									Browser_x = 0;
									break;
								case '\t':
									do {
										bputc(map,' ');
									} while((Browser_x&0x18)!=0);
									break;
								default:
									bputc(map,strptr[b]);
									break;
							}
							b++;
							if (sub_length) {
								if (b>=sub_length) break;
							}
						}
						break;
					default:
						bputc(map,string[i]);
						break;
				}
				break;
			}
			default:
				bputc(map,string[i]);
				break;
		}
	}
	va_end(list);
}
	
	


void SwapMem(void *a, void *b, size_t size) {
	void *tempswap = malloc(size);
	memcpy(tempswap,a,size);
	memcpy(a,b,size);
	memcpy(b,tempswap,size);
	free(tempswap);
}

void SiftDown(void *base,size_t size,int root, int end,
					int (*compare)(const void *,const void *)) {
	int child;
	while(((root*2)+1)<=end) {
		child = (root*2)+1;
		if (child < end && compare(base+(child*size),base+((child+1)*size))<0) {
			child++;
		}
		if (compare(base+(root*size),base+(child*size))<0) {
			SwapMem(base+(root*size), base+(child*size),size);
			root = child;
		} else return;
	}
}

void HeapSort(void *base,size_t num,size_t size,int (*compare)(const void *,const void *)) {
	int i;
	for(i=(num/2)-1;i>=0;i--) {
		SiftDown(base,size,i,num-1,compare);
	}
	for(i=num-1;i>0;i--){
		SwapMem(base+(i*size),base,size);
		SiftDown(base,size,0,i-1,compare);
	}
}

int DirListCmp(const void *a ,const void *b) {
	return strcasecmp(((dirlist_t*)a)->name,((dirlist_t*)b)->name);
}


void Append_Child(dirlist_t *parent,const char * name,bool drive,bool folder) {
	dirlist_t *list;
	parent->child_count++;
	parent->children = realloc(parent->children,
								parent->child_count*sizeof(dirlist_t));

	list = &parent->children[parent->child_count-1];
	strncpy(list->name,name,63);
	list->name[63]		= 0;
	list->child_count	= 0;
	list->children		= NULL;
	list->parent		= parent;
	list->drive			= drive;
	list->folder		= folder;
	list->highlighted	= false;
	list->checked		= false;
	list->drag			= false;
	list->open			= false;
}


char *GetFullPath(dirlist_t * list) {
	int i,length,newsize,size=1;
	memset(path,0,512);
	while(list->parent) {
		length = strlen(list->name);
		newsize = length+(list->folder?1:0);
		for(i=size-1;i>=0;i--) {
			path[i+newsize] = path[i];
		}
		memcpy(path,list->name,length);
		if (list->folder) {
			path[length] = '/';
		}
		size +=newsize;
		list = list->parent;
	}
	return path;
}

int strwildcmp(const char *wild,const char *string) {
	int length = strlen(string);
	int wildlength  = strlen(wild);
	int i,b=0;
	for(i=0;i<length;i++) {
		if (b>=wildlength) return 1;
		if (wild[b]=='*') {
			for(;wild[b]=='*';b++);
			if (toupper(wild[b])==toupper(string[i])) b++;
			else b--;
		} else {
			if (toupper(wild[b])!=toupper(string[i])) return 1;
			b++;
		}
	}
	for(;wild[b]=='*';b++);
	if (wild[b]!=0) return 1;
	return 0;
}

int TestFilters(const char *string,const char* filters) {
	while(filters[0]!=0) {
		if (!strwildcmp(filters,string)) return TRUE;
		for(;filters[0]!=0;filters++);
		filters++;
	}
	return FALSE;
}

void FillChildren(dirlist_t * list,const char* filters) {
	int i,dcount=0,fcount=0;
	struct stat st;
	DIR_ITER* dir;
	char *path;
	path = GetFullPath(list);
	dir = diropen(path);
	if (!dir) return;
#ifndef EMULATOR
	while (!dirnext(dir, filename, &st)) {
		if (filename[0] != '.') {
			if (st.st_mode&S_IFDIR) {
				Append_Child(list,filename,false,true);
				dcount++;
			}
		}
	}
#endif
	dirreset(dir);
	while (!dirnext(dir, filename, &st)) {
		if (filename[0] != '.') {
			if (!(st.st_mode&S_IFDIR)) {
				if (TestFilters(filename,filters)) {
					Append_Child(list,filename,false,false);
					fcount++;
				}
			}
		}
	}
	if (list->child_count) {
		if (dcount) {
			HeapSort(&list->children[0],dcount,sizeof(dirlist_t),DirListCmp);
		}
		if (fcount) {
			HeapSort(&list->children[dcount],fcount,sizeof(dirlist_t),DirListCmp);
		}
	}
	for(i=0;i<list->child_count;i++) {
		if (list->children[i].folder) {
			FillChildren(&list->children[i],filters);
		}
	}
}


dirlist_t *Build_DirList(const char* filters) {
	int i;
	DIR_ITER* dp;
	dirlist_t *list = malloc(sizeof(dirlist_t));
	if (!list) return NULL;

	strcpy(list->name,"DS");
	list->child_count	= 0;
	list->children		= NULL;
	list->parent		= NULL;
	list->drive			= true;
	list->folder		= true;
	list->highlighted	= false;
	list->checked		= false;
	list->drag			= false;
	list->open			= true;
	
	dp = diropen ("fat1:/");
	if (dp) {
		Append_Child(list,"fat1:",true,true);
		dirclose(dp);
	}
	dp = diropen ("fat2:/");
	if (dp) {
		Append_Child(list,"fat2:",true,true);
		dirclose(dp);
	}
	dp = diropen ("fat3:/");
	if (dp) {
		Append_Child(list,"fat3:",true,true);
		dirclose(dp);
	}

	for(i=0;i<list->child_count;i++) {
		if (list->children[i].folder) {
			FillChildren(&list->children[i],filters);
		}
	}
	return list;
}

void ReleaseDirListIter(dirlist_t *list) {
	int i;
	for(i=0;i<list->child_count;i++) {
		if (list->children[i].child_count) {
			ReleaseDirListIter(&list->children[i]);
		}
	}
	free(list->children);
}

void ReleaseDirList(dirlist_t *list) {
	ReleaseDirListIter(list);
	free(list);
}

int GetChildOffset(dirlist_t *child) {
	int i;
	dirlist_t *parent = child->parent;
	if (!parent) return -1;
	for(i=0;i<parent->child_count;i++) {
		if (&parent->children[i] == child) {
			return i;
		}
	}
	return -1;
}

dirlist_t *GetOffsetChild(dirlist_t *parent,int offset) {
	int i,count,total;
	count=0;
	total=0;
	while(0<=offset) {
		dirlist_t *list = &parent->children[count];
		if (offset == total) return list;
		if (list->folder && list->open && (list->child_count!=0)) {
			parent = list;
			count = -1;
		}
		count++;
		total++;
		while (count >= parent->child_count) {
			i = GetChildOffset(parent);
			if (i < 0) return NULL;
			parent = parent->parent;
			count = i+1;
		}
	}
	return NULL;
}



void printchildren(dirlist_t *parent,int indent) {
	int i,count;
	count=0;
	while(1) {
		dirlist_t *list = &parent->children[count];
		if (list->highlighted == true) Browser_HL = true;
		Browser_x += indent*8;
		if (list->folder) {
			bprintf(0,"%c%.*s\n",((list->open)?4:3),30-indent,list->name);
		} else bprintf(0,"%c%.*s\n",5,30-indent,list->name);
		Browser_HL = false;
		if (list->folder && list->open && (list->child_count!=0)) {
			indent++;
			parent = list;
			count = -1;
		}
		if (Browser_y>192) return;
		count++;
		while (count >= parent->child_count) {
			i = GetChildOffset(parent);
			if (i < 0) return;
			parent = parent->parent;
			count = i+1;
			indent--;
		}
	}
}

int GetRowsIter(dirlist_t *list,int count) {
	int i;
	for(i=0;i<list->child_count;i++) {
		count++;
		if (list->children[i].folder && list->children[i].open) {
			count = GetRowsIter(&list->children[i],count);
		}
	}
	return count;
}


int GetRows(dirlist_t *list) {
	return GetRowsIter(list,0);
}

void printlist(dirlist_t *list) {
	if (!list) return;
	printchildren(list,1);
}


void DrawScrollBar(int start){
	int i;
	u16 *mapptr = (u16 *)BG_MAP_RAM(0);
	mapptr[(0*32)+30] = 11;
	mapptr[(0*32)+31] = 12;
	mapptr[(1*32)+30] = 13;
	mapptr[(1*32)+31] = 14;
	for(i=2;i<22;i++) {
		mapptr[(i*32)+30] = 15;
		mapptr[(i*32)+31] = 15;
	}
	mapptr[(22*32)+30] = 13|BIT(11);
	mapptr[(22*32)+31] = 14|BIT(11);
	mapptr[(23*32)+30] = 11|BIT(11);
	mapptr[(23*32)+31] = 12|BIT(11);
	i = (((start*19)/((GetRows(browserlist)-22)))+2);
	if (i>20) i=20;
	mapptr[(i*32)+30] = 16;
	mapptr[(i*32)+31] = 17;
	i++;
	mapptr[(i*32)+30] = 18;
	mapptr[(i*32)+31] = 19;
}

	
char * Browser(dirlist_t *passedlist) {
	int i;
	u16 *mapptr;
	u16 *tile_ram;
	touchPosition touch;
	keysSetRepeat(15,1);
	swiWaitForVBlank();
	lcdMainOnBottom();
	
	ClearBrowserWindow(0);
	BG0_CR = BG_MAP_BASE(0) | BG_TILE_BASE(1) | BG_32x32 | BG_256_COLOR | BG_PRIORITY(0);
	BG0_X0 = 0;
	BG0_Y0 = 0;

	mapptr = (u16 *)BG_MAP_RAM(0);
	
	static int start	= 0;
	static int select	= 0;
	int keys			= 0;
	int frames			= 0;
	int wastouched		= 0;
	int y				= 0;
	int framestouch		= 0;
	int framessince 	= 0;
	int clicked			= 0;
	
	if (passedlist != browserlist) {
		start	= 0;
		select	= 0;
	}
	if (!passedlist) {
//		browserlist = Build_DirList("*\0\0");
	} else {
		browserlist = passedlist;
	}
	while(1) {
		int update = 0;
		dirlist_t *file = GetOffsetChild(browserlist,start+select);
		GetFullPath(file);
		swiWaitForVBlank();
		Browser_clear = true;
		Browser_x = 0;
		Browser_y = -((start-1)*8);
		file = GetOffsetChild(browserlist,start+select);
		file->highlighted = true;
		printlist(browserlist);
		file->highlighted = false;
		Browser_x = 0;
		Browser_y = (select+1)*8;
		bprintf(0,">");
		Browser_x = 0;
		Browser_y = 0;
		bprintf(0,"%.31s",path);
		DrawScrollBar(start);
		while(!update) {
			int i;
			swiWaitForVBlank();
//			scanKeys();
			keys = keysDownRepeat();
			if ((keys&KEY_B)||(keys&KEY_SELECT)) {
//				if (!passedlist) ReleaseDirList(browserlist);
				FadeToWhite();
				ClearBrowserWindow(0);
				BG0_CR = 0;
				return NULL;
			}
			if (keys&KEY_A) {
				dirlist_t *file = GetOffsetChild(browserlist,start+select);
				if (file) {
					if (file->folder) {
						file->open ^=1;	
					} else {
						char *ret_str = GetFullPath(file);
//						if (!passedlist) ReleaseDirList(browserlist);
						FadeToWhite();
						ClearBrowserWindow(0);
						BG0_CR = 0;
						return ret_str;
					}
					update =1;
				}
			}
			if (keys&KEY_DOWN) {
				if ((select+1)>=22) {
					start++;
				} else select++;
				update =1;
			}
			if (keys&KEY_UP) {
				if (select==0) {
					start--;
				} else select--;
				update =1;
			}
			if (keysHeld() & KEY_TOUCH) {
				touch=touchReadXY();
				if (!wastouched && (touch.px >= (256-16))) {
					framestouch = 0;
					framessince = 0;
					if (touch.py>=16 && touch.py<(192-16)) {
						i = (touch.py/8)-1;
						start =  ((GetRows(browserlist)-22)*i)/19;
					} else if (touch.py<16) {
						start--;
					} else if (touch.py>=(192-16)) {
						start++;
					}
					update = 1;
				} else if (!wastouched) {
					y = touch.py;
					wastouched = 1;
					if ((framestouch>=1 && framestouch<15) && 
						(framessince>=1 && framessince<15)) {
						clicked = 1;
					}
					framestouch=0;
				} else {
					int delta = (touch.py-y)/8;
					if (delta) {
						start -=delta;
						update =1;
						y += delta*8;
					}
				}
			} else {
				if (wastouched) framessince=0;
				framessince++;
				wastouched = 0;
			}
			if ((start+22)>GetRows(browserlist)) {
				start = GetRows(browserlist)-22;
				update =1;
			}
			if (start<0) {
				start = 0;
				update =1;
			}
			if (wastouched) {
				framestouch++;
				select = (y/8)-1;
				update = 1;
			}
			if (select>min(21,GetRows(browserlist)-1)) {
				select = min(21,GetRows(browserlist)-1);
				update = 1;
			}
			if (select<0) {
				select = 0;
				update = 1;
			}
			if (clicked) {
				int i =(y/8)-1;
				if (i>=0 && i<22) {
					dirlist_t *file = GetOffsetChild(browserlist,i+start);
					if (file) {
						if (file->folder) {
							file->open ^=1;	
						} else {
							char *ret_str = GetFullPath(file);
//							if (!passedlist) ReleaseDirList(browserlist);
							FadeToWhite();
							ClearBrowserWindow(0);
							BG0_CR = 0;
							return ret_str;
						}
					}
				}
				clicked =0;
			}
		}
	}
}
	
	



