#ifndef STDINT_H
#define STDINT_H


/*   Interrupts have changed, it is expected that
the cpu will be emulated in time slices, executing
for a set number of tstates.  After each slice,
'count' will be incremented. When 'count' modulo
'divisor' equals 0 an timer interrupt may fire.

Which timer is based on 'timer'. At every point that
a timer interrupt can fire, 'timer' is incremented.
If 'timer' modulo 3 equals 0, then timer1 generates 
the interrupt, any other value timer2 generates it.

'intactive' acts as a mask only now.  If the proper
bits are not set then the relative bits in 'ack'
will not set, and therefore interrupts won't fire.
When the user sets the mask, it is immediately AND
with 'ack' to acknowledge any pending or continuing 
interrupts.
*/


typedef struct {
	unsigned char intactive;
	unsigned char ack;
	unsigned short timer;		// timer always less than 3
								// Select which timer files
	unsigned short divisor;		// Value depends on SPF
								//   slices per second
	unsigned short count;		

}__attribute__ ((packed)) STDINT_t;

#endif
