#ifndef MEM_H
#define MEM_H

#define PAGE_SIZE 0x4000

/* Memory address translation */
#define MC_BANK_MASK	0xC000
#define MC_BASE_MASK	(~MC_BANK_MASK)

#define mc_bank(addr_z) (addr_z >> 14)
#define mc_base(addr_z) (addr_z & MC_BASE_MASK)


/* Bank unit for a partition */
typedef struct {
	unsigned char *addr;		//Pointer to offset of memory.(already paged)
	unsigned int page;		//Current 16kb page
	unsigned int ram;			//This is on the ram chip(also effect write method for flash)
}__attribute__ ((packed)) bank_state_t;

typedef struct {
	unsigned char * flash;		//Pointer to flash memory
	unsigned char * ram;		//Pointer to raem
	unsigned int flash_size;
	unsigned int ram_size;
	unsigned int flash_pages;
	unsigned int ram_pages;
	unsigned int step;			// These 3 are for flash programming
	unsigned int cmd;			// step tells what cycle of the command you are on,
	bank_state_t banks[5];		//Current state of each bank
								// structure 5 is used to preserve the 4th in boot map
	unsigned int boot_mapped;	//Special mapping used in boot that rotates location of pages
	unsigned int unlocked;	//Whether flash is writeable or not.
	unsigned int ver;
}__attribute__ ((packed)) memc;

#endif
