#ifndef LINK_H
#define LINK_H
#include<stdio.h>
#include<nds.h>

#define vlink (((link->calc & 0x03)|(link->pc & 0x03))^3)

// Link timing
#define LINK_DELAY 			100				/* Delay between commands */
#define LINK_GARBAGE_DELAY 	(CPU_SPEED/16)	/* Delay for oncalc garbage collector */
#define LINK_TIMEOUT 		(CPU_SPEED/64)	/* Maximum time given to respond per bit */

#define TI_FLASH_HEADER_SIZE (8+2+1+1+4+1+8+23+1+1+24+4)	
#define TI_FILE_HEADER_SIZE (8+3+42+2)	
#define TI_VAR_HEADER_SIZE (2+2+1+8)

// Link errors
typedef enum {
	LERR_LINK = 1,			/* General link error */
	LERR_TIMEOUT,			/* Time out error */
	LERR_FORCELOAD,			/* Error force loading an application (TI-83+) */
	LERR_CHKSUM,			/* Packet with invalid checksum was received */
	LERR_NOTINIT,			/* Link was not initialized */
	LERR_MEM,				/* Not enough memory on calc */
	LERR_MODEL,				/* Not the correct model for file */
	LERR_FILE				/* Invalid TIFILE in argument */
} LINK_ERR;

// Destination flags
typedef enum {
	SEND_CUR,					/* sends based on current flag settings */
	SEND_RAM,					/* sends to RAM, regardless of flag settings */
	SEND_ARC					/* sends to archive, regardless of flag settings */
} SEND_FLAG;

typedef enum {
	CID_VAR		= 0x06,			/* Request variable header */
	CID_CTS		= 0x09,			/* Clear to send */
	CID_DATA	= 0x15,
	CID_VER		= 0x2D,
	CID_EXIT	= 0x36,
	CID_ACK		= 0x56,
	CID_ERR		= 0x5A,
	CID_RDY		= 0x68,
	CID_SCR		= 0x6D,
	CID_DEL		= 0x88,
	CID_EOT		= 0x92,
	CID_REQ		= 0xA2,
	CID_RTS		= 0xC9
} LINK_COMMAND_ID;



/* Contains connections and current state
 * of a link port. */
typedef struct link {
	u8 calc;				// what we wrote to the link port
	u8 pc;					// what they wrote to the link port
	u16 print;				// print bytes sent
	u32 send_count;		// amount already sent over vlink
	u32 recv_count;		// amount already received over the link

}__attribute__ ((packed)) link_t;


typedef struct {
	u8 size;
	u16 address;
	u8 type;
	u8 data[256];
	u8 chksum;
} __attribute__((packed)) intelhex_t;

/* Header for packets send over the link */
typedef struct _TI_PKTHDR {
	u8 machine_ID;
	u8 command_ID;
	u16 data_len;
} __attribute__((packed)) TI_PKTHDR;

typedef struct _TI_VARHDR {
	u16 length;
	u8 type_ID;
	char name[8];
	u8 version;
	u8 type_ID2;
} __attribute__((packed)) TI_VARHDR;

typedef struct _TI_FLASHHDR {
	u16 sizeLSB;
	u8 type_ID;
	u16 sizeMSB;
	u8 flag;
	u16 offset;
	u16 page;
} __attribute__((packed)) TI_FLASHHDR;

typedef struct _TI_BACKUPHDR {
	u16 flags_size;
	u8 type_ID;
	u16 data_size;
	u16 symbol_size;
	u16 user_addr;
} __attribute__((packed)) TI_BACKUPHDR;
	
typedef struct _TI_DATA {
	u16 length;
	void *data;
} TI_DATA;

typedef struct _TIVAR {
	u16 headersize;			// size of the header up to name, sometimes ignored
	u16 length;				// data size
	u8  vartype;			// what type of varible
	u8  name[8];			// null padded name
	u8  version;			// 0 83+only
	u8  flag;				// bit 7 is if flash 83+only
	u16 length2;			// duplicate of data size
	u8  *data;				// pointer to data
} __attribute__((packed)) TIVAR;


#define RealObj         0x00
#define ListObj         0x01
#define MatObj          0x02
#define EquObj          0x03
#define StrngObj        0x04
#define ProgObj         0x05
#define ProtProgObj     0x06
#define PictObj         0x07
#define GDBObj          0x08
#define UnknownObj      0x09
#define UnknownEquObj   0x0A
#define NewEquObj       0x0B
#define CplxObj         0x0C
#define CListObj        0x0D
#define UndefObj        0x0E
#define WindowObj       0x0F
#define ZStoObj         0x10
#define TblRngObj       0x11
#define LCDObj          0x12
#define BackupObj       0x13
#define AppObj			0x14
#define AppVarObj		0x15
#define TempProgObj     0x16
#define GroupObj        0x17
#define EquObj_2        0x23
// used with linking
#define FlashObj		0x24
#define IDListObj		0x26
#define EquObj_3        0x63

void LINK_init();
int SendFile(char *);
void Load_8xu(FILE* );
#endif

