#ifndef LCD_H
#define LCD_H
#include "calc.h"

//Max frame rate 140
#define MIN_PUSH	(SLICES/140)
//Min frame rate 40
#define MAX_PUSH	(SLICES/40)

#define X_DEC	4
#define X_INC	5
#define Y_DEC	6
#define Y_INC	7

#define LCD_busy 	0x80
#define LCD_word	0x40
#define LCD_display	0x20
#define LCD_reset	0x10
#define LCD_counter 0x02
#define LCD_mode	0x01

#define LCD_MEM_WIDTH	16
#define LCD_PIX_WIDTH	(LCD_MEM_WIDTH*8)
#define LCD_HEIGHT		64
#define LCD_HIEGHT		LCD_HEIGHT

#define DISPLAY_SIZE	(LCD_MEM_WIDTH*LCD_HEIGHT)
#define VIDEO_SIZE		(LCD_PIX_WIDTH*LCD_HEIGHT)

#define LCD_STACK_SIZE	3

#define LcdOffSet( NumX, NumY, NumZ)  (((((NumY)+(NumZ))%(LCD_HEIGHT))*(LCD_MEM_WIDTH))+((NumX)%(LCD_MEM_WIDTH)))

typedef struct LCD {
	unsigned char active;			/* TRUE = on, FALSE = off */
	unsigned char dummy;
	unsigned char word_len;	
	unsigned char mode;				/* LCD increment or decrement */
	unsigned char x, y, z;
	unsigned char contrast;			/* 0 to 63 */
	unsigned short push;
	unsigned short sp;
	unsigned char display[DISPLAY_SIZE];
	unsigned char stack[LCD_STACK_SIZE][DISPLAY_SIZE];
}__attribute__ ((packed)) LCD_t;


void LCD_init();
void Push_LCD();
unsigned char LCD_Command_in();
void LCD_Command_out(unsigned char);
unsigned char LCD_Data_in();
void LCD_Data_out(unsigned char);
unsigned char *BWLCD();
unsigned char *GREYLCD();
#endif /* #ifndef LCD_H */
