#ifndef DISASSEMBLE_H
#define DISASSEMBLE_H


#define mem_read16(mc, adr) ((unsigned int) (((mem_read(mc, adr++) + (mem_read(mc, adr++) << 8))) & 0xFFFF))

#define DA_NOP			0
#define DA_EX_AF_AF_	1
#define DA_DJNZ_X		2
#define DA_JR_X			3
#define DA_JR_CC_X		4
#define DA_LD_RP_X		5
#define DA_ADD_HL_RP	6
#define DA_LD__BC__A	7
#define DA_LD_A__BC_	8
#define DA_LD__DE__A	9
#define DA_LD_A__DE_	10
#define DA_LD__X__HL	11
#define DA_LD_HL__X_	12
#define DA_LD__X__A		13
#define DA_LD_A__X_		14
#define DA_INC_RP		15
#define DA_DEC_RP		16
#define DA_INC_R		17
#define DA_DEC_R		18
#define DA_LD_R_X		19
#define DA_RLCA			20
#define DA_RRCA			21
#define DA_RLA			22
#define DA_RRA			23
#define DA_DAA			24
#define DA_CPL			25
#define DA_SCF			26
#define	DA_CCF			27
#define DA_LD_R_R		28
#define DA_HALT			29
#define DA_ALU			30
#define DA_RET_CC		31
#define DA_POP_RP		32
#define DA_RET			33
#define DA_EXX			34
#define DA_JP_HL		35
#define DA_LD_SP_HL		36
#define DA_JP_CC_X		37
#define DA_JP_X			38
#define DA_OUT__X__A	39
#define DA_IN_A__X_		40
#define DA_EX__SP__HL	41
#define DA_EX_DE_HL		42
#define DA_DI			43
#define DA_EI			44
#define DA_CALL_CC_X	45
#define DA_PUSH_RP		46
#define DA_CALL_X		47
#define DA_ALU_X		48
#define DA_RST_X		49
#define DA_ROT			50
#define DA_BIT			51
#define DA_RES			52
#define DA_SET			53
#define DA_IN_R__C_		54
#define DA_OUT__C__R	55
#define DA_SBC_HL_RP	56
#define DA_ADC_HL_RP	57
#define DA_LD__X__RP	58
#define DA_LD_RP__X_	59
#define DA_NEG			60
#define DA_RETN			61
#define DA_RETI			62
#define DA_IM_X			63
#define DA_LD_I_A		64
#define DA_LD_R_A		65
#define DA_LD_A_I		66
#define DA_LD_A_R		67
#define DA_RRD			68
#define DA_RLD			69
#define DA_NOP_ED		70
#define DA_BLI			71

#define DA_ROT_R		72
#define DA_BIT_R		73
#define DA_RES_R		74
#define DA_SET_R		75

#define DA_ROT_I		76
#define DA_BIT_I		77
#define DA_RES_I		78
#define DA_SET_I		79

#define DA_ADD_RI_RP	80
#define DA_LD_RI__X_	81
#define DA_LD__X__RI	82
#define DA_INC_RI		83
#define DA_DEC_RI		84
#define DA_LD_RI_X		85
#define DA_LD_RI_R		86
#define DA_LD_R_RI		87
#define DA_ALU_RI		88

#define DA_JP_RI		89
#define DA_LD_SP_RI		90
#define DA_EX__SP__RI	91

#define DA_LABEL		92
#define DA_BCALL		93
#define DA_BCALL_N		94

#define DA_BIT_RF		95
#define DA_RES_RF		96
#define DA_SET_RF		97

#define DA_BIT_IF		98
#define DA_RES_IF		99
#define DA_SET_IF		100

#define DA_BJUMP		101
#define DA_BJUMP_N		102

typedef struct Z80_info {
	int index;
	unsigned int a1, a2, a3, a4;
	unsigned char size;			/* Size of command */
	unsigned short addr;
} Z80_info_t;

typedef struct Z80_command {
	char format[32];			/* printf formatted string */
#ifdef da_ready
	char cycles;				/* Command cycles to complete */
	char cycles_cond;			/* Conditional cycles to complete */
	char flag_effects[8];		/* Flag effects for all 8 bits */
	char *flag_description;		/* optional description of flag effects */
#endif
} Z80_com_t;

int disassemble(unsigned short, unsigned long, Z80_info_t *);

#endif /* #ifndef DISASSEMBLE_H */
