#ifndef CALC_H
#define CALC_H

#define FALSE 0
#define TRUE 1


#define CPU_SPEED	6000000
//Maximum number of interrupts that can occur
#define SLICES		1680
//Execution time between interrupts.
#define TimeSlice	(CPU_SPEED/SLICES)
//Slices per Frame
#define SPF			(SLICES/60)

#define SAVE_VERSION "0000"

#include "drz80.h"
#include "lcd.h"
#include "mem.h"
#include "ti_stdint.h"
#include "key.h"
#include "link.h"



typedef struct {
	int nextslice;			//number of tstates pending for the next slice.
	unsigned int slices;	//number of slices since start(critical for HW code)
	unsigned int frames;	//frames that would be rendered.
	unsigned long long tstates;
}__attribute__ ((packed))  TIMER_t;

#define MAX_REWIND 14

typedef struct {
	struct DrZ80 cpu;
	TIMER_t time_c;
	LCD_t lcd_c;
	link_t link;
	memc mem_c;
	STDINT_t stdint_c;
	KEY_t keys_c;
	unsigned char ram[0x8000];
}__attribute__ ((packed)) BACKUP;

typedef struct {
	BACKUP backup[MAX_REWIND];
	int delay;
	int frames;
	int start;
	int count;
} REWIND_t;



typedef struct {
	struct DrZ80 cpu;
	TIMER_t time_c;
	LCD_t lcd_c;
	link_t link;
	memc mem_c;
	STDINT_t stdint_c;
	KEY_t keys_c;
	unsigned char ram[0x8000];
	unsigned char rom[0x4000*0x20];
	unsigned int fakeon;
}__attribute__ ((packed)) CALC_T;




typedef struct {
	unsigned char save_path[256];
	union {
		unsigned char keys[12][2];
		struct {
			unsigned char A[2];
			unsigned char B[2];
			unsigned char Select[2];
			unsigned char Start[2];
			unsigned char Right[2];
			unsigned char Left[2];
			unsigned char Up[2];
			unsigned char Down[2];
			unsigned char R[2];
			unsigned char L[2];
			unsigned char X[2];
			unsigned char Y[2];
		};
	};
	unsigned int skin_n;
	unsigned char skin_n_path[256];
	unsigned char key_n_path[256];
	unsigned int skin_r;
	unsigned char skin_r_path[256];
	unsigned char key_r_path[256];
	unsigned int skin_l;
	unsigned char skin_l_path[256];
	unsigned char key_l_path[256];
	unsigned int rotate;
	unsigned int autosave;
} CONFIG_T;

typedef struct {
	unsigned char Name[10];
	unsigned char group;
	unsigned char bit;
} KEYLAYOUT_t;

// Macro to concatenate two symbols:
#define TOKCAT(x,y) x##y
// Macro to expand preprocessor variables and concatenate:
#define TOKCAT2(x,y) TOKCAT(x,y)
// Macro to concatenate source line with a symbol:
#define LINECAT(x) TOKCAT2(x, __LINE__ )
 
#define STR_SWITCH(zz) char *STR_TEST = (zz); if (0)

#define STR_CASE(zz)\
goto LINECAT(A);}\
while (!strncasecmp(STR_TEST,(zz),strlen(zz))) {\
LINECAT(A)


//Some are incorrect, so please standby.
#define getPC() ((unsigned short)(cpu->Z80PC-cpu->Z80PC_BASE))
#define getSP() ((unsigned short)(cpu->Z80SP))
#define getA()  ((unsigned char)(cpu->Z80A>>24)&0xFF)
#define getF()  ((unsigned char)(cpu->Z80F>>00)&0xFF)
#define getB()  ((unsigned char)(cpu->Z80BC>>24)&0xFF)
#define getC()  ((unsigned char)(cpu->Z80BC>>16)&0xFF)
#define getD()  ((unsigned char)(cpu->Z80DE>>24)&0xFF)
#define getE()  ((unsigned char)(cpu->Z80DE>>16)&0xFF)
#define getH()  ((unsigned char)(cpu->Z80HL>>24)&0xFF)
#define getL()  ((unsigned char)(cpu->Z80HL>>16)&0xFF)
#define getA2()  ((unsigned char)(cpu->Z80A2>>24)&0xFF)
#define getF2()  ((unsigned char)(cpu->Z80F2>>00)&0xFF)
#define getB2()  ((unsigned char)(cpu->Z80BC2>>24)&0xFF)
#define getC2()  ((unsigned char)(cpu->Z80BC2>>16)&0xFF)
#define getD2()  ((unsigned char)(cpu->Z80DE2>>24)&0xFF)
#define getE2()  ((unsigned char)(cpu->Z80DE2>>16)&0xFF)
#define getH2()  ((unsigned char)(cpu->Z80HL2>>24)&0xFF)
#define getL2()  ((unsigned char)(cpu->Z80HL2>>16)&0xFF)
#define getAF() ((unsigned short)((getA()<<8)+(getF())))
#define getBC() ((unsigned short)((cpu->Z80BC>>16)&0xFFFF))
#define getDE() ((unsigned short)((cpu->Z80DE>>16)&0xFFFF))
#define getHL() ((unsigned short)((cpu->Z80HL>>16)&0xFFFF))
#define getAF2() ((unsigned short)((getA2()<<8)|(getF2())))
#define getBC2() ((unsigned short)((cpu->Z80BC2>>16)&0xFFFF))
#define getDE2() ((unsigned short)((cpu->Z80DE2>>16)&0xFFFF))
#define getHL2() ((unsigned short)((cpu->Z80HL2>>16)&0xFFFF))
#define getIX() ((unsigned short)((cpu->Z80IX>>16)&0xFFFF))
#define getIY() ((unsigned short)((cpu->Z80IY>>16)&0xFFFF))
#define getIM() ((unsigned char)(cpu->Z80IM))
#define getI() ((unsigned char)(cpu->Z80I))
#define getIFF1() ((unsigned char)((cpu->Z80IF>>0)&0x01))
#define getIFF2() ((unsigned char)((cpu->Z80IF>>1)&0x01))
#define getHALT() ((unsigned char)((cpu->Z80IF>>2)&0x01))
#define getR() ((unsigned char)(cpu->spare))


void invalidateRewind(unsigned int);

#endif
