#ifndef BROWSER_H
#define BROWSER_H

typedef struct DIRLIST dirlist_t;

struct DIRLIST {
	char name[64];
	int length;				//Length of name
	int sub;				//How many sub directiories in is it
	long child_count;		//Number of childern
	dirlist_t *children;	//List of children
	dirlist_t *parent;		//Pointer to parent, null if at system
	bool drive;				//marked for fat0: fat1: ...
	bool folder;			//If its a folder
	bool highlighted;		//If listing is Highlighted
	bool checked;			//If its check marked
	bool drag;				//If its being dragged
	bool open;				//If folder is open
};

dirlist_t *Build_DirList(const char*);
void ReleaseDirList(dirlist_t *);
int GetRows(dirlist_t *);
void printlist(dirlist_t *);
dirlist_t *GetOffsetChild(dirlist_t *,int );
char *GetFullPath(dirlist_t *);
char * Browser(dirlist_t *);
void ClearBrowserWindow();
#endif

