#ifndef BITMAP_H
#define BITMAP_H

/* Grabbed this file from a google search, written by Michael Sweet.
 * Slightly modified.
 */

/*
 * Bitmap file data structures (these are defined in <wingdi.h> under
 * Windows...)
 *
 * Note that most Windows compilers will pack the following structures, so
 * when reading them under MacOS or UNIX we need to read individual fields
 * to avoid differences in alignment...
 */

typedef struct                       /**** BMP file header structure ****/
    {
    unsigned short bfType;           /* Magic number for file */
    unsigned int   bfSize;           /* Size of file */
    unsigned short bfReserved1;      /* Reserved */
    unsigned short bfReserved2;      /* ... */
    unsigned int   bfOffBits;        /* Offset to bitmap data */
    }__attribute__ ((packed)) BITMAPFILEHEADER;

#define BF_TYPE 0x4D42             /* "MB" */

typedef struct                       /**** BMP file info structure ****/
    {
    unsigned int   biSize;           /* Size of info header */
    int            biWidth;          /* Width of image */
    int            biHeight;         /* Height of image */
    unsigned short biPlanes;         /* Number of color planes */
    unsigned short biBitCount;       /* Number of bits per pixel */
    unsigned int   biCompression;    /* Type of compression to use */
    unsigned int   biSizeImage;      /* Size of image data */
    int            biXPelsPerMeter;  /* X pixels per meter */
    int            biYPelsPerMeter;  /* Y pixels per meter */
    unsigned int   biClrUsed;        /* Number of colors used */
    unsigned int   biClrImportant;   /* Number of important colors */
    }__attribute__ ((packed)) BITMAPINFOHEADER;

/*
 * Constants for the biCompression field...
 */

#define BI_RGB       0             /* No compression - straight BGR data */
#define BI_RLE8      1             /* 8-bit run-length compression */
#define BI_RLE4      2             /* 4-bit run-length compression */
#define BI_BITFIELDS 3             /* RGB bitmap with RGB masks */

typedef struct                       /**** Colormap entry structure ****/
    {
    unsigned char  rgbBlue;          /* Blue value */
    unsigned char  rgbGreen;         /* Green value */
    unsigned char  rgbRed;           /* Red value */
    unsigned char  rgbReserved;      /* Reserved */
    }__attribute__ ((packed)) RGBQUAD;

typedef struct                       /**** Bitmap information structure ****/
    {
    BITMAPINFOHEADER bmiHeader;      /* Image header */
    RGBQUAD          bmiColors[256]; /* Image colormap */
    }__attribute__ ((packed)) BITMAPINFO;


typedef struct {
	BITMAPFILEHEADER	*Header;
	BITMAPINFOHEADER	*Info;
	RGBQUAD				*Pal;
	unsigned char		*Image;
} BITMAP;

#define RGB24( r , g, b ) ((RGBQUAD){b,g,r,0})

#define GetRValue15( rgb ) ((rgb)&0x1F)
#define GetGValue15( rgb ) (((rgb)>>5)&0x1F)
#define GetBValue15( rgb ) (((rgb)>>10)&0x1F)

#define RGBQUADto15( rgb ) (RGB15(((rgb).rgbRed>>3),((rgb).rgbGreen>>3),((rgb).rgbBlue>>3)))
#define RGB15toQUAD( rgb ) (RGB24((GetRValue15(rgb)<<3),(GetGValue15(rgb)<<3),(GetBValue15(rgb)<<3)))


typedef unsigned short (*GETPIXELFP)(int,int);

BITMAP *BitmapDef(BITMAP *,const void *);
unsigned short BitmapGetPixel15(BITMAP *,int, int);
RGBQUAD BitmapGetPixel24(BITMAP *,int, int);
void BitmapTile8(BITMAP * ,const void * , int );
void BitmapBlit8(BITMAP *,const void *,int,int,int,int,int,int,int,int,int);
void BitmapBlit15(BITMAP *,const void *,int,int,int,int,int,int,int,int);
GETPIXELFP BitmapFastInit(BITMAP *);
#endif


