/*---------------------------------------------------------------------------------

	default ARM7 core

	Copyright (C) 2005
		Michael Noland (joat)
		Jason Rogers (dovoto)
		Dave Murphy (WinterMute)

	This software is provided 'as-is', without any express or implied
	warranty.  In no event will the authors be held liable for any
	damages arising from the use of this software.

	Permission is granted to anyone to use this software for any
	purpose, including commercial applications, and to alter it and
	redistribute it freely, subject to the following restrictions:

	1.	The origin of this software must not be misrepresented; you
		must not claim that you wrote the original software. If you use
		this software in a product, an acknowledgment in the product
		documentation would be appreciated but is not required.
	2.	Altered source versions must be plainly marked as such, and
		must not be misrepresented as being the original software.
	3.	This notice may not be removed or altered from any source
		distribution.

---------------------------------------------------------------------------------*/
#include <nds.h>

//---------------------------------------------------------------------------------
void startSound(int sampleRate, const void* data, u32 bytes, u8 channel, u8 vol,  u8 pan, u8 format) {
//---------------------------------------------------------------------------------
	SCHANNEL_TIMER(channel)  = SOUND_FREQ(sampleRate);
	SCHANNEL_SOURCE(channel) = (u32)data;
	SCHANNEL_LENGTH(channel) = bytes >> 2 ;
	SCHANNEL_CR(channel)     = SCHANNEL_ENABLE | SOUND_ONE_SHOT | SOUND_VOL(vol) | SOUND_PAN(pan) | (format==1?SOUND_8BIT:SOUND_16BIT);
}

//---------------------------------------------------------------------------------
s32 getFreeSoundChannel() {
//---------------------------------------------------------------------------------
	int i;
	for (i=0; i<16; i++) {
		if ( (SCHANNEL_CR(i) & SCHANNEL_ENABLE) == 0 ) return i;
	}
	return -1;
}


touchPosition first,tempPos;

//---------------------------------------------------------------------------------
void VcountHandler() {
//---------------------------------------------------------------------------------
	static int lastbut = -1;
	
	uint16 but=0, x=0, y=0, xpx=0, ypx=0, z1=0, z2=0;

	but = REG_KEYXY;

	if (!( (but ^ lastbut) & (1<<6))) {
 
		tempPos = touchReadXY();

		if ( tempPos.x == 0 || tempPos.y == 0 ) {
			but |= (1 <<6);
			lastbut = but;
		} else {
			x = tempPos.x;
			y = tempPos.y;
			xpx = tempPos.px;
			ypx = tempPos.py;
			z1 = tempPos.z1;
			z2 = tempPos.z2;
		}
		
	} else {
		lastbut = but;
		but |= (1 <<6);
	}

	IPC->touchX			= x;
	IPC->touchY			= y;
	IPC->touchXpx		= xpx;
	IPC->touchYpx		= ypx;
	IPC->touchZ1		= z1;
	IPC->touchZ2		= z2;
	IPC->buttons		= but;

}

//---------------------------------------------------------------------------------
void VblankHandler(void) {
//---------------------------------------------------------------------------------

	u32 i;

	//sound code  :)
	TransferSound *snd = IPC->soundData;
	IPC->soundData = 0;

	if (0 != snd) {

		for (i=0; i<snd->count; i++) {
			s32 chan = getFreeSoundChannel();

			if (chan >= 0) {
				startSound(snd->data[i].rate, snd->data[i].data, snd->data[i].len, chan, snd->data[i].vol, snd->data[i].pan, snd->data[i].format);
			}
		}
	}
}

void PowerDown() {
	if(IPC->buttons & BIT(7)) {
		u32 ie_save = REG_IE;
		REG_IME = 0;
		REG_IF = ~0;
		u32 power = readPowerManagement(PM_CONTROL_REG);
		writePowerManagement(PM_CONTROL_REG, PM_LED_CONTROL(1));
		REG_IE = IRQ_LID;
		REG_IME = 1;
		swiSleep();
		REG_IF = ~0;
		REG_IME = 0;
		writePowerManagement(PM_CONTROL_REG, power);
		REG_IE = ie_save;
		REG_IME = 1;
	} 
}
void BackLightOff() {
	REG_IME = 0;
	REG_IF = ~0;
	u32 power = readPowerManagement(PM_CONTROL_REG) & (~PM_BACKLIGHT_BOTTOM) & (~PM_BACKLIGHT_TOP);
	writePowerManagement(PM_CONTROL_REG, power);
	REG_IME = 1;
}
void BackLightOn() {
	REG_IME = 0;
	REG_IF = ~0;
	u32 power = readPowerManagement(PM_CONTROL_REG) | PM_BACKLIGHT_BOTTOM | PM_BACKLIGHT_TOP;
	writePowerManagement(PM_CONTROL_REG, power);
	REG_IME = 1;
}

void FIFOHandler() {
	while(!(REG_IPC_FIFO_CR&IPC_FIFO_RECV_EMPTY)) {
		int cmd = REG_IPC_FIFO_RX;
		switch(cmd&0x03) {
			case 0x00:
				//Null Do Nothing
				break;
			case 0x01:
				PowerDown();
				break;
			case 0x02:
				BackLightOff();
				break;
			case 0x03:
				BackLightOn();
				break;
		}
	}
}


//---------------------------------------------------------------------------------
int main(int argc, char ** argv) {
//---------------------------------------------------------------------------------

	// read User Settings from firmware
	readUserSettings();

	//enable sound
	powerON(POWER_SOUND);
	writePowerManagement(PM_CONTROL_REG,readPowerManagement(PM_CONTROL_REG) | 
										PM_SOUND_MUTE  |
										PM_BACKLIGHT_BOTTOM |
										PM_BACKLIGHT_TOP);
//	SOUND_CR = SOUND_ENABLE | SOUND_VOL(0x7F);
	SOUND_CR = 0;
	
	irqInit();

	// Start the RTC tracking IRQ
	initClockIRQ();

	SetYtrigger(80);
	irqSet(IRQ_VCOUNT, VcountHandler);
	irqSet(IRQ_VBLANK, VblankHandler);
	irqSet(IRQ_FIFO_NOT_EMPTY, FIFOHandler);
	irqEnable( IRQ_VBLANK | IRQ_VCOUNT | IRQ_FIFO_NOT_EMPTY);
	REG_IPC_FIFO_CR = IPC_FIFO_SEND_CLEAR | IPC_FIFO_RECV_IRQ | IPC_FIFO_ERROR | IPC_FIFO_ENABLE;

	// Keep the ARM7 mostly idle
	while (1) swiWaitForVBlank();
}


