import nds.Bios;
import nds.Key;
import nds.Video;
import nds.pstros.video.NDSFont;
import nds.pstros.video.NDSGraphics;
import nds.pstros.video.NDSImage;

/*
 * Created on May 16, 2008
 *
 */

/**
 * @author ole
 *
 */
public class VideoTest {
	public static void main(String [] args) {
		VideoTest vt = new VideoTest();
		vt.run();
	}

	private int videoAddr;
	
	private NDSImage tile;
	private NDSImage ball;
	
	//width and height of the tile
	private int tileW;
	private int tileH;
	//position of the ball;
	private int ballX = 0;
	private int ballY = 0;
	private int backgroundCleanX = 0;
	private int backgroundCleanY = 0;
	
	//movement vector of the ball
	private int incX = 1;
	private int incY = 1;
	
	//semitransparent pixels
	private int[] rgb;

	
	public void run() {
		System.out.println("Running video test");
		Video.initVideo();
		videoAddr = Video.BG_BMP_RAM(0);

		try {
			loadImages();
		} catch (Exception e) {
			System.out.println("load images failed!");
			System.out.println(e);
			return;
		}

		NDSGraphics g = new NDSGraphics();
		
		NDSFont fnt = new NDSFont("system", 0, 12);
		g.setFont(fnt);
		

		tileW = tile.getWidth();
		tileH = tile.getHeight();
		
		initCanvas(g, tile);
	
		//border of the screen
		int maxX = 256 - ball.getWidth();
		int maxY = 192 - ball.getHeight();
        
	        int keys  = Key.held();
      
        	
	        //loop until the START is pressed
	        while((keys & Key.START)==0) {
			//store the position of the ball
			backgroundCleanX = ballX;
			backgroundCleanY = ballY;

			//update position of the ball
			ballX += incX;
			if (ballX > maxX || ballX < 0) {
				incX = -incX;
			}
			ballY += incY;
			if (ballY > maxY || ballY < 0) {
		            	incY = -incY;
			}

			//check the keys and wait for the VBlank
			Key.scan();
			keys = Key.held();
	           	Bios.swiWaitForVBlank();
	           	//VBlank just started - let's draw
	           	paint(g);
	            
	        }

	}
	
	private void paint(final NDSGraphics g) {
	        int tileX = (backgroundCleanX / tileW) * tileW;
	        int tileY = (backgroundCleanY / tileH) * tileH;
        
        	//repaint background
	        g.drawImage(tile, tileX, tileY);
	        g.drawImage(tile, tileX + tileW, tileY);
	        g.drawImage(tile, tileX, tileY + tileH);
	        g.drawImage(tile, tileX + tileW, tileY + tileH);
	        g.drawImage(tile, 100, 100);

	        //draw ball
	        g.drawImage(ball, ballX,ballY);
        
	        //draw the text
	        g.setColor(0xFFFFFF);
	        g.drawString("Video test", 10,20);
        
	        //draw the semitransparent rectangle 
	        g.setClip(100,100, 31,31);
	        g.drawRGB(rgb, 0, 32, 100 , 100 , 32,32, true);
	        g.setClip(0,0, 256,192);
	}
	
	private void loadImages()  throws Exception {
		tile = NDSImage.createImage(this.getClass().getResourceAsStream("tile.png"));
		ball = NDSImage.createImage(this.getClass().getResourceAsStream("ball.png"));
		
	        rgb = createRGB();

	}
	
	private int[] createRGB () {
		int size = 32 * 32;
		int[] result = new int[size];
		
		for (int i = 0; i < size; i++) {
			
			int color  = i >> 2; 
			int pixel = 0x40000000 |
				(color << 16) |
				((255-color));
			result[i++]= pixel;
			result[i++]= pixel;
			result[i++]= pixel;
			result[i]= pixel;
			
		}
		return result;
	}
	public void initCanvas(NDSGraphics g, NDSImage tile) {
		g.setClip(0,0, 256, 192);
		
		int maxX = 256;
		int maxY = 192;
		
		
		for (int j= 0; j < maxY; j+= tileH) {
			for (int i = 0; i < maxX; i+=tileW) {
				g.drawImage(tile, i, j);
			}
		}
	}
	

}
