// A little example showing threading capabilities
public class Threading implements Runnable {

	private char who = 'X';
	private Integer starter = null;
	
	public Threading(char who, Integer starter) {
		this.who = who;
		this.starter = starter;
	}
	
    public void run() {

	    try {
			// Wait for a notification on starter
    		synchronized(this.starter) {
	    		this.starter.wait();
		    }
			// Let's go
			for(long i=0; i<10; i++) {
			  boolean doSleep = false;
			  synchronized(this.starter) {
				  this.starter = new Integer(this.starter.intValue() + 1);
				  System.out.print(who + ":" + i + " ");
				  if ( (this.starter.intValue() % 3) == 2 ) doSleep = true;
			  }
			  // Wait a bit, to see how scheduling is done
			  if (doSleep) {
				  Thread.sleep(10);
			  }
			}
	    } catch (Exception e) {
   		    System.err.println("Exception");	    
	    }
    }
    
    public static void main(String[] args) {
        System.out.println("Threading Example");

		Integer starter = new Integer(0);

		int THREADS = 10;

		// Create and start the Threads		
		Threading [] runners = new Threading[THREADS];
		for(int i=0; i<THREADS;i++) {
			runners[i] = new Threading((char)('A'+i),starter);
			Thread t = new Thread(runners[i]);
			t.start();
		}

 	    try {
			// Sleep of a while
			Thread.sleep(100);
		} catch(Exception ex) {
			ex.printStackTrace();
		}

		// Signal them
		synchronized(starter) {
  		  starter.notifyAll();
		}

		try {
			// Sleep of a while
			Thread.sleep(100);
		} catch(Exception ex) {
			ex.printStackTrace();
		}
		System.out.println("End of main thread");
    }
    
}
