import nds.File;
import nds.Console;
import nds.Sprite;
import nds.Memory;
import nds.Video;
import nds.Key;
import nds.Bios;

public class SpriteTest {

	public static void main(String [] args) {
            // check if file exists
            if(!File.exists("sprite.img.bin")) {
                System.out.println("ERR: 'sprite.img.bin' does not exist.");
                return;
            }

            if(!File.exists("sprite.pal.bin")) {
                System.out.println("ERR: 'sprite.pal.bin' does not exist.");
                return;
            }

            // main screen turn on
            Video.setMode( Video.MODE_0_2D | Video.DISPLAY_SPR_1D_LAYOUT | Video.DISPLAY_SPR_ACTIVE);

            // enable vram for sprites
            Video.vramSetBankB( Video.VRAM_B_MAIN_SPRITE_0x06400000 );

            // load a sprite to beginning of sprite VRAM
            File.loadToVRAM("sprite.img.bin", Memory.SPRITE_GFX);

            // load the sprite's palette
            File.loadToVRAM("sprite.pal.bin", Memory.SPRITE_PALETTE);

            Sprite spr = new Sprite();
            
            spr.entry = 0;

            spr.x = 10;
            spr.y = 10;

            spr.attr0 = Sprite.ATTR0_NORMAL | Sprite.ATTR0_COLOR_256 | Sprite.ATTR0_SQUARE;
            spr.attr1 = Sprite.ATTR1_SIZE_32;
            spr.attr2 = 0;

            spr.update();

            System.out.print("Arrows to move. Start to exit.");

            // make sure they aren't holding START, or the program ends right away
            while((Key.held() & Key.START) != 0) {
                Key.scan();
                Bios.swiWaitForVBlank();
            }

            int keys;

            while((Key.held() & Key.START)==0) {
                Bios.swiWaitForVBlank();
                Key.scan();

                keys = Key.held();

                if((keys & Key.LEFT)!=0)
                    spr.x--;

                if((keys & Key.RIGHT)!=0)
                    spr.x++;

                if((keys & Key.UP)!=0)
                    spr.y--;

                if((keys & Key.DOWN)!=0)
                    spr.y++;
                if(spr.x < 0)
                    spr.x = 0;
                if(spr.x > 256-32)
                    spr.x = 256-32;
                if(spr.y < 0)
                    spr.y = 0;
                if(spr.y > 192-32)
                    spr.y = 192-32;

                spr.update();
            }

	}
	
}

