import java.io.*;
import nds.File;
import nds.Console;

public class FileTest {

	public static void main(String [] args) {
            // check if file exists
            boolean exists = File.exists("test.txt");
            System.out.println("test.txt exists: "+exists);

            // check file size
            int size = File.size("test.txt");
            System.out.println("test.txt size: "+size);

            // Create array to hold data
            byte[] bytes = new byte[20];

            // Load at most 20 bytes
            size = File.load("test.txt", bytes, 20);
            if(size > 0) { // If we've loaded some data, print it out
                System.out.println("loaded "+size+" bytes.");
                String text = new String(bytes, 0, size);
                System.out.println("-----\n" + text + "\n-----");
            }
            else { // Data failed to load
                System.out.println("Error loading: "+size);
            }
	}
	
}
