unit SetPassword_MainWin;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, Buttons,_m_Tools, FileCtrl, inifiles,
  ComCtrls;

type
  TMain = class(TForm)
    StartupTimer: TTimer;
    InstallLbl: TLabel;
    PrgBar: TProgressBar;
    OKBtn: TBitBtn;
    CancelBtn: TBitBtn;
    Key_Up: TButton;
    Key_Down: TButton;
    Key_Left: TButton;
    Key_Right: TButton;
    KEY_SL: TButton;
    Key_SR: TButton;
    Key_A: TButton;
    Key_B: TButton;
    Key_X: TButton;
    Key_Y: TButton;
    Key_Start: TButton;
    Key_Select: TButton;
    PasswordEdt: TEdit;
    ClearBtn: TButton;
    ReadmeMemo: TMemo;
    procedure FormCreate(Sender: TObject);
    procedure StartupTimerTimer(Sender: TObject);
    procedure CancelBtnClick(Sender: TObject);
    procedure Key_UpClick(Sender: TObject);
    procedure Key_DownClick(Sender: TObject);
    procedure Key_LeftClick(Sender: TObject);
    procedure Key_RightClick(Sender: TObject);
    procedure Key_AClick(Sender: TObject);
    procedure Key_BClick(Sender: TObject);
    procedure Key_XClick(Sender: TObject);
    procedure Key_YClick(Sender: TObject);
    procedure KEY_SLClick(Sender: TObject);
    procedure Key_SRClick(Sender: TObject);
    procedure Key_StartClick(Sender: TObject);
    procedure Key_SelectClick(Sender: TObject);
    procedure ClearBtnClick(Sender: TObject);
    procedure OKBtnClick(Sender: TObject);
  private
    { Private 錾 }
  public
    { Public 錾 }
    procedure EnabledPassKeys(e:boolean);
  end;

var
  Main: TMain;

implementation

uses SetPassword_DrvSelWin, SetPassword_SelMLWin, _SplitML;

{$R *.dfm}

// ----------------------

const EPK_None=0;
const EPK_Up=1;
const EPK_Down=2;
const EPK_Left=3;
const EPK_Right=4;
const EPK_SL=5;
const EPK_SR=6;
const EPK_A=7;
const EPK_B=8;
const EPK_X=9;
const EPK_Y=10;
const EPK_Start=11;
const EPK_Select=12;

procedure TMain.FormCreate(Sender: TObject);
begin
  Application.Title:=Main.Caption;

  StartupTimer.Enabled:=True;
end;

var
  SourcePath,TargetFilename:string;

var
  TargetFilesLst:TStringList;
  RequestFreeSpace:integer;

var
  PassKeyCount:integer;
  PassKeyData:dword;

const PasswordMaskStr='********';

function GetPassword:dword;
var
  fini:TINIFile;
begin
  fini:=TINIFile.Create(TargetFilename);
  Result:=fini.ReadInteger('system','Password',0);
  fini.Free;
end;

procedure SetPassword(pw:dword);
var
  fini:TINIFile;
begin
  fini:=TINIFile.Create(TargetFilename);
  fini.WriteInteger('system','Password',pw);
  fini.Free;
end;

procedure TMain.EnabledPassKeys(e:boolean);
begin
  InstallLbl.Caption:=GetMLStr('Set the password of 8 chars or less.|8ȉ̃pX[hݒ肵ĂB');

  Key_Up.Enabled:=e;
  Key_Down.Enabled:=e;
  Key_Left.Enabled:=e;
  Key_Right.Enabled:=e;
  KEY_SL.Enabled:=e;
  Key_SR.Enabled:=e;
  Key_A.Enabled:=False;
  Key_B.Enabled:=e;
  Key_X.Enabled:=e;
  Key_Y.Enabled:=e;
  Key_Start.Enabled:=e;
  Key_Select.Enabled:=e;
end;

procedure TMain.StartupTimerTimer(Sender: TObject);
var
  tagdrv:string;
begin
  StartupTimer.Enabled:=False;

  TargetFilesLst:=TStringList.Create;
  TargetFilesLst.Clear;

  if GetMLTypeLoaded=False then begin
    if SelML.ShowModal<>mrOk then begin
      Application.Terminate;
      exit;
    end;
  end;

  SetMLBitBtn(OKBtn);
  SetMLBitBtn(CancelBtn);

  ReadmeMemo.Lines.LoadFromFile(ExtractFilePath(Application.ExeName)+GetMLStr('readme_eng.txt|readme_jpn.txt'));
  
  InstallLbl.Caption:=GetMLStr('Search for drives.|hCuTĂ܂B');
  InstallLbl.Visible:=True;
  PrgBar.Visible:=True;
  Main.Refresh;

  if DrvSel.CheckInstalledDrives=False then begin
    ShowMessage(GetMLStr('The MoonShell installed drive was not found.|MoonShellCXg[ꂽhCu܂łB'));
    Application.Terminate;
    exit;
  end;
  PrgBar.Visible:=False;

  DrvSel.Caption:=Main.Caption;
  if DrvSel.ShowModal<>mrOk then begin
    Application.Terminate;
    exit;
  end;

  SourcePath:=ExtractFilePath(Application.ExeName)+'moonshl2\';

  tagdrv:=DrvSel.TargetDrive+'\';
  TargetFilename:=tagdrv+'moonshl2\moonshl2.ini';

  if GetPassword<>0 then begin
    ClearBtn.Enabled:=True;
    EnabledPassKeys(False);
    PasswordEdt.Text:=PasswordMaskStr;
    InstallLbl.Caption:=GetMLStr('The password has already been set.|pX[h͊ɐݒ肳Ă܂B');
    end else begin
    ClearBtn.Enabled:=False;
    EnabledPassKeys(True);
    PasswordEdt.Text:=GetMLStr('No password|pX[hݒ');
  end;

  PassKeyCount:=0;
  PassKeyData:=0;

  OKBtn.Enabled:=False;
end;

procedure TMain.CancelBtnClick(Sender: TObject);
begin
  Application.Terminate;
end;

procedure AddPassKey(key:dword);
var
  s:string;
begin
  if PassKeyCount=0 then Main.PasswordEdt.Text:='';

  inc(PassKeyCount);
  PassKeyData:=(PassKeyData shl 4) or key;

  s:='';
  case key of
//    case EPK_None: s:='';
    EPK_Up: s:='UP';
    EPK_Down: s:='DW';
    EPK_Left: s:='LE';
    EPK_Right: s:='RI';
    EPK_SL: s:='SL';
    EPK_SR: s:='SR';
    EPK_A: s:='A';
    EPK_B: s:='B';
    EPK_X: s:='X';
    EPK_Y: s:='Y';
    EPK_Start: s:='STA';
    EPK_Select: s:='SEL';
  end;

  if s='' then ShowMessage('err key');

  Main.PasswordEdt.Text:=Main.PasswordEdt.Text+s+', ';

  Main.ClearBtn.Enabled:=True;
  if PassKeyCount=8 then Main.EnabledPassKeys(False);

  Main.OKBtn.Enabled:=True;
end;

procedure TMain.Key_UpClick(Sender: TObject);
begin
  AddPassKey(EPK_Up);
end;

procedure TMain.Key_DownClick(Sender: TObject);
begin
  AddPassKey(EPK_Down);
end;

procedure TMain.Key_LeftClick(Sender: TObject);
begin
  AddPassKey(EPK_Left);
end;

procedure TMain.Key_RightClick(Sender: TObject);
begin
  AddPassKey(EPK_Right);
end;

procedure TMain.Key_AClick(Sender: TObject);
begin
  AddPassKey(EPK_A);
end;

procedure TMain.Key_BClick(Sender: TObject);
begin
  AddPassKey(EPK_B);
end;

procedure TMain.Key_XClick(Sender: TObject);
begin
  AddPassKey(EPK_X);
end;

procedure TMain.Key_YClick(Sender: TObject);
begin
  AddPassKey(EPK_Y);
end;

procedure TMain.KEY_SLClick(Sender: TObject);
begin
  AddPassKey(EPK_SL);
end;

procedure TMain.Key_SRClick(Sender: TObject);
begin
  AddPassKey(EPK_SR);
end;

procedure TMain.Key_StartClick(Sender: TObject);
begin
  AddPassKey(EPK_Start);
end;

procedure TMain.Key_SelectClick(Sender: TObject);
begin
  AddPassKey(EPK_Select);
end;

procedure TMain.ClearBtnClick(Sender: TObject);
begin
  PassKeyCount:=0;
  PassKeyData:=0;

  Main.PasswordEdt.Text:=GetMLStr('No password|pX[hݒ');

  Main.ClearBtn.Enabled:=False;
  Main.EnabledPassKeys(True);

  Main.OKBtn.Enabled:=True;
end;

procedure TMain.OKBtnClick(Sender: TObject);
var
  msg:string;
begin
  SetPassword(PassKeyData);

  if PassKeyData=0 then begin
    msg:='The password was released.';
    msg:=msg+'|NpX[h܂B';
    end else begin
    msg:='The password was set.'+CRLF+'When A button is pushed after the password is input, MoonShell is started.';
    msg:=msg+'|NpX[hݒ肵܂B'+CRLF+'pX[h͂A{^MoonShellN܂B';
  end;
  ShowMessage(GetMLStr(msg));

  Main.Close;
end;

end.
