unit _loadimage;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, StdCtrls,Math,Jpeg,gldpng;

procedure LoadImage_GetFilesLst(var FilesLst:TStringList;path:string);
function LoadImage_LoadFromFile(var bm:TBitmap;fn:string):boolean;
procedure LoadImage_Reduce(var bmmst,bmdst:TBitmap;lx,ly:integer);
procedure LoadImage_ReduceFull(var bmmst,bmdst:TBitmap;lx,ly:integer);
procedure LoadImage_Convert8bit(var bm:TBitmap);

var
  CoverFilename:string;

implementation

uses _PicTools,NkDIB,MedianCut,Octree,MainWin;

const MatchCoverFilename='_imgview_cover.';
const MatchIgnore1Filename='_imgview_cover_bg.';
const MatchIgnore2Filename='_imgview_cover_frame.';

procedure LoadImage_GetFilesLst(var FilesLst:TStringList;path:string);
var
  res:integer;
  SearchRec: TSearchRec;
  fname,ext:string;
begin
  FilesLst.Clear;
  CoverFilename:='';

  if DirectoryExists(path)=False then exit;

  res:=FindFirst(path+'*.*', (FaAnyFile), SearchRec);
  if res=0 then begin
    repeat
      if (SearchRec.Attr and faDirectory)<>0 then begin
        fname:=SearchRec.Name;
        if FileExists(path+fname+'\folder.bmp')=True then FilesLst.Add(fname);
      end;
      if (SearchRec.Attr and faDirectory)=0 then begin
        fname:=SearchRec.Name;
        ext:=ansilowercase(extractfileext(fname));
        if (ext='.bmp') or (ext='.jpg') or (ext='.png') then begin
          if ansilowercase(copy(fname,1,length(MatchCoverFilename)))=ansilowercase(MatchCoverFilename) then begin
            CoverFilename:=fname;
            fname:='';
          end;
          if ansilowercase(copy(fname,1,length(MatchIgnore1Filename)))=ansilowercase(MatchIgnore1Filename) then fname:='';
          if ansilowercase(copy(fname,1,length(MatchIgnore2Filename)))=ansilowercase(MatchIgnore2Filename) then fname:='';
          if fname<>'' then begin
            FilesLst.Add(fname);
          end;
        end;
      end;
      res:=FindNext(SearchRec);
    until (res<>0);
  end;
  FindClose(SearchRec);

  FilesLst.Sorted:=True;
end;

function LoadFromFile_bmp(var bm:TBitmap;fn:string):boolean;
begin
  bm:=TBitmap.Create;
  try
    bm.LoadFromFile(fn);
    bm.PixelFormat:=pf24bit;
    except else begin
      Result:=False;
      exit;
    end;
  end;

  if (bm.Height=0) or (bm.Width=0) then begin
    bm.Free;
    Result:=False;
    exit;
  end;

  Result:=True;
end;

function LoadFromFile_jpg(var bm:TBitmap;fn:string):boolean;
var
  JpegImg:TJpegImage;
begin
  JpegImg:=TJpegImage.Create;

  JpegImg.PixelFormat:=jf24bit;
  JpegImg.Grayscale:=False;

  JpegImg.ProgressiveDisplay:=False;
  JpegImg.LoadFromFile(fn);

  if (JpegImg.Height=0) or (JpegImg.Width=0) then begin
    JpegImg.Free;
    Result:=False;
    exit;
  end;

  bm:=TBitmap.Create;
  MakeBlankBM(bm,JpegImg.Width,JpegImg.Height,pf24bit);

  bm.Canvas.Draw(0,0,JpegImg);

  JpegImg.Free;

  Result:=True;
end;

function LoadFromFile_png(var bm:TBitmap;fn:string):boolean;
var
  png:TGLDPNG;
  abm:TBitmap;
  x,y,w,h:integer;
  srcpb,alphapb:PByteArray;
  transcol,alpha,ialpha:dword;
  tr,tg,tb:dword;
begin
  bm:=TBitmap.Create;

  png:=TGLDPNG.Create;
  png.Image:=bm;
  png.LoadFromFile(fn);

  bm.PixelFormat:=pf24bit;

  abm:=TBitmap.Create;
  if png.AlphaBitmapAssignTo(abm)=True then begin
    abm.PixelFormat:=pf8bit;
    transcol:=png.BGColor;
    if transcol=GLD_NONECOLOR then transcol:=RGB($80,$80,$80); // wiF`̂Ƃ͊DFg
    if (transcol and $1000000)<>0 then transcol:=RGB($80,$80,$80); // wiFpbgJ[̂Ƃ͊DFg
    tr:=(transcol shr 0) and $ff;
    tg:=(transcol shr 8) and $ff;
    tb:=(transcol shr 16) and $ff;
    w:=abm.Width;
    h:=abm.Height;
    for y:=0 to h-1 do begin
      srcpb:=bm.ScanLine[y];
      alphapb:=abm.ScanLine[y];
      for x:=0 to w-1 do begin
        alpha:=alphapb[x*1+0];
        ialpha:=$ff-alpha;
        srcpb[x*3+0]:=((srcpb[x*3+0]*ialpha) div $100)+((tb*alpha) div $100);
        srcpb[x*3+1]:=((srcpb[x*3+1]*ialpha) div $100)+((tg*alpha) div $100);
        srcpb[x*3+2]:=((srcpb[x*3+2]*ialpha) div $100)+((tr*alpha) div $100);
      end;
    end;
  end;
  abm.Free;

  png.Free;

  Result:=True;
end;

function LoadImage_LoadFromFile(var bm:TBitmap;fn:string):boolean;
var
  ext:string;
begin
  ext:=ansilowercase(extractfileext(fn));

  if ext='.bmp' then begin
    Result:=LoadFromFile_bmp(bm,fn);
    exit;
  end;

  if ext='.jpg' then begin
    Result:=LoadFromFile_jpg(bm,fn);
    exit;
  end;

  if ext='.png' then begin
    Result:=LoadFromFile_png(bm,fn);
    exit;
  end;

  Result:=False;
end;

procedure LoadImage_Reduce(var bmmst,bmdst:TBitmap;lx,ly:integer);
var
  aspect:double;
  cx,cy:integer;
begin
  aspect:=bmmst.Height/bmmst.Width;
  cx:=trunc(ly/aspect);
  cy:=ly;
  if cx>lx then begin
    cx:=lx;
    cy:=trunc(lx*aspect);
  end;
  if cx=0 then cx:=1;
  if cy=0 then cy:=1;

  bmdst:=TBitmap.Create;
  MakeBlankBM(bmdst,cx,cy,pf24bit);

  SetStretchBltMode(bmdst.Canvas.Handle,MAXSTRETCHBLTMODE);
  StretchBlt(bmdst.Canvas.Handle,0,0,cx,cy,bmmst.Canvas.Handle,0,0,bmmst.Width,bmmst.Height,SRCCOPY);
end;

procedure LoadImage_ReduceFull(var bmmst,bmdst:TBitmap;lx,ly:integer);
var
  aspect:double;
  cx,cy:integer;
begin
  aspect:=bmmst.Height/bmmst.Width;
  if aspect<(ly/lx) then begin
    cx:=trunc(ly/aspect);
    cy:=ly;
    end else begin
    cx:=lx;
    cy:=trunc(lx*aspect);
  end;
  if cx=0 then cx:=1;
  if cy=0 then cy:=1;

  bmdst:=TBitmap.Create;
  MakeBlankBM(bmdst,cx,cy,pf24bit);

  SetStretchBltMode(bmdst.Canvas.Handle,MAXSTRETCHBLTMODE);
  StretchBlt(bmdst.Canvas.Handle,0,0,cx,cy,bmmst.Canvas.Handle,0,0,bmmst.Width,bmmst.Height,SRCCOPY);
end;

procedure LoadImage_Convert8bit(var bm:TBitmap);
var
  pb:PByteArray;
  tmpbm:TBitmap;
begin
  tmpbm:=ReduceColorsByMedianCutV(bm,8);
  bm.Free;
  bm:=tmpbm;
end;

end.
