unit _inifile;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ComCtrls, StdCtrls, ExtCtrls, Buttons, INIFiles, _m_Tools;

procedure LoadINI;
procedure SaveINI;

implementation

uses MainWin,OptionWin;

const CRLF:string=char($0d)+char($0a);

function GetINIFilename:string;
begin
  Result:=ChangeFileExt(Application.ExeName,'.ini');
end;

procedure LoadINI;
var
  fini:TINIFile;
  Section:string;
begin
  fini:=TINIFile.Create(GetINIFilename);

  Section:='ConvertSettings';

  Main.GlassLevBar.Position:=fini.ReadInteger(Section,'GlassLev',Main.GlassLevBar.Position);
  Main.PastelLevBar.Position:=fini.ReadInteger(Section,'PastelLev',Main.PastelLevBar.Position);
  Main.PastelColor:=fini.ReadInteger(Section,'PastelColor',Main.PastelColor);

  Option.AutoChangeChk.Checked:=fini.ReadBool(Section,'AutoChangeChk',Option.AutoChangeChk.Checked);
  Option.AutoChangeTimeSecLst.ItemIndex:=fini.ReadInteger(Section,'AutoChangeTimeSecLst',Option.AutoChangeTimeSecLst.ItemIndex);

  Option.Dither15bitChk.Checked:=fini.ReadBool(Section,'Dither15bitChk',Option.Dither15bitChk.Checked);
  Option.NotUseFilterWithDesktopChk.Checked:=fini.ReadBool(Section,'NotUseFilterWithDesktopChk',Option.NotUseFilterWithDesktopChk.Checked);
  Option.NotDrawHelpTextChk.Checked:=fini.ReadBool(Section,'NotDrawHelpTextChk',Option.NotDrawHelpTextChk.Checked);
  Option.SpaceClippingChk.Checked:=fini.ReadBool(Section,'SpaceClippingChk',Option.SpaceClippingChk.Checked);

  Option.SSApplyChk.Checked:=fini.ReadBool(Section,'SSApplyChk',Option.SSApplyChk.Checked);
  Option.SSUseFilterChk.Checked:=fini.ReadBool(Section,'SSUseFilterChk',Option.SSUseFilterChk.Checked);
  Option.SSNotDrawDaysChk.Checked:=fini.ReadBool(Section,'SSNotDrawDaysChk',Option.SSNotDrawDaysChk.Checked);

  Option.TopBottomSameImageChk.Checked:=fini.ReadBool(Section,'TopBottomSameImageChk',Option.TopBottomSameImageChk.Checked);

  fini.Free;

  Option.ApplyEnabled;
end;

procedure SaveINI;
var
  fini:TINIFile;
  Section:string;
begin
  fini:=TINIFile.Create(GetINIFilename);

  Section:='ConvertSettings';

  fini.WriteInteger(Section,'GlassLev',Main.GlassLevBar.Position);
  fini.WriteInteger(Section,'PastelLev',Main.PastelLevBar.Position);
  fini.WriteInteger(Section,'PastelColor',Main.PastelColor);

  fini.WriteBool(Section,'AutoChangeChk',Option.AutoChangeChk.Checked);
  fini.WriteInteger(Section,'AutoChangeTimeSecLst',Option.AutoChangeTimeSecLst.ItemIndex);

  fini.WriteBool(Section,'Dither15bitChk',Option.Dither15bitChk.Checked);
  fini.WriteBool(Section,'NotUseFilterWithDesktopChk',Option.NotUseFilterWithDesktopChk.Checked);
  fini.WriteBool(Section,'NotDrawHelpTextChk',Option.NotDrawHelpTextChk.Checked);
  fini.WriteBool(Section,'SpaceClippingChk',Option.SpaceClippingChk.Checked);

  fini.WriteBool(Section,'SSApplyChk',Option.SSApplyChk.Checked);
  fini.WriteBool(Section,'SSUseFilterChk',Option.SSUseFilterChk.Checked);
  fini.WriteBool(Section,'SSNotDrawDaysChk',Option.SSNotDrawDaysChk.Checked);

  fini.WriteBool(Section,'TopBottomSameImageChk',Option.TopBottomSameImageChk.Checked);

  fini.Free;
end;

end.
