unit encprvWin;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls,_PicTools, StdCtrls, Buttons;

type
  Tencprv = class(TForm)
    PrvImg: TImage;
    GetThumbBtn: TBitBtn;
    ThumbImg: TImage;
    procedure FormCreate(Sender: TObject);
    procedure GetThumbBtnClick(Sender: TObject);
  private
    { Private 錾 }
  public
    { Public 錾 }
    procedure ClearThumbImage;
    procedure SetPrvImage(bm:TBitmap;w,h:integer);
    procedure SetThumbImage(bm:TBitmap;w,h:integer);
    function GetThumbImage(var bm:TBitmap):boolean;
    procedure LoadThumbImage(fn:string);
  end;

var
  encprv: Tencprv;

var
  isExistsThumbImage:boolean;

implementation

{$R *.dfm}

uses _loadimage;

procedure Tencprv.FormCreate(Sender: TObject);
begin
  MakeBlankImg(PrvImg,pf24bit);
  ClearThumbImage;
end;

procedure Tencprv.ClearThumbImage;
begin
  isExistsThumbImage:=False;
  GetThumbBtn.Enabled:=False;
  MakeBlankImg(ThumbImg,pf24bit);
end;

procedure Tencprv.SetPrvImage(bm:TBitmap;w,h:integer);
begin
  with PrvImg.Canvas do begin
    Brush.Color:=$000000;
    FillRect(Rect(0,0,256,192));
  end;
  BitBlt(PrvImg.Canvas.Handle,0,(192-h) div 2,w,h,bm.Canvas.Handle,0,0,SRCCOPY);
  PrvImg.Refresh;
end;

procedure Tencprv.SetThumbImage(bm:TBitmap;w,h:integer);
begin
  isExistsThumbImage:=True;
  with ThumbImg.Canvas do begin
    Brush.Color:=$000000;
    FillRect(Rect(0,0,256,192));
  end;
  BitBlt(ThumbImg.Canvas.Handle,0,(192-h) div 2,w,h,bm.Canvas.Handle,0,0,SRCCOPY);
  ThumbImg.Refresh;
end;

procedure Tencprv.GetThumbBtnClick(Sender: TObject);
begin
  isExistsThumbImage:=True;
  BitBlt(ThumbImg.Canvas.Handle,0,0,256,192,PrvImg.Canvas.Handle,0,0,SRCCOPY);
  ThumbImg.Refresh;
end;

function Tencprv.GetThumbImage(var bm:TBitmap):boolean;
begin
  if isExistsThumbImage=False then begin
    Result:=False;
    exit;
  end;

  MakeBlankBM(bm,256,192,pf24bit);
  BitBlt(bm.Canvas.Handle,0,0,256,192,ThumbImg.Canvas.Handle,0,0,SRCCOPY);

  Result:=True;
end;

procedure Tencprv.LoadThumbImage(fn:string);
var
  bmsrc,bmdst:TBitmap;
begin
  if fn='' then exit;
  if FileExists(fn)=False then exit;

  bmsrc:=TBitmap.Create;
  if LoadImage_LoadFromFile(bmsrc,fn)=False then exit;

  bmdst:=TBitmap.Create;
  LoadImage_Reduce(bmsrc,bmdst,256,192);

  isExistsThumbImage:=True;
  with ThumbImg.Canvas do begin
    Brush.Color:=$000000;
    FillRect(Rect(0,0,256,192));
  end;
  BitBlt(ThumbImg.Canvas.Handle,(256-bmdst.Width) div 2,(192-bmdst.Height) div 2,bmdst.Width,bmdst.Height,bmdst.Canvas.Handle,0,0,SRCCOPY);
  ThumbImg.Refresh;

  bmsrc.Free;
  bmdst.Free;
end;

end.
