unit _ipk;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls;

type
  TImgDataBody=record
    bm:TBitmap;
    ratio:double;
    decmpsize:integer;
    cmpsize:integer;
    cmpdata:pbytearray;
  end;

const MCUSize=64;

type
  TImgDataMCU=record
    decmpsize:integer;
    cmpsize:integer;
    cmpdata:pbytearray;
  end;

type EIPKBodyFormat=(EIPKBF_Beta15bit=0,EIPKBF_CustomJpegYUV111=1,EIPKBF_CustomJpegYUV411=2);

type
  TImgData=record
    Filename:string;
    bmmst:TBitmap;
    body4864,body6448,body192256,body256192:TImgDataBody;
    MCUXCount,MCUYCount:integer;
    BodyFormat:EIPKBodyFormat;
    MCUs:array of TImgDataMCU;
  end;

procedure Conv24to8bitDither(srcbm:TBitmap);
procedure Conv24to24bitDither(var srcbm:TBitmap);
procedure Conv24to15bitDither(srcbm:TBitmap);
procedure Conv24to15bitPass(srcbm:TBitmap);

procedure AutoProcessing(var ImgData:TImgData;UseDither:boolean;Use15bit4864,Use15bit192256:boolean);

procedure MakeCover(var body:TImgDataBody);

var
  B8Data:array of byte;
  B8DataCount:integer;

var
  B15Data:array of word;
  B15DataCount:integer;

implementation

uses NkDIB,_PicTools,_inifile,_loadimage,_zlibhelper,_customjpeg;

// --- 8bit stuff

procedure Conv24to8bitDither(srcbm:TBitmap);
var
  dib:TNkDIB;
  x,y,w,h:integer;
  psbm,pdbm:PByteArray;
  r,g,b:integer;
  dr,dg,db:integer;
  ofs:integer;
  palcnt:integer;
  ppal:pwordarray;
  palidx:integer;
  function d2(c:integer;var dc:integer):integer;
  var
    a:integer;
  begin
    a:=c+dc;
    dc:=a and 7;
    Result:=a shr 3;
    if 31<Result then Result:=31;
  end;
  function RGB15to15(rgb:dword):word;
  var
    r,g,b:integer;
  begin
    r:=((rgb shr 0) and $ff) shr 0;
    g:=((rgb shr 8) and $ff) shr 0;
    b:=((rgb shr 16) and $ff) shr 0;
    if r>31 then r:=31;
    if g>31 then g:=31;
    if b>31 then b:=31;

    Result:=(b shl 10)+(g shl 5)+(r shl 0)+(1 shl 15);
  end;
begin
  w:=srcbm.Width;
  h:=srcbm.Height;

  dib:=TNkDIB.Create;

  dib.PixelFormat:=NkPf24bit;
  dib.Width:=srcbm.Width;
  dib.Height:=srcbm.Height;

  dr:=0;
  dg:=0;
  db:=0;

  for y:=0 to h-1 do begin
    psbm:=srcbm.ScanLine[y];
    pdbm:=dib.ScanLine[y];
    for x:=0 to w-1 do begin
      b:=psbm[x*3+0];
      g:=psbm[x*3+1];
      r:=psbm[x*3+2];
      pdbm[x*3+0]:=d2(b,db);
      pdbm[x*3+1]:=d2(g,dg);
      pdbm[x*3+2]:=d2(r,dr);
    end;
  end;

  dib.ConvertMode:=nkCmFine;
  dib.PixelFormat:=NkPf8bit;

  palcnt:=dib.PaletteSize;

  ofs:=2+(palcnt*2);
  B8DataCount:=ofs+(w*h);
  setlength(B8Data,B8DataCount);

  ppal:=pwordarray(B8Data);
  ppal[0]:=word(palcnt);
  for palidx:=0 to palcnt-1 do begin
    ppal[1+palidx]:=RGB15to15(dib.Colors[palidx]);
  end;

  for y:=0 to h-1 do begin
    psbm:=dib.ScanLine[y];
    for x:=0 to w-1 do begin
      B8Data[ofs+x+(y*w)]:=psbm[x];
    end;
  end;

  dib.Free;
end;

// end of 8bit stuff

// --- 15bit stuff

procedure Conv24to15bitPass(srcbm:TBitmap);
var
  x,y,w,h:integer;
  psbm:PByteArray;
  r,g,b:integer;
  function RGB15(r,g,b:integer):word;
  begin
    r:=r shr 3;
    g:=g shr 3;
    b:=b shr 3;
    Result:=(b shl 10)+(g shl 5)+(r shl 0)+(1 shl 15);
  end;
begin
  w:=srcbm.Width;
  h:=srcbm.Height;

  B15DataCount:=w*h;
  setlength(B15Data,B15DataCount);

  for y:=0 to h-1 do begin
    psbm:=srcbm.ScanLine[y];
    for x:=0 to w-1 do begin
      b:=psbm[x*3+0];
      g:=psbm[x*3+1];
      r:=psbm[x*3+2];
      B15Data[x+(y*w)]:=RGB15(r,g,b);
    end;
  end;
end;

procedure Conv24to15bitDither(srcbm:TBitmap);
var
  x,y,w,h:integer;
  psbm:PByteArray;
  r,g,b:integer;
  dr,dg,db:integer;
  function d2(c:integer;var dc:integer):integer;
  var
    a:integer;
  begin
    a:=c+dc;
    dc:=a and 7;
    Result:=a shr 3;
    if 31<Result then Result:=31;
  end;
  function RGB15(r,g,b:integer):word;
  begin
    Result:=(b shl 10)+(g shl 5)+(r shl 0)+(1 shl 15);
  end;
begin
  w:=srcbm.Width;
  h:=srcbm.Height;

  dr:=0;
  dg:=0;
  db:=0;

  B15DataCount:=w*h;
  setlength(B15Data,B15DataCount);

  for y:=0 to h-1 do begin
    psbm:=srcbm.ScanLine[y];
    for x:=0 to w-1 do begin
      b:=psbm[x*3+0];
      g:=psbm[x*3+1];
      r:=psbm[x*3+2];
      B15Data[x+(y*w)]:=RGB15(d2(r,dr),d2(g,dg),d2(b,db));
    end;
  end;
end;

procedure Conv24to24bitDither(var srcbm:TBitmap);
var
  x,y,w,h:integer;
  psbm:PByteArray;
  dr,dg,db:integer;
  function d2(c:integer;var dc:integer):integer;
  var
    a:integer;
  begin
    a:=c+dc;
    dc:=a and 7;
    Result:=a;
    if 255<Result then Result:=255;
  end;
begin
  w:=srcbm.Width;
  h:=srcbm.Height;

  dr:=0;
  dg:=0;
  db:=0;

  for y:=0 to h-1 do begin
    psbm:=srcbm.ScanLine[y];
    for x:=0 to w-1 do begin
      psbm[x*3+0]:=d2(psbm[x*3+0],db);
      psbm[x*3+1]:=d2(psbm[x*3+1],dg);
      psbm[x*3+2]:=d2(psbm[x*3+2],dr);
    end;
  end;
end;

// --- end of 15bit stuff

// ----------------------------------------------------

procedure ProcReduce(var ImgData:TImgData);
var
  tmpbm:TBitmap;
begin
  if (INI_MaxSize_Width<>0) and (INI_MaxSize_Height<>0) then begin
    if (INI_MaxSize_Width<ImgData.bmmst.Width) or (INI_MaxSize_Height<ImgData.bmmst.Height) then begin
      LoadImage_Reduce(ImgData.bmmst,tmpbm,INI_MaxSize_Width,INI_MaxSize_Height);
      ImgData.bmmst.Free;
      ImgData.bmmst:=TBitmap.Create;
      MakeBlankBM(ImgData.bmmst,tmpbm.Width,tmpbm.Height,pf24bit);
      BitBlt(ImgData.bmmst.Canvas.Handle,0,0,tmpbm.Width,tmpbm.Height,tmpbm.Canvas.Handle,0,0,SRCCOPY);
      tmpbm.Free;
    end;
  end;
end;

procedure ProcThumb(var ImgData:TImgData);
  procedure MakeBody(var bmmst:TBitmap;w,h:integer;var body:TImgDataBody);
  begin
    LoadImage_Reduce(bmmst,body.bm,w,h);
    body.ratio:=body.bm.Width/bmmst.Width;
  end;
begin
  with ImgData do begin
    MakeBody(bmmst,48,64,body4864);
    MakeBody(bmmst,64,48,body6448);
    MakeBody(bmmst,192,256,body192256);
    MakeBody(bmmst,256,192,body256192);
  end;
end;

procedure ProcBody(var ImgData:TImgData;UseDither:boolean);
begin
  case ImgData.BodyFormat of
    EIPKBF_Beta15bit: begin
      if UseDither=True then Conv24to24bitDither(ImgData.bmmst);
    end;
    EIPKBF_CustomJpegYUV111: begin
    end;
    EIPKBF_CustomJpegYUV411: begin
    end;
  end;
end;

procedure MakeThumb(var ImgData:TImgData;Use15bit4864,Use15bit192256:boolean);
  procedure MakeBody8(var body:TImgDataBody);
  begin
    Conv24to8bitDither(body.bm);
    body.decmpsize:=B8DataCount*1;
    zlibCompress(B8Data,body.decmpsize,body.cmpdata,body.cmpsize);
  end;
  procedure MakeBody15(var body:TImgDataBody);
  begin
    Conv24to15bitDither(body.bm);
    body.decmpsize:=B15DataCount*2;
    zlibCompress(B15Data,body.decmpsize,body.cmpdata,body.cmpsize);
  end;
begin
  with ImgData do begin
    if Use15bit4864=True then begin
      MakeBody15(body4864);
      MakeBody15(body6448);
      end else begin
      MakeBody8(body4864);
      MakeBody8(body6448);
    end;
    if Use15bit192256=True then begin
      MakeBody15(body192256);
      MakeBody15(body256192);
      end else begin
      MakeBody8(body192256);
      MakeBody8(body256192);
    end;
  end;
end;

procedure MakeBody(var ImgData:TImgData);
var
  wfs:TFileStream;
  w,h:integer;
  xcnt,ycnt:integer;
  x,y:integer;
  bm:TBitmap;
begin
//  MakeMCU(ImgData);

  w:=ImgData.bmmst.Width;
  h:=ImgData.bmmst.Height;
  xcnt:=(w+(MCUSize-1)) div MCUSize;
  ycnt:=(h+(MCUSize-1)) div MCUSize;
  ImgData.MCUXCount:=xcnt;
  ImgData.MCUYCount:=ycnt;

  setlength(ImgData.MCUs,xcnt*ycnt);

  bm:=TBitmap.Create;
  MakeBlankBM(bm,MCUSize,MCUSize,pf24bit);
  bm.Canvas.Brush.Color:=$1f1f1f;

  with ImgData do begin
    for y:=0 to ycnt-1 do begin
      for x:=0 to xcnt-1 do begin
        with ImgData.MCUs[x+(y*xcnt)] do begin
          bm.Canvas.FillRect(Rect(0,0,MCUSize,MCUSize));
          BitBlt(bm.Canvas.Handle,0,0,MCUSize,MCUSize,ImgData.bmmst.Canvas.Handle,x*MCUSize,y*MCUSize,SRCCOPY);
          case BodyFormat of
            EIPKBF_Beta15bit: begin
              Conv24to15bitPass(bm);
              decmpsize:=B15DataCount*2;
              zlibCompress(B15Data,decmpsize,cmpdata,cmpsize);
            end;
            EIPKBF_CustomJpegYUV111: begin
              customjpeg_CompressYUV111(bm,False);
              decmpsize:=CustomJpegDataCount*1;
              zlibCompress(CustomJpegData,decmpsize,cmpdata,cmpsize);
            end;
            EIPKBF_CustomJpegYUV411: begin
              customjpeg_CompressYUV411(bm,False);
              decmpsize:=CustomJpegDataCount*1;
  {
              customjpeg_WriteToFile('testquant.bin');
              if FileExists('testmcu.bin')=False then begin
                wfs:=TFileStream.Create('testmcu.bin',fmCreate);
                end else begin
                wfs:=TFileStream.Create('testmcu.bin',fmOpenWrite);
              end;
              wfs.Position:=wfs.Size;
              wfs.WriteBuffer(CustomJpegData[0],decmpsize);
              wfs.Free;
  }
              zlibCompress(CustomJpegData,decmpsize,cmpdata,cmpsize);
            end;
          end;
        end;
      end;
    end;
  end;
end;

procedure AutoProcessing(var ImgData:TImgData;UseDither:boolean;Use15bit4864,Use15bit192256:boolean);
begin
  ProcReduce(ImgData);
  ProcThumb(ImgData);
  ProcBody(ImgData,UseDither);

  MakeThumb(ImgData,Use15bit4864,Use15bit192256);
  MakeBody(ImgData);
end;

procedure MakeCover(var body:TImgDataBody);
var
  w,h,ofsx,ofsy:integer;
  tmpbm:TBitmap;
  procedure MakeBody15(var body:TImgDataBody;var bm:TBitmap);
  begin
    Conv24to15bitDither(bm);
    body.decmpsize:=B15DataCount*2;
    zlibCompress(B15Data,body.decmpsize,body.cmpdata,body.cmpsize);
  end;
begin
  if body.bm.Width<body.bm.Height then begin
    w:=192;
    h:=256;
    end else begin
    w:=256;
    h:=192;
  end;

  LoadImage_Reduce(body.bm,tmpbm,w,h);
  body.bm.Free;

  body.bm:=TBitmap.Create;
  MakeBlankBM(body.bm,w,h,pf24bit);
  body.bm.Canvas.Brush.Color:=$ffffff;
  body.bm.Canvas.FillRect(Rect(0,0,w,h));

  ofsx:=(w-tmpbm.Width) div 2;
  ofsy:=(h-tmpbm.Height) div 2;
  MakeBlankBM(body.bm,w,h,pf24bit);
  BitBlt(body.bm.Canvas.Handle,ofsx,ofsy,tmpbm.Width,tmpbm.Height,tmpbm.Canvas.Handle,0,0,SRCCOPY);
  tmpbm.Free;

  MakeBody15(body,body.bm);
end;


end.
