/*
** nester - NES emulator
** Copyright (C) 2000  Darren Ranalli
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful, 
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU 
** Library General Public License for more details.  To obtain a 
** copy of the GNU Library General Public License, write to the Free 
** Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
**
** Any permitted reproduction of these routines, in whole or in part,
** must bear this legend.
*/

#ifndef _NES_SCREEN_MGR_H_
#define _NES_SCREEN_MGR_H_

#include "../screen_mgr.h"
#include "nes.h"
#include "../settings.h"
#include "../debug/debug.h"

#define SCRMGRINLINE __inline

  boolean SCRMGR_set_NES_palette();
  void SCRMGR_assert_palette();

  static SCRMGRINLINE uint32 SCRMGR_get_width()  { return NES_BACKBUF_WIDTH;  }
  static SCRMGRINLINE uint32 SCRMGR_get_height() { return NES_SCREEN_HEIGHT; }

  static SCRMGRINLINE uint32 SCRMGR_get_viewable_width()   { return NES_SCREEN_WIDTH_VIEWABLE;  }
  static SCRMGRINLINE uint32 SCRMGR_get_viewable_height()  { return getViewableHeight(); }

  static SCRMGRINLINE uint32 SCRMGR_get_viewable_area_x_offset() { return SIDE_MARGIN; }
  static SCRMGRINLINE uint32 SCRMGR_get_viewable_area_y_offset() { return getTopMargin(); }


#endif
