unit ImgOptWin;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, ComCtrls, Buttons, jpeg, ExtDlgs;

type
  TImgOpt = class(TForm)
    SrcImg: TImage;
    TransImg: TImage;
    CompInfoLbl: TLabel;
    customjpeg_QualityBar: TTrackBar;
    customjpeg_QualityLbl: TLabel;
    customjpeg_QualityLowLbl: TLabel;
    customjpeg_QualityHighLbl: TLabel;
    zlib_Dither15bitChk: TCheckBox;
    FormatLst: TComboBox;
    FormatLbl: TLabel;
    BitBtn1: TBitBtn;
    PrevImg: TImage;
    LoadPrevImgBtn: TButton;
    OpenImgDlg: TOpenPictureDialog;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure customjpeg_QualityBarChange(Sender: TObject);
    procedure FormatLstChange(Sender: TObject);
    procedure zlib_Dither15bitChkClick(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
    procedure FormKeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure LoadPrevImgBtnClick(Sender: TObject);
  private
    { Private 錾 }
  public
    { Public 錾 }
    procedure ApplyLang;
    procedure Init(imgfn:string);
  end;

var
  ImgOpt: TImgOpt;

procedure CompressTest;

implementation

{$R *.dfm}

uses _SplitML,_ipk,_loadimage, MainWin,_PicTools,_zlibhelper,_customjpeg;

var
  srcbm:TBitmap;
  ApplyFlag:boolean=False;

procedure TImgOpt.ApplyLang;
begin
  ImgOpt.Caption:=GetMLStr(ImgOpt.Caption);

  SetMLLbl(FormatLbl);
  SetMLComboBox(FormatLst);
  SetMLChk(zlib_Dither15bitChk);
  SetMLLbl(customjpeg_QualityLowLbl);
  SetMLLbl(customjpeg_QualityHighLbl);
  SetMLBtn(LoadPrevImgBtn);
end;

procedure TImgOpt.Init(imgfn:string);
var
  size:integer;
  w,h:integer;
begin
  srcbm:=TBitmap.Create;

  if imgfn<>'' then begin
    LoadImage_LoadFromFile(srcbm,imgfn,False);
    end else begin
    MakeBlankBM(srcbm,PrevImg.Picture.Graphic.Width,PrevImg.Picture.Graphic.Height,pf24bit);
    srcbm.Canvas.Draw(0,0,PrevImg.Picture.Graphic);
  end;

  size:=256;
  if size<srcbm.Height then srcbm.Height:=size;
  if size<srcbm.Width then srcbm.Width:=size;

  w:=srcbm.Width;
  h:=srcbm.Height;

  SrcImg.Width:=w;
  SrcImg.Height:=h;
  MakeBlankImg(SrcImg,pf24bit);

  TransImg.Width:=w;
  TransImg.Height:=h;
  MakeBlankImg(TransImg,pf24bit);

  BitBlt(SrcImg.Canvas.Handle,0,0,w,h,SrcBM.Canvas.Handle,0,0,SRCCOPY);

  FormatLstChange(nil);
  customjpeg_QualityBarChange(nil);

  ApplyFlag:=True;
  CompressTest;
end;

procedure FreeImgData(var ImgData:TImgData);
var
  idx:integer;
begin
  with ImgData do begin
    if Assigned(bmmst)=True then bmmst.Free;

    for idx:=0 to (MCUXCount*MCUYCount)-1 do begin
      with imgdata.MCUs[idx] do begin
        FreeMem(cmpdata);
        cmpdata:=nil;
      end;
    end;
  end;
end;

procedure CompressTest;
var
  ImgData:TImgData;
  w,h:integer;
  idx:integer;
  x,y:integer;
  msg:string;
  PrevDataSize:integer;
  srcbyte,dstbyte:integer;
  xcnt,ycnt:integer;
  bm:TBitmap;
  procedure mask15bit(var bm:TBitmap);
  var
    x,y:integer;
  begin
    for y:=0 to MCUSIZE-1 do begin
      for x:=0 to MCUSIZE-1 do begin
        bm.Canvas.Pixels[x,y]:=bm.Canvas.Pixels[x,y] and not $070707;
      end;
    end;
  end;
begin
  if ApplyFlag=False then exit;

  w:=srcbm.Width;
  h:=srcbm.Height;

  ImgData.bmmst:=TBitmap.Create;
  MakeBlankBM(ImgData.bmmst,w,h,pf24bit);
  BitBlt(ImgData.bmmst.Canvas.Handle,0,0,w,h,SrcBM.Canvas.Handle,0,0,SRCCOPY);

  case ImgOpt.FormatLst.ItemIndex of
    0: ImgData.BodyFormat:=EIPKBF_Beta15bit;
    1: ImgData.BodyFormat:=EIPKBF_CustomJpegYUV411;
  end;

  customjpeg_SetQuality(ImgOpt.customjpeg_QualityBar.Position);

  case ImgData.BodyFormat of
    EIPKBF_Beta15bit: begin
      if ImgOpt.zlib_Dither15bitChk.Checked=True then Conv24to24bitDither(ImgData.bmmst);
    end;
    EIPKBF_CustomJpegYUV111: begin
    end;
    EIPKBF_CustomJpegYUV411: begin
    end;
  end;

  PrevDataSize:=0;

//  MakeMCU(ImgData);

  w:=ImgData.bmmst.Width;
  h:=ImgData.bmmst.Height;
  xcnt:=(w+(MCUSize-1)) div MCUSize;
  ycnt:=(h+(MCUSize-1)) div MCUSize;
  ImgData.MCUXCount:=xcnt;
  ImgData.MCUYCount:=ycnt;

  setlength(ImgData.MCUs,xcnt*ycnt);

  bm:=TBitmap.Create;
  MakeBlankBM(bm,MCUSize,MCUSize,pf24bit);
  bm.Canvas.Brush.Color:=$1f1f1f;

  with ImgData do begin
    for y:=0 to ycnt-1 do begin
      for x:=0 to xcnt-1 do begin
        bm.Canvas.FillRect(Rect(0,0,MCUSize,MCUSize));
        BitBlt(bm.Canvas.Handle,0,0,MCUSize,MCUSize,ImgData.bmmst.Canvas.Handle,x*MCUSize,y*MCUSize,SRCCOPY);
        with ImgData.MCUs[x+(y*xcnt)] do begin
          case BodyFormat of
            EIPKBF_Beta15bit: begin
              Conv24to15bitPass(bm);
              mask15bit(bm);
              decmpsize:=B15DataCount*2;
              zlibCompress(B15Data,decmpsize,cmpdata,cmpsize);
              inc(PrevDataSize,cmpsize);
            end;
            EIPKBF_CustomJpegYUV111: begin
              customjpeg_CompressYUV111(bm,True);
              decmpsize:=CustomJpegDataCount*1;
              zlibCompress(CustomJpegData,decmpsize,cmpdata,cmpsize);
              inc(PrevDataSize,cmpsize);
            end;
            EIPKBF_CustomJpegYUV411: begin
              customjpeg_CompressYUV411(bm,True);
              decmpsize:=CustomJpegDataCount*1;
              zlibCompress(CustomJpegData,decmpsize,cmpdata,cmpsize);
              inc(PrevDataSize,cmpsize);
            end;
          end;
        end;
        BitBlt(ImgOpt.TransImg.Canvas.Handle,x*64,y*64,64,64,bm.Canvas.Handle,0,0,SRCCOPY);
      end;
    end;
  end;

  with ImgData do begin
    for y:=0 to MCUYCount-1 do begin
      for x:=0 to MCUXCount-1 do begin
      end;
    end;
    ImgOpt.TransImg.Refresh;
  end;

  if (w*h)=0 then begin
    msg:='size error';
    end else begin
    srcbyte:=w*h*3;
    dstbyte:=PrevDataSize;
    msg:='Source size %dbyte(%dKByte), Compressed size %dbyte(%dKByte) (%d%%)|TCY %dbyte(%dKByte) / kTCY %dbyte(%dKByte) (%d%%)';
    msg:=format(GetMLStr(msg),[srcbyte,srcbyte div 1024,dstbyte,dstbyte div 1024,trunc((dstbyte/srcbyte)*100)]);
  end;
  ImgOpt.CompInfoLbl.Caption:=msg;
  ImgOpt.CompInfoLbl.Refresh;

  FreeImgData(ImgData);
end;

procedure TImgOpt.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  ModalResult:=0;
  srcbm.Free;
end;

procedure TImgOpt.customjpeg_QualityBarChange(Sender: TObject);
var
  msg:string;
begin
  msg:='Quality %d%%|掿 %d%%';
  customjpeg_QualityLbl.Caption:=format(GetMLStr(msg),[customjpeg_QualityBar.Position])+'  ';
  customjpeg_QualityLbl.Refresh;
  CompressTest;
end;

procedure TImgOpt.FormatLstChange(Sender: TObject);
begin
  case ImgOpt.FormatLst.ItemIndex of
    0: begin
      zlib_Dither15bitChk.Enabled:=True;
      customjpeg_QualityLbl.Enabled:=False;
      customjpeg_QualityLowLbl.Enabled:=False;
      customjpeg_QualityHighLbl.Enabled:=False;
      customjpeg_QualityBar.Enabled:=False;
    end;
    1: begin
      zlib_Dither15bitChk.Enabled:=False;
      customjpeg_QualityLbl.Enabled:=True;
      customjpeg_QualityLowLbl.Enabled:=True;
      customjpeg_QualityHighLbl.Enabled:=True;
      customjpeg_QualityBar.Enabled:=True;
    end;
  end;

  CompressTest;
end;

procedure TImgOpt.zlib_Dither15bitChkClick(Sender: TObject);
begin
  CompressTest;
end;

procedure TImgOpt.BitBtn1Click(Sender: TObject);
begin
  ApplyFlag:=False;
  Close;
end;

procedure TImgOpt.FormKeyUp(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if Key=VK_ESCAPE then begin
    Key:=0;
    ImgOpt.Close;
  end;
end;

procedure TImgOpt.LoadPrevImgBtnClick(Sender: TObject);
var
  bm:TBitmap;
begin
  if OpenImgDlg.Execute=False then exit;

  MakeBlankImg(SrcImg,pf24bit);
  MakeBlankImg(TransImg,pf24bit);

  bm:=TBitmap.Create;
  if LoadImage_LoadFromFile(bm,OpenImgDlg.FileName,False)=False then exit;

  BitBlt(SrcImg.Canvas.Handle,0,0,bm.Width,bm.Height,bm.Canvas.Handle,0,0,SRCCOPY);
  SrcImg.Refresh;

  MakeBlankBM(srcbm,bm.Width,bm.Height,pf24bit);
  BitBlt(srcbm.Canvas.Handle,0,0,bm.Width,bm.Height,bm.Canvas.Handle,0,0,SRCCOPY);

  bm.Free;

  CompressTest;
end;

end.
