unit SetPassword_DrvSelWin;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Buttons,_m_Tools;

type
  TDrvSel = class(TForm)
    OKBtn: TBitBtn;
    CancelBtn: TBitBtn;
    DriveLst: TComboBox;
    Label1: TLabel;
    procedure OKBtnClick(Sender: TObject);
  private
    { Private 錾 }
  public
    { Public 錾 }
    TargetDrive:string;
    function CheckInstalledDrives:boolean;
  end;

var
  DrvSel: TDrvSel;

implementation

{$R *.dfm}

uses _SplitML, SetPassword_MainWin;

const VersionFilename='moonshl2\version.dat';

const CurrentVersionStr:string='Ver2.06';

function isCanSetDrive(drv:string):boolean;
var
  rfs:TFileStream;
  ver:dword;
begin
  if FileExists(drv+VersionFilename)=False then begin
    ver:=0;
    end else begin
    rfs:=TFileStream.Create(drv+VersionFilename,fmOpenRead);
    if rfs.Size<4 then begin
      ver:=0;
      end else begin
      rfs.ReadBuffer(ver,4);
    end;
    rfs.Free;
  end;

  Result:=False;
  if $02000008<=ver then Result:=True;
end;

function TDrvSel.CheckInstalledDrives:boolean;
var
  idx:integer;
  fn:string;
  str:string;
  tagidx:integer;
begin
  Label1.Caption:=GetMLStr('Please select the disk for setup password.|pX[hݒ肷fBXNIĂB');
  SetMLBitBtn(OKBtn);
  SetMLBitBtn(CancelBtn);

  if False then begin
    DrvSel.DriveLst.Items.Add('D:\ [direct]');
    DrvSel.DriveLst.ItemIndex:=0;
    OKBtnClick(nil);
    Result:=True;
    exit;
  end;

  Result:=False;

  DrvSel.DriveLst.Clear;

  tagidx:=-1;

  Main.PrgBar.Position:=0;
  Main.PrgBar.Max:=26;
  for idx:=2 to 26-1 do begin
    Main.PrgBar.Position:=idx;
    Main.Refresh;
    fn:=char($41+idx)+':\';
    if (isCanSetupDrive(fn)=True) and (GetDriveInfomation(fn).Enabled=True) then begin
      if DirectoryExists(fn)=True then begin
        if isCanSetDrive(fn)=True then begin
          str:=fn+' '+GetDriveTypeName(fn)+' ['+GetDriveInfomation(fn).VolumeLabel+']';
          if FileExists(fn+VersionFilename)=True then tagidx:=DrvSel.DriveLst.Items.Count;
          DrvSel.DriveLst.Items.Add(str);
        end;
      end;
    end;
  end;

  if DrvSel.DriveLst.Items.Count=0 then exit;

  if tagidx=-1 then tagidx:=DrvSel.DriveLst.Items.Count-1;
  DrvSel.DriveLst.ItemIndex:=tagidx;

  Result:=True;
end;

procedure TDrvSel.OKBtnClick(Sender: TObject);
begin
  TargetDrive:=copy(DriveLst.Text,1,2);
end;

end.
