unit MainWin;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ComCtrls, ExtCtrls, Buttons, ExtDlgs, Menus,ShellAPI,
  jpeg;

type
  TMain = class(TForm)
    StartupTimer: TTimer;
    ReadmeMemo: TMemo;
    PrgBar: TProgressBar;
    DDLbl: TLabel;
    GlassLbl: TLabel;
    PastelLbl: TLabel;
    GlassLevBar: TTrackBar;
    PastelLevBar: TTrackBar;
    PastelLevLbl: TLabel;
    GlassLevLbl: TLabel;
    PastelColImg: TImage;
    PrvSrcImg: TImage;
    PrvDstImg: TImage;
    CancelBtn: TBitBtn;
    MoreSettingBtn: TBitBtn;
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure StartupTimerTimer(Sender: TObject);
    procedure PastelLevBarChange(Sender: TObject);
    procedure GlassLevBarChange(Sender: TObject);
    procedure PastelColImgClick(Sender: TObject);
    procedure CancelBtnClick(Sender: TObject);
    procedure MoreSettingBtnClick(Sender: TObject);
  private
    { Private 錾 }
    procedure WMDROPFILES(var msg:TWMDROPFILES);message WM_DROPFILES;
    procedure CreateThumb(basepath:string);
    procedure CreatePreview(filename:string);
    procedure RefreshPreviewImage;
  public
    { Public 錾 }
    PastelColor:dword;
  end;

var
  Main: TMain;

implementation

{$R *.dfm}

uses _inifile, SelMLWin,_SplitML,_PicTools,_m_Tools,_loadimage,zlib,
  ColorPickWin, OptionWin;

const CRLF:string=char($0d)+char($0a);

var
  StartPath:string;

procedure TMain.FormCreate(Sender: TObject);
begin
  StartPath:=ExtractFilePath(Application.ExeName);

  Application.Title:='BG package maker for MoonShell2.';
  Main.Caption:=Application.Title;

  DragAcceptFiles(Main.handle,True); // D&D Start

  StartupTimer.Enabled:=True;
end;

procedure TMain.StartupTimerTimer(Sender: TObject);
begin
  StartupTimer.Enabled:=False;

  ReadmeMemo.Clear;
  ReadmeMemo.Height:=Main.ClientHeight-ReadmeMemo.Top;

  if GetMLTypeLoaded=False then begin
    if SelML.ShowModal=mrCancel then begin
      Application.Terminate;
      exit;
    end;
  end;

  PastelColor:=$ffffff;

  LoadINI;

  SetMLBitBtn(CancelBtn);
  SetMLBitBtn(MoreSettingBtn);

  SetMLLbl(DDLbl);
  SetMLLbl(GlassLbl);
  SetMLLbl(PastelLbl);

  ReadmeMemo.Lines.LoadFromFile(StartPath+GetMLStr('readme_eng.txt|readme_jpn.txt'));

  Option.Caption:=GetMLStr(Option.Caption);

  SetMLChk(Option.AutoChangeChk);
  SetMLLbl(Option.AutoChangeTimeSecUnitLbl);

  SetMLChk(Option.Dither15bitChk);
  SetMLChk(Option.NotUseFilterWithDesktopChk);
  SetMLChk(Option.NotDrawHelpTextChk);
  SetMLChk(Option.SpaceClippingChk);

  SetMLChk(Option.SSApplyChk);
  SetMLChk(Option.SSUseFilterChk);
  SetMLChk(Option.SSNotDrawDaysChk);

  SetMLChk(Option.TopBottomSameImageChk);

  RefreshPreviewImage;
end;

procedure TMain.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  SaveINI;
  DragAcceptFiles(Main.handle,False); // D&D Stop
end;

procedure TMain.WMDROPFILES(var msg:TWMDROPFILES);
var
  Drop:hdrop;
  index:longint;
  idx:integer;
  Filename:string;
  filebuf:array[0..1024] of char;
  cnt:integer;
begin
  Filename:=StringOfChar(' ',1024);
  Drop:=msg.Drop;
  index:=DragQueryFile(Drop,$FFFFFFFF,nil,0);

  for idx:=0 to index-1 do begin
    DragQueryFileA(Drop,idx,filebuf,1024);
    Filename:='';
    cnt:=0;
    while ((filebuf[cnt]<>char($00)) and (cnt<1024)) do begin
      Filename:=Filename+filebuf[cnt];
      inc(cnt);
    end;
    if DirectoryExists(Filename)=False then begin
      Main.DDLbl.Caption:=GetMLStr('Show preview from file.|t@Cvr[摜쐬܂B')+' '+ExtractFilename(Filename);
      CreatePreview(Filename);
      break;
      end else begin
      if copy(Filename,length(Filename),1)<>'\' then Filename:=Filename+'\';
      CreateThumb(Filename);
    end;
  end;

  DragFinish(Drop);
end;

// -------------------------------------------------------

procedure GlassFilter(bm:TBitmap;x,y,w,h:integer;var dstbm:TBitmap;lev:integer);
var
  lx,ly:integer;
  dr,dg,db:integer;
  srcbm:array of byte;
  srcbmw,srcbmh:integer;
  pdstbm:PByteArray;
  procedure GetGlassPixel(x,y:integer);
  var
    g,v:integer;
    psx,pex:integer;
    psy,pey:integer;
    px,py:integer;
    ofs:integer;
  begin
    if lev=0 then begin
      ofs:=y*srcbmw*3;
      dr:=srcbm[ofs+(x*3)+0];
      dg:=srcbm[ofs+(x*3)+1];
      db:=srcbm[ofs+(x*3)+2];
      exit;
    end;

    psx:=x-lev;
    if psx<0 then psx:=0;
    pex:=x+lev;
    if (srcbmw-1)<pex then pex:=srcbmw-1;

    psy:=y-lev;
    if psy<0 then psy:=0;
    pey:=y+lev;
    if (srcbmh-1)<pey then pey:=srcbmh-1;

    g:=0;
    for py:=psy to pey do begin
      ofs:=py*srcbmw*3;
      for px:=psx to pex do begin
        v:=trunc(sqrt((abs(py-y)*abs(py-y))+(abs(px-x)*abs(px-x)))*$100);
        v:=v div lev;
        if v<$100 then begin
          v:=$100-v;
          dr:=dr+(srcbm[ofs+(px*3)+0]*v);
          dg:=dg+(srcbm[ofs+(px*3)+1]*v);
          db:=db+(srcbm[ofs+(px*3)+2]*v);
          g:=g+v;
        end;
      end;
    end;

    if g=0 then begin
      dr:=0;
      dg:=0;
      db:=0;
      exit;
    end;

    dr:=dr div g;
    dg:=dg div g;
    db:=db div g;
  end;
begin
  srcbmw:=bm.Width;
  srcbmh:=bm.Height;
  setlength(srcbm,srcbmw*srcbmh*3);
  for ly:=0 to srcbmh-1 do begin
    pdstbm:=bm.ScanLine[ly];
    MoveMemory(addr(srcbm[ly*srcbmw*3]),pdstbm,srcbmw*3);
  end;

  for ly:=0 to h-1 do begin
    pdstbm:=dstbm.ScanLine[ly];
    for lx:=0 to w-1 do begin
      dr:=0;
      dg:=0;
      db:=0;
      GetGlassPixel(x+lx,y+ly);
      pdstbm[lx*3+0]:=trunc(dr);
      pdstbm[lx*3+1]:=trunc(dg);
      pdstbm[lx*3+2]:=trunc(db);
    end;
  end;
end;

procedure PastelFilter(var bm:TBitmap;lev:integer;color:dword);
var
  x,y:integer;
  pbm:PByteArray;
  sr,sg,sb:integer;
  dr,dg,db:integer;
begin
  if lev=0 then exit;
  
  sr:=(color shr 16) and $ff;
  sg:=(color shr 8) and $ff;
  sb:=(color shr 0) and $ff;

  for y:=0 to bm.Height-1 do begin
    pbm:=bm.ScanLine[y];
    for x:=0 to bm.Width-1 do begin
      dr:=pbm[x*3+0];
      dg:=pbm[x*3+1];
      db:=pbm[x*3+2];
      dr:=((dr*($100-lev))+(sr*lev)) div $100;
      dg:=((dg*($100-lev))+(sg*lev)) div $100;
      db:=((db*($100-lev))+(sb*lev)) div $100;
      pbm[x*3+0]:=dr;
      pbm[x*3+1]:=dg;
      pbm[x*3+2]:=db;
    end;
  end;
end;

procedure TMain.RefreshPreviewImage;
var
  str:string;
  w,h:integer;
  bm:TBitmap;
begin
  PastelLevLbl.Caption:='---';
  PastelLevLbl.Refresh;
  GlassLevLbl.Caption:='---';
  GlassLevLbl.Refresh;

  w:=20;
  h:=20;
  with PastelColImg.Canvas do begin
    Brush.Color:=PastelColor;
    FillRect(Rect(0,0,w,h));
    Pen.Color:=$000000;
    dec(w);
    dec(h);
    MoveTo(0,0);
    LineTo(w,0);
    LineTo(w,h);
    LineTo(0,h);
    LineTo(0,0);
  end;

  w:=PrvSrcImg.Width;
  h:=PrvSrcImg.Height;
  bm:=TBitmap.Create;
  MakeBlankBM(bm,w,h,pf24bit);

  GlassFilter(PrvSrcImg.Picture.Bitmap,0,0,w,h,bm,GlassLevBar.Position);
  PastelFilter(bm,Main.PastelLevBar.Position,PastelColor);

  MakeBlankImg(PrvDstImg,pf24bit);
  BitBlt(PrvDstImg.Canvas.Handle,0,0,w,h,bm.Canvas.Handle,0,0,SRCCOPY);
  PrvDstImg.Refresh;

  str:=inttostr(PastelLevBar.Position);
  if str='0' then str:=GetMLStr('None|');
  PastelLevLbl.Caption:=str;
  PastelLevLbl.Refresh;

  str:=inttostr(GlassLevBar.Position);
  if str='0' then str:=GetMLStr('None|');
  GlassLevLbl.Caption:=str;
  GlassLevLbl.Refresh;
end;

// -------------------------------------------------------

type
  TImgFile=record
    FilenameW:widestring;
    ofsImage:dword;
    MsgBM,TopBM,BottomBM:TBitmap;
  end;

var
  ImgFiles:array of TImgFile;
  ImgFilesCount:integer;

procedure CreateImage(var ImgFile:TImgFile;var srcbm:TBitmap);
var
  w,h:integer;
  bm:TBitmap;
  ax,ay:integer;
  lev:double;
  downpos:integer;
begin
  w:=256;
  h:=192;

  if Option.TopBottomSameImageChk.Checked=True then begin
    downpos:=0;
    end else begin
    downpos:=h;
    if Option.SpaceClippingChk.Checked=True then inc(downpos,72);
  end;

  Main.PrgBar.Position:=Main.PrgBar.Position+1;
  Application.ProcessMessages;

  bm:=TBitmap.Create;
  LoadImage_ReduceFull(srcbm,bm,w,downpos+h);
  ax:=(bm.Width-w) div 2;
  ay:=(bm.Height-(downpos+h)) div 2;

  Main.PrgBar.Position:=Main.PrgBar.Position+1;
  Application.ProcessMessages;

  with ImgFile do begin
    MsgBM:=TBitmap.Create;
    MakeBlankBM(MsgBM,w,h,pf24bit);
    lev:=0.5;
    if Option.NotUseFilterWithDesktopChk.Checked=True then lev:=0.0;
    GlassFilter(bm,ax,ay,w,h,MsgBM,trunc(Main.GlassLevBar.Position*lev));
    PastelFilter(MsgBM,trunc(Main.PastelLevBar.Position*lev),Main.PastelColor);

    Main.PrgBar.Position:=Main.PrgBar.Position+1;
    Application.ProcessMessages;

    TopBM:=TBitmap.Create;
    MakeBlankBM(TopBM,w,h,pf24bit);
    lev:=0.5;
    GlassFilter(bm,ax,ay,w,h,TopBM,trunc(Main.GlassLevBar.Position*lev));
    PastelFilter(TopBM,trunc(Main.PastelLevBar.Position*lev),Main.PastelColor);

    Main.PrgBar.Position:=Main.PrgBar.Position+1;
    Application.ProcessMessages;

    BottomBM:=TBitmap.Create;
    MakeBlankBM(BottomBM,w,h,pf24bit);
    lev:=1.0;
    GlassFilter(bm,ax,ay+downpos,w,h,BottomBM,trunc(Main.GlassLevBar.Position*lev));
    PastelFilter(BottomBM,trunc(Main.PastelLevBar.Position*lev),Main.PastelColor);

    Main.PrgBar.Position:=Main.PrgBar.Position+1;
    Application.ProcessMessages;
  end;

  BitBlt(Main.PrvSrcImg.Canvas.Handle,0,0,w,h,bm.Canvas.Handle,ax,ay+downpos,SRCCOPY);
  Main.PrvSrcImg.Refresh;
  BitBlt(Main.PrvDstImg.Canvas.Handle,0,0,w,h,ImgFile.BottomBM.Canvas.Handle,0,0,SRCCOPY);
  Main.PrvDstImg.Refresh;

  Main.PrgBar.Position:=Main.PrgBar.Position+1;
  Application.ProcessMessages;

  bm.Free;
end;

procedure ConvertImage(basepath:string;var ImgFile:TImgFile);
var
  fn:string;
  srcbm:TBitmap;
begin
  fn:=basepath+ImgFile.FilenameW;

  srcbm:=TBitmap.Create;
  if LoadImage_LoadFromFile(srcbm,fn)=False then begin
    ShowMessage('Image file load error.'+CRLF+basepath+ImgFile.FilenameW);
    exit;
  end;

  CreateImage(ImgFile,srcbm);

  srcbm.Free;
end;

// --------------------------------------------------------------------

procedure zlibCompressBuf(const InBuf: Pointer; InBytes: Integer;
                      out OutBuf: Pointer; out OutBytes: Integer);
var
  strm: TZStreamRec;
  P: Pointer;
  function CCheck(code: Integer): Integer;
  begin
    Result := code;
    if code < 0 then raise ECompressionError.Create('ZLIB compress error!!'); //!!
  end;
begin
  FillChar(strm, sizeof(strm), 0);
  strm.zalloc := zlibAllocMem;
  strm.zfree := zlibFreeMem;
  OutBytes := ((InBytes + (InBytes div 10) + 12) + 255) and not 255;
  GetMem(OutBuf, OutBytes);
  try
    strm.next_in := InBuf;
    strm.avail_in := InBytes;
    strm.next_out := OutBuf;
    strm.avail_out := OutBytes;
    CCheck(deflateInit_(strm, 1, zlib_version, sizeof(strm)));
    try
      while CCheck(deflate(strm, Z_FINISH)) <> Z_STREAM_END do
      begin
        P := OutBuf;
        Inc(OutBytes, 256);
        ReallocMem(OutBuf, OutBytes);
        strm.next_out := PChar(Integer(OutBuf) + (Integer(strm.next_out) - Integer(P)));
        strm.avail_out := 256;
      end;
    finally
      CCheck(deflateEnd(strm));
    end;
    ReallocMem(OutBuf, strm.total_out);
    OutBytes := strm.total_out;
  except
    FreeMem(OutBuf);
    raise
  end;
end;

type
  TZLIB=record
    DecompSize:integer;
    DecompData:array of byte;
    CompSize:integer;
    CompData:array of byte;
  end;

procedure zlibCompress(var pZLIB:TZLIB);
var
  _EncData:PByteArray;
  _EncDataSize:integer;
begin
  pZLIB.CompSize:=0;

  if pZLIB.DecompSize<=0 then exit;

  zlibCompressBuf(pointer(pZLIB.DecompData),pZLIB.DecompSize,pointer(_EncData),_EncDataSize);

  if (_EncData=nil) or (_EncDataSize=0) then exit;

  pZLIB.CompSize:=_EncDataSize;
  setlength(pZLIB.CompData,pZLIB.CompSize);
  MoveMemory(@pZLIB.CompData[0],@_EncData[0],pZLIB.CompSize);

  pZLIB.CompSize:=(pZLIB.CompSize+3) and not 3;
  setlength(pZLIB.CompData,pZLIB.CompSize);

  FreeMem(_EncData,_EncDataSize);
end;

// --------------------------------------------------------------------

const BGPackFileID:dword=$31504742;
const BGPack_Flags_NotDrawHelpText=1 shl 0;
const BGPack_Flags_SSApply=1 shl 1;
const BGPack_Flags_SSUseFilter=1 shl 2;
const BGPack_Flags_SSNotDrawDays=1 shl 3;

procedure TMain.CreateThumb(basepath:string);
var
  FileLst:TStringList;
  idx:integer;
  datafn:string;
  wfs:TFileStream;
  HeaderSize:integer;
  procedure w8(dw:dword);
  begin
    wfs.WriteBuffer(dw,1);
  end;
  procedure w16(dw:dword);
  begin
    wfs.WriteBuffer(dw,2);
  end;
  procedure w32(dw:dword);
  begin
    wfs.WriteBuffer(dw,4);
  end;
  procedure wwidestr(ws:widestring);
  var
    tmp:widestring;
  begin
    tmp:=ws+widechar(0);
    w16(length(tmp));
    wfs.WriteBuffer(tmp[1],length(tmp)*2);
  end;
  procedure WriteHeader;
  var
    idx:integer;
    Flags:dword;
    sec:dword;
  begin
    w32(BGPackFileID);
    Flags:=0;
    if Option.NotDrawHelpTextChk.Checked=True then Flags:=Flags or BGPack_Flags_NotDrawHelpText;
    if Option.SSApplyChk.Checked=True then Flags:=Flags or BGPack_Flags_SSApply;
    if Option.SSUseFilterChk.Checked=True then Flags:=Flags or BGPack_Flags_SSUseFilter;
    if Option.SSNotDrawDaysChk.Checked=True then Flags:=Flags or BGPack_Flags_SSNotDrawDays;
    if Option.AutoChangeChk.Checked=False then begin
      sec:=0;
      end else begin
      sec:=1+Option.AutoChangeTimeSecLst.ItemIndex;
    end;
    Flags:=Flags or (sec shl 4);
    w32(Flags);
    w32(ImgFilesCount);
    w32(HeaderSize);

    for idx:=0 to ImgFilesCount-1 do begin
      with ImgFiles[idx] do begin
        w32(ofsImage);
      end;
    end;
  end;
  procedure WriteBitmap_ZLIB(var bm0,bm1,bm2:TBitmap);
  var
    w,h:integer;
    buf:array of word;
    bufcnt:integer;
    z:TZLIB;
    procedure storebm(var bm:TBitmap);
    var
      x,y:integer;
      pb:pbytearray;
      gr,gg,gb:dword;
      r,g,b:dword;
      col15:dword;
    begin
      gr:=0;
      gg:=0;
      gb:=0;
      for y:=0 to h-1 do begin
        pb:=bm.ScanLine[y];
        for x:=0 to w-1 do begin
          b:=gr+pb[x*3+0];
          if $ff<b then b:=$ff;
          g:=gg+pb[x*3+1];
          if $ff<g then g:=$ff;
          r:=gb+pb[x*3+2];
          if $ff<r then r:=$ff;
          col15:=((r shr 3) shl 0) or ((g shr 3) shl 5) or ((b shr 3) shl 10) or (1 shl 15);
          if Option.Dither15bitChk.Checked=True then begin
            gr:=r and $7;
            gg:=g and $7;
            gb:=b and $7;
          end;
          buf[bufcnt]:=col15;
          inc(bufcnt);
        end;
      end;
    end;
  begin
    w:=256;
    h:=192;
    setlength(buf,w*h*3);
    bufcnt:=0;

    storebm(bm0);
    storebm(bm1);
    storebm(bm2);

    z.DecompSize:=bufcnt*2;
    z.DecompData:=addr(buf[0]);
    z.CompSize:=0;
    setlength(z.CompData,z.DecompSize);
    zlibCompress(z);
    w32(z.CompSize);
    wfs.WriteBuffer(z.CompData[0],z.CompSize);
    while((wfs.Position and 3)<>0) do begin
      w8(0);
    end;
    Main.ReadmeMemo.Lines.Add(format('ZLIB compressed %d%% %dbyte.',[trunc(z.CompSize*100/z.DecompSize),z.CompSize]));
  end;
begin
  FileLst:=TStringList.Create;
  LoadImage_GetFilesLst(FileLst,basepath);

  if FileLst.Count=0 then begin
    ShowMessage(GetMLStr('Not found image files in folder.|tH_̒ɉ摜t@C܂B')+CRLF+basepath);
    FileLst.Free;
    exit;
  end;

  MoreSettingBtn.Visible:=False;
  MoreSettingBtn.Refresh;
  CancelBtn.Enabled:=True;
  CancelBtn.Visible:=True;
  CancelBtn.Refresh;
  
  ImgFilesCount:=FileLst.Count;
  setlength(ImgFiles,ImgFilesCount);
  for idx:=0 to ImgFilesCount-1 do begin
    with ImgFiles[idx] do begin
      FilenameW:=FileLst[idx];
      ofsImage:=0;
    end;
  end;

  ReadmeMemo.Lines.Text:=FileLst.Text;
  ReadmeMemo.Lines.Add('-------------');
  FileLst.Free;

  datafn:=StartPath+'bgpack.dat';
  wfs:=TFileStream.Create(datafn,fmCreate);

  HeaderSize:=0;

  WriteHeader;

  HeaderSize:=wfs.Position;

  PrgBar.Position:=0;
  PrgBar.Max:=ImgFilesCount*6;
  for idx:=0 to ImgFilesCount-1 do begin
    ReadmeMemo.Lines.Add(format('%d/%d %s',[1+idx,ImgFilesCount,ImgFiles[idx].FilenameW]));
    ReadmeMemo.Refresh;
//    PrgBar.Position:=idx;
    DDLbl.Caption:=GetMLStr('converting...|ϊc')+format(' %d/%d %s',[1+idx,ImgFilesCount,ImgFiles[idx].FilenameW]);
//    Main.Refresh;
    with ImgFiles[idx] do begin
      ConvertImage(basepath,ImgFiles[idx]);
      ofsImage:=wfs.Position;
      WriteBitmap_ZLIB(MsgBM,TopBM,BottomBM);
    end;
    Application.ProcessMessages;
    if CancelBtn.Enabled=False then break;
  end;
  PrgBar.Position:=0;

  if CancelBtn.Enabled=True then begin
    wfs.Position:=0;
    WriteHeader;
  end;

  wfs.Free;

  CancelBtn.Visible:=False;
  MoreSettingBtn.Visible:=True;
  MoreSettingBtn.Refresh;

  Main.Refresh;

  if CancelBtn.Enabled=False then begin
    DeleteFile(datafn);
    DDLbl.Caption:=GetMLStr('Canceled.|LZ܂B');
    ReadmeMemo.Lines.Add('Canceled.');
    ReadmeMemo.Refresh;
  end;

  if CancelBtn.Enabled=True then begin
    DDLbl.Caption:=GetMLStr('Complited.|ϊ܂B');
    MessageDlg(GetMLStr('BG package file "bgpack.dat" created.'+CRLF+'Please copy to moonshl2 folder in your SD card.|wipbP[Wt@C "bgpack.dat" 쐬܂B'+CRLF+'SDJ[hmoonshl2tH_ɃRs[ĂB'),mtInformation,[mbOK],0);
    ReadmeMemo.Lines.Add('Complited.');
    ReadmeMemo.Refresh;
  end;

  ReadmeMemo.Lines.SaveToFile(ChangeFileExt(Application.ExeName,'.log'));
end;

procedure TMain.CreatePreview(filename:string);
var
  ImgFile:TImgFile;
begin
  ReadmeMemo.Lines.Text:='';
  ReadmeMemo.Lines.Add('-------------');
  ReadmeMemo.Lines.Add('Create preview '+ExtractFilename(filename));

  PrgBar.Position:=0;
  PrgBar.Max:=6;

  ImgFile.FilenameW:=ExtractFilename(filename);
  ConvertImage(ExtractFilePath(filename),ImgFile);

  PrgBar.Position:=0;
  
  Main.Refresh;
end;

var
  LastPastelLev:integer=-1;
  LastGlassLev:integer=-1;

procedure TMain.PastelLevBarChange(Sender: TObject);
begin
  if LastPastelLev=PastelLevBar.Position then exit;
  LastPastelLev:=PastelLevBar.Position;
  RefreshPreviewImage;
end;

procedure TMain.GlassLevBarChange(Sender: TObject);
begin
  if LastGlassLev=GlassLevBar.Position then exit;
  LastGlassLev:=GlassLevBar.Position;
  RefreshPreviewImage;
end;

procedure TMain.PastelColImgClick(Sender: TObject);
begin
  ColorPick.StartPick($ff00ff);
  if ColorPick.ShowModal<>mrOk then exit;
  PastelColor:=ColorPick.PickColor;
  RefreshPreviewImage;
end;

procedure TMain.CancelBtnClick(Sender: TObject);
begin
  CancelBtn.Enabled:=False;
  Main.Refresh;
end;

procedure TMain.MoreSettingBtnClick(Sender: TObject);
begin
  SaveINI;
  if Option.ShowModal<>mrOk then LoadINI;
end;

end.

