unit MainWin;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, StdCtrls, Buttons, _SplitML,_dosbox,
  CheckLst;

type
  TMain = class(TForm)
    StartupTimer: TTimer;
    SetupBtn: TBitBtn;
    CancelBtn: TBitBtn;
    Title1Lbl: TLabel;
    Title2Lbl: TLabel;
    NDSROMLst: TListBox;
    Title3Lbl: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure StartupTimerTimer(Sender: TObject);
    procedure CancelBtnClick(Sender: TObject);
    procedure SetupBtnClick(Sender: TObject);
  private
    { Private 錾 }
  public
    { Public 錾 }
  end;

var
  Main: TMain;

function GetDLDICount:integer;
function GetDLDIName(idx:integer):string;

var
  StartPath,DLDIPath:string;

implementation

uses SelMLWin, _dldi,_dlditool;

{$R *.dfm}

const CRLF:string=char($0d)+char($0a);

var
  LogFilename:string;

procedure WriteLog(str:string);
var
  tf:TextFile;
begin
  AssignFile(tf,LogFilename);
  if FileExists(LogFilename)=False then begin
    Rewrite(tf);
    end else begin
    Append(tf);
  end;

  Writeln(tf,str);

  CloseFile(tf);

  Main.Caption:=str;
end;

procedure TMain.FormCreate(Sender: TObject);
begin
  Application.Title:='Auto DLDI patch tool for MoonShell2';
  Main.Caption:=Application.Title;

  StartPath:=ExtractFilePath(Application.ExeName);
  DLDIPath:=StartPath+'DLDI\';

  LogFilename:=ChangeFileExt(Application.ExeName,'.log');
  DeleteFile(LogFilename);

  StartupTimer.Enabled:=True;
end;

procedure EnumDLDI;
var
  res:integer;
  SearchRec: TSearchRec;
  name:string;
  DLDIInfo:TDLDIInfo;
begin
  Main.NDSROMLst.Clear;

  if DirectoryExists(DLDIPath)=False then exit;

  res:=FindFirst(DLDIPath+'*.dldi', (FaAnyFile), SearchRec);
  if res=0 then begin
    repeat
      if (SearchRec.Attr and faDirectory)=0 then begin
        name:=ChangeFileExt(SearchRec.Name,'');
        if GetDLDIInfo(DLDIPath+name+'.dldi',DLDIInfo)=True then begin
          Main.NDSROMLst.Items.Add(ansiuppercase(name)+' '+DLDIInfo.DeviceName);
        end;
      end;
      res:=FindNext(SearchRec);
    until (res<>0);
  end;
  FindClose(SearchRec);

  Main.NDSROMLst.Refresh;
end;

procedure TMain.StartupTimerTimer(Sender: TObject);
  function GetDriveFreeSize(path:string):int64;
  var
    drv:string;
    DSec,DByte,DFClus,DUClus:dword;
    DFreeByte:int64;
  begin
    drv:=UpperCase(copy(path,1,1))+':\';

    if GetDiskFreeSpace(addr(drv[1]),DSec,DByte,DFClus,DUClus)=True then begin
      DFreeByte:=DSec;
      DFreeByte:=DFreeByte*DByte*DFClus;
      end else begin
      DFreeByte:=0;
    end;

    Result:=DFreeByte;
  end;
begin
  StartupTimer.Enabled:=False;
  StartPath:=ExtractFilePath(Application.ExeName);

  NDSROMLst.ItemHeight:=trunc(NDSROMLst.ItemHeight*1.5);
  EnumDLDI;

  if GetMLTypeLoaded=False then begin
    if SelML.ShowModal=mrCancel then begin
      Application.Terminate;
      exit;
    end;
  end;

  SetMLLbl(Title1Lbl);
  SetMLLbl(Title2Lbl);
  SetMLLbl(Title3Lbl);

  SetMLBitBtn(SetupBtn);
  SetMLBitBtn(CancelBtn);
end;

procedure TMain.CancelBtnClick(Sender: TObject);
begin
  Main.Close;
end;

function GetDLDICount:integer;
begin
  Result:=Main.NDSROMLst.Items.Count;
end;

function GetDLDIName(idx:integer):string;
var
  name:string;
  p:integer;
begin
  name:=Main.NDSROMLst.Items[idx];
  p:=ansipos(' ',name);
  if p=0 then begin
    ShowMessage('Internal error');
    Result:='';
    end else begin
    Result:=copy(name,1,p-1);
  end;
end;

procedure ExecRom_CreateImageWithDLDI(DLDIName:string;prefix:string);
var
  srcfn:string;
  DLDIInfo:TDLDIInfo;
  ndsfn:string;
  wfs,rfs:TFileStream;
  DLDIPath:string;
  DLDIData:array of byte;
  DLDISize:integer;
  bsbuf:array[0..512-1] of byte;
  ndsbuf:array of byte;
  ndsbufsize:integer;
  procedure ClearDLDIHeader;
  begin
  end;
begin
  DLDIPath:=StartPath+'DLDI\';

  if GetDLDIInfo(DLDIPath+DLDIName+'.dldi',DLDIInfo)=False then exit;

  if DLDIInfo.FixDeviceName<>'' then begin
    ndsfn:=prefix+'_'+DLDIName+'_'+DLDIInfo.FixDeviceName+DLDIInfo.FileExt;
    end else begin
    ndsfn:=prefix+'_'+DLDIName+'_'+DLDIInfo.DeviceName+DLDIInfo.FileExt;
  end;

  WriteLog('Create ROM image and copy to "'+StartPath+ndsfn+'"');

  srcfn:=StartPath+'..\..\'+prefix+'.nds';
//  srcfn:='D:\MyDocuments\NDS\_RVDS\MoonShell2\200904132019_moonshell200beta10\'+prefix+'.nds';
  if FileExists(srcfn)=False then begin
    WriteLog('Not found source file. "'+srcfn+'"');
    exit;
  end;

  wfs:=TFileStream.Create(ndsfn,fmCreate);

  if DLDIInfo.BootStrap='None' then begin
    end else begin
    if DLDIInfo.BootStrap='M3' then begin
      rfs:=TFileStream.Create(DLDIPath+'M3_BootStrap.bin',fmOpenRead);
      rfs.ReadBuffer(bsbuf[0],512);
      rfs.Free;
      wfs.WriteBuffer(bsbuf[0],512);
      end else begin
      if DLDIInfo.BootStrap='SC' then begin
        rfs:=TFileStream.Create(DLDIPath+'SC_BootStrap.bin',fmOpenRead);
        rfs.ReadBuffer(bsbuf[0],512);
        rfs.Free;
        end else begin
        ShowMessage(DLDIInfo.BootStrap+' is unknown boot strap type.');
      end;
    end;
  end;

  rfs:=TFileStream.Create(srcfn,fmOpenRead);
  ndsbufsize:=rfs.Size;
  setlength(ndsbuf,ndsbufsize);
  rfs.ReadBuffer(ndsbuf[0],ndsbufsize);
  rfs.Free;

  if length(DLDIInfo.FixGameCode)=4 then begin
    ndsbuf[$0c+0]:=byte(DLDIInfo.FixGameCode[1]);
    ndsbuf[$0c+1]:=byte(DLDIInfo.FixGameCode[2]);
    ndsbuf[$0c+2]:=byte(DLDIInfo.FixGameCode[3]);
    ndsbuf[$0c+3]:=byte(DLDIInfo.FixGameCode[4]);
  end;

  rfs:=TFileStream.Create(DLDIPath+DLDIName+'.dldi',fmOpenRead);
  DLDISize:=rfs.Size;
  setlength(DLDIData,DLDISize);
  rfs.ReadBuffer(DLDIData[0],DLDISize);
  rfs.Free;

  DLDITool(addr(ndsbuf[0]),ndsbufsize,addr(DLDIData[0]),DLDISize);

  wfs.WriteBuffer(ndsbuf[0],ndsbufsize);

  wfs.Free;
end;

procedure TMain.SetupBtnClick(Sender: TObject);
var
  idx:integer;
  msg:string;
begin
  for idx:=0 to GetDLDICount-1 do begin
    ExecRom_CreateImageWithDLDI(GetDLDIName(idx),'moonshl2');
    ExecRom_CreateImageWithDLDI(GetDLDIName(idx),'moonshl2_DirectBoot');
  end;

  msg:=GetMLStr('DLDI path complited.|DLDIpb`܂B');
  WriteLog(msg);
  ShowMessage(msg);
  Main.Close
end;

end.
